/**
 * Arabic Sentiment Analysis
 *
 * Performing Arabic sentiment analysis using a statistical algorithm based on the log-odds model of the bi-radical roots.
 *
 * @author    Khaled Al-Sham'aa <khaled.alshamaa@gmail.com>
 * @copyright 2021, Khaled Al-Sham'aa
 * @license   LGPLv3
 * @version   1.0
 * @link      https://github.com/khaled-alshamaa/ar-php/blob/master/examples/ar_sentiment.js
 * @see       https://ar-php.org/github/examples/ar_sentiment.html
 */
 
var allStems = ["\u0621\u0621","\u0621\u0627","\u0621\u0628","\u0621\u062a","\u0621\u062b","\u0621\u062c","\u0621\u062d","\u0621\u062e","\u0621\u062f","\u0621\u0630","\u0621\u0631","\u0621\u0632","\u0621\u0633","\u0621\u0634","\u0621\u0635","\u0621\u0636","\u0621\u0637","\u0621\u0638","\u0621\u0639","\u0621\u063a","\u0621\u0641","\u0621\u0642","\u0621\u0643","\u0621\u0644","\u0621\u0645","\u0621\u0646","\u0621\u0647","\u0621\u0648","\u0621\u064a","\u0627\u0621","\u0627\u0627","\u0627\u0628","\u0627\u062a","\u0627\u062b","\u0627\u062c","\u0627\u062d","\u0627\u062e","\u0627\u062f","\u0627\u0630","\u0627\u0631","\u0627\u0632","\u0627\u0633","\u0627\u0634","\u0627\u0635","\u0627\u0636","\u0627\u0637","\u0627\u0638","\u0627\u0639","\u0627\u063a","\u0627\u0641","\u0627\u0642","\u0627\u0643","\u0627\u0644","\u0627\u0645","\u0627\u0646","\u0627\u0647","\u0627\u0648","\u0627\u064a","\u0628\u0621","\u0628\u0627","\u0628\u0628","\u0628\u062a","\u0628\u062b","\u0628\u062c","\u0628\u062d","\u0628\u062e","\u0628\u062f","\u0628\u0630","\u0628\u0631","\u0628\u0632","\u0628\u0633","\u0628\u0634","\u0628\u0635","\u0628\u0636","\u0628\u0637","\u0628\u0638","\u0628\u0639","\u0628\u063a","\u0628\u0641","\u0628\u0642","\u0628\u0643","\u0628\u0644","\u0628\u0645","\u0628\u0646","\u0628\u0647","\u0628\u0648","\u0628\u064a","\u062a\u0621","\u062a\u0627","\u062a\u0628","\u062a\u062a","\u062a\u062b","\u062a\u062c","\u062a\u062d","\u062a\u062e","\u062a\u062f","\u062a\u0630","\u062a\u0631","\u062a\u0632","\u062a\u0633","\u062a\u0634","\u062a\u0635","\u062a\u0636","\u062a\u0637","\u062a\u0638","\u062a\u0639","\u062a\u063a","\u062a\u0641","\u062a\u0642","\u062a\u0643","\u062a\u0644","\u062a\u0645","\u062a\u0646","\u062a\u0647","\u062a\u0648","\u062a\u064a","\u062b\u0621","\u062b\u0627","\u062b\u0628","\u062b\u062a","\u062b\u062b","\u062b\u062c","\u062b\u062d","\u062b\u062e","\u062b\u062f","\u062b\u0630","\u062b\u0631","\u062b\u0632","\u062b\u0633","\u062b\u0634","\u062b\u0635","\u062b\u0636","\u062b\u0637","\u062b\u0638","\u062b\u0639","\u062b\u063a","\u062b\u0641","\u062b\u0642","\u062b\u0643","\u062b\u0644","\u062b\u0645","\u062b\u0646","\u062b\u0647","\u062b\u0648","\u062b\u064a","\u062c\u0621","\u062c\u0627","\u062c\u0628","\u062c\u062a","\u062c\u062b","\u062c\u062c","\u062c\u062d","\u062c\u062e","\u062c\u062f","\u062c\u0630","\u062c\u0631","\u062c\u0632","\u062c\u0633","\u062c\u0634","\u062c\u0635","\u062c\u0636","\u062c\u0637","\u062c\u0638","\u062c\u0639","\u062c\u063a","\u062c\u0641","\u062c\u0642","\u062c\u0643","\u062c\u0644","\u062c\u0645","\u062c\u0646","\u062c\u0647","\u062c\u0648","\u062c\u064a","\u062d\u0621","\u062d\u0627","\u062d\u0628","\u062d\u062a","\u062d\u062b","\u062d\u062c","\u062d\u062d","\u062d\u062e","\u062d\u062f","\u062d\u0630","\u062d\u0631","\u062d\u0632","\u062d\u0633","\u062d\u0634","\u062d\u0635","\u062d\u0636","\u062d\u0637","\u062d\u0638","\u062d\u0639","\u062d\u063a","\u062d\u0641","\u062d\u0642","\u062d\u0643","\u062d\u0644","\u062d\u0645","\u062d\u0646","\u062d\u0647","\u062d\u0648","\u062d\u064a","\u062e\u0621","\u062e\u0627","\u062e\u0628","\u062e\u062a","\u062e\u062b","\u062e\u062c","\u062e\u062d","\u062e\u062e","\u062e\u062f","\u062e\u0630","\u062e\u0631","\u062e\u0632","\u062e\u0633","\u062e\u0634","\u062e\u0635","\u062e\u0636","\u062e\u0637","\u062e\u0638","\u062e\u0639","\u062e\u063a","\u062e\u0641","\u062e\u0642","\u062e\u0643","\u062e\u0644","\u062e\u0645","\u062e\u0646","\u062e\u0647","\u062e\u0648","\u062e\u064a","\u062f\u0621","\u062f\u0627","\u062f\u0628","\u062f\u062a","\u062f\u062b","\u062f\u062c","\u062f\u062d","\u062f\u062e","\u062f\u062f","\u062f\u0630","\u062f\u0631","\u062f\u0632","\u062f\u0633","\u062f\u0634","\u062f\u0635","\u062f\u0636","\u062f\u0637","\u062f\u0638","\u062f\u0639","\u062f\u063a","\u062f\u0641","\u062f\u0642","\u062f\u0643","\u062f\u0644","\u062f\u0645","\u062f\u0646","\u062f\u0647","\u062f\u0648","\u062f\u064a","\u0630\u0621","\u0630\u0627","\u0630\u0628","\u0630\u062a","\u0630\u062b","\u0630\u062c","\u0630\u062d","\u0630\u062e","\u0630\u062f","\u0630\u0630","\u0630\u0631","\u0630\u0632","\u0630\u0633","\u0630\u0634","\u0630\u0635","\u0630\u0636","\u0630\u0637","\u0630\u0638","\u0630\u0639","\u0630\u063a","\u0630\u0641","\u0630\u0642","\u0630\u0643","\u0630\u0644","\u0630\u0645","\u0630\u0646","\u0630\u0647","\u0630\u0648","\u0630\u064a","\u0631\u0621","\u0631\u0627","\u0631\u0628","\u0631\u062a","\u0631\u062b","\u0631\u062c","\u0631\u062d","\u0631\u062e","\u0631\u062f","\u0631\u0630","\u0631\u0631","\u0631\u0632","\u0631\u0633","\u0631\u0634","\u0631\u0635","\u0631\u0636","\u0631\u0637","\u0631\u0638","\u0631\u0639","\u0631\u063a","\u0631\u0641","\u0631\u0642","\u0631\u0643","\u0631\u0644","\u0631\u0645","\u0631\u0646","\u0631\u0647","\u0631\u0648","\u0631\u064a","\u0632\u0621","\u0632\u0627","\u0632\u0628","\u0632\u062a","\u0632\u062b","\u0632\u062c","\u0632\u062d","\u0632\u062e","\u0632\u062f","\u0632\u0630","\u0632\u0631","\u0632\u0632","\u0632\u0633","\u0632\u0634","\u0632\u0635","\u0632\u0636","\u0632\u0637","\u0632\u0638","\u0632\u0639","\u0632\u063a","\u0632\u0641","\u0632\u0642","\u0632\u0643","\u0632\u0644","\u0632\u0645","\u0632\u0646","\u0632\u0647","\u0632\u0648","\u0632\u064a","\u0633\u0621","\u0633\u0627","\u0633\u0628","\u0633\u062a","\u0633\u062b","\u0633\u062c","\u0633\u062d","\u0633\u062e","\u0633\u062f","\u0633\u0630","\u0633\u0631","\u0633\u0632","\u0633\u0633","\u0633\u0634","\u0633\u0635","\u0633\u0636","\u0633\u0637","\u0633\u0638","\u0633\u0639","\u0633\u063a","\u0633\u0641","\u0633\u0642","\u0633\u0643","\u0633\u0644","\u0633\u0645","\u0633\u0646","\u0633\u0647","\u0633\u0648","\u0633\u064a","\u0634\u0621","\u0634\u0627","\u0634\u0628","\u0634\u062a","\u0634\u062b","\u0634\u062c","\u0634\u062d","\u0634\u062e","\u0634\u062f","\u0634\u0630","\u0634\u0631","\u0634\u0632","\u0634\u0633","\u0634\u0634","\u0634\u0635","\u0634\u0636","\u0634\u0637","\u0634\u0638","\u0634\u0639","\u0634\u063a","\u0634\u0641","\u0634\u0642","\u0634\u0643","\u0634\u0644","\u0634\u0645","\u0634\u0646","\u0634\u0647","\u0634\u0648","\u0634\u064a","\u0635\u0621","\u0635\u0627","\u0635\u0628","\u0635\u062a","\u0635\u062b","\u0635\u062c","\u0635\u062d","\u0635\u062e","\u0635\u062f","\u0635\u0630","\u0635\u0631","\u0635\u0632","\u0635\u0633","\u0635\u0634","\u0635\u0635","\u0635\u0636","\u0635\u0637","\u0635\u0638","\u0635\u0639","\u0635\u063a","\u0635\u0641","\u0635\u0642","\u0635\u0643","\u0635\u0644","\u0635\u0645","\u0635\u0646","\u0635\u0647","\u0635\u0648","\u0635\u064a","\u0636\u0621","\u0636\u0627","\u0636\u0628","\u0636\u062a","\u0636\u062b","\u0636\u062c","\u0636\u062d","\u0636\u062e","\u0636\u062f","\u0636\u0630","\u0636\u0631","\u0636\u0632","\u0636\u0633","\u0636\u0634","\u0636\u0635","\u0636\u0636","\u0636\u0637","\u0636\u0638","\u0636\u0639","\u0636\u063a","\u0636\u0641","\u0636\u0642","\u0636\u0643","\u0636\u0644","\u0636\u0645","\u0636\u0646","\u0636\u0647","\u0636\u0648","\u0636\u064a","\u0637\u0621","\u0637\u0627","\u0637\u0628","\u0637\u062a","\u0637\u062b","\u0637\u062c","\u0637\u062d","\u0637\u062e","\u0637\u062f","\u0637\u0630","\u0637\u0631","\u0637\u0632","\u0637\u0633","\u0637\u0634","\u0637\u0635","\u0637\u0636","\u0637\u0637","\u0637\u0638","\u0637\u0639","\u0637\u063a","\u0637\u0641","\u0637\u0642","\u0637\u0643","\u0637\u0644","\u0637\u0645","\u0637\u0646","\u0637\u0647","\u0637\u0648","\u0637\u064a","\u0638\u0621","\u0638\u0627","\u0638\u0628","\u0638\u062a","\u0638\u062b","\u0638\u062c","\u0638\u062d","\u0638\u062e","\u0638\u062f","\u0638\u0630","\u0638\u0631","\u0638\u0632","\u0638\u0633","\u0638\u0634","\u0638\u0635","\u0638\u0636","\u0638\u0637","\u0638\u0638","\u0638\u0639","\u0638\u063a","\u0638\u0641","\u0638\u0642","\u0638\u0643","\u0638\u0644","\u0638\u0645","\u0638\u0646","\u0638\u0647","\u0638\u0648","\u0638\u064a","\u0639\u0621","\u0639\u0627","\u0639\u0628","\u0639\u062a","\u0639\u062b","\u0639\u062c","\u0639\u062d","\u0639\u062e","\u0639\u062f","\u0639\u0630","\u0639\u0631","\u0639\u0632","\u0639\u0633","\u0639\u0634","\u0639\u0635","\u0639\u0636","\u0639\u0637","\u0639\u0638","\u0639\u0639","\u0639\u063a","\u0639\u0641","\u0639\u0642","\u0639\u0643","\u0639\u0644","\u0639\u0645","\u0639\u0646","\u0639\u0647","\u0639\u0648","\u0639\u064a","\u063a\u0621","\u063a\u0627","\u063a\u0628","\u063a\u062a","\u063a\u062b","\u063a\u062c","\u063a\u062d","\u063a\u062e","\u063a\u062f","\u063a\u0630","\u063a\u0631","\u063a\u0632","\u063a\u0633","\u063a\u0634","\u063a\u0635","\u063a\u0636","\u063a\u0637","\u063a\u0638","\u063a\u0639","\u063a\u063a","\u063a\u0641","\u063a\u0642","\u063a\u0643","\u063a\u0644","\u063a\u0645","\u063a\u0646","\u063a\u0647","\u063a\u0648","\u063a\u064a","\u0641\u0621","\u0641\u0627","\u0641\u0628","\u0641\u062a","\u0641\u062b","\u0641\u062c","\u0641\u062d","\u0641\u062e","\u0641\u062f","\u0641\u0630","\u0641\u0631","\u0641\u0632","\u0641\u0633","\u0641\u0634","\u0641\u0635","\u0641\u0636","\u0641\u0637","\u0641\u0638","\u0641\u0639","\u0641\u063a","\u0641\u0641","\u0641\u0642","\u0641\u0643","\u0641\u0644","\u0641\u0645","\u0641\u0646","\u0641\u0647","\u0641\u0648","\u0641\u064a","\u0642\u0621","\u0642\u0627","\u0642\u0628","\u0642\u062a","\u0642\u062b","\u0642\u062c","\u0642\u062d","\u0642\u062e","\u0642\u062f","\u0642\u0630","\u0642\u0631","\u0642\u0632","\u0642\u0633","\u0642\u0634","\u0642\u0635","\u0642\u0636","\u0642\u0637","\u0642\u0638","\u0642\u0639","\u0642\u063a","\u0642\u0641","\u0642\u0642","\u0642\u0643","\u0642\u0644","\u0642\u0645","\u0642\u0646","\u0642\u0647","\u0642\u0648","\u0642\u064a","\u0643\u0621","\u0643\u0627","\u0643\u0628","\u0643\u062a","\u0643\u062b","\u0643\u062c","\u0643\u062d","\u0643\u062e","\u0643\u062f","\u0643\u0630","\u0643\u0631","\u0643\u0632","\u0643\u0633","\u0643\u0634","\u0643\u0635","\u0643\u0636","\u0643\u0637","\u0643\u0638","\u0643\u0639","\u0643\u063a","\u0643\u0641","\u0643\u0642","\u0643\u0643","\u0643\u0644","\u0643\u0645","\u0643\u0646","\u0643\u0647","\u0643\u0648","\u0643\u064a","\u0644\u0621","\u0644\u0627","\u0644\u0628","\u0644\u062a","\u0644\u062b","\u0644\u062c","\u0644\u062d","\u0644\u062e","\u0644\u062f","\u0644\u0630","\u0644\u0631","\u0644\u0632","\u0644\u0633","\u0644\u0634","\u0644\u0635","\u0644\u0636","\u0644\u0637","\u0644\u0638","\u0644\u0639","\u0644\u063a","\u0644\u0641","\u0644\u0642","\u0644\u0643","\u0644\u0644","\u0644\u0645","\u0644\u0646","\u0644\u0647","\u0644\u0648","\u0644\u064a","\u0645\u0621","\u0645\u0627","\u0645\u0628","\u0645\u062a","\u0645\u062b","\u0645\u062c","\u0645\u062d","\u0645\u062e","\u0645\u062f","\u0645\u0630","\u0645\u0631","\u0645\u0632","\u0645\u0633","\u0645\u0634","\u0645\u0635","\u0645\u0636","\u0645\u0637","\u0645\u0638","\u0645\u0639","\u0645\u063a","\u0645\u0641","\u0645\u0642","\u0645\u0643","\u0645\u0644","\u0645\u0645","\u0645\u0646","\u0645\u0647","\u0645\u0648","\u0645\u064a","\u0646\u0621","\u0646\u0627","\u0646\u0628","\u0646\u062a","\u0646\u062b","\u0646\u062c","\u0646\u062d","\u0646\u062e","\u0646\u062f","\u0646\u0630","\u0646\u0631","\u0646\u0632","\u0646\u0633","\u0646\u0634","\u0646\u0635","\u0646\u0636","\u0646\u0637","\u0646\u0638","\u0646\u0639","\u0646\u063a","\u0646\u0641","\u0646\u0642","\u0646\u0643","\u0646\u0644","\u0646\u0645","\u0646\u0646","\u0646\u0647","\u0646\u0648","\u0646\u064a","\u0647\u0621","\u0647\u0627","\u0647\u0628","\u0647\u062a","\u0647\u062b","\u0647\u062c","\u0647\u062d","\u0647\u062e","\u0647\u062f","\u0647\u0630","\u0647\u0631","\u0647\u0632","\u0647\u0633","\u0647\u0634","\u0647\u0635","\u0647\u0636","\u0647\u0637","\u0647\u0638","\u0647\u0639","\u0647\u063a","\u0647\u0641","\u0647\u0642","\u0647\u0643","\u0647\u0644","\u0647\u0645","\u0647\u0646","\u0647\u0647","\u0647\u0648","\u0647\u064a","\u0648\u0621","\u0648\u0627","\u0648\u0628","\u0648\u062a","\u0648\u062b","\u0648\u062c","\u0648\u062d","\u0648\u062e","\u0648\u062f","\u0648\u0630","\u0648\u0631","\u0648\u0632","\u0648\u0633","\u0648\u0634","\u0648\u0635","\u0648\u0636","\u0648\u0637","\u0648\u0638","\u0648\u0639","\u0648\u063a","\u0648\u0641","\u0648\u0642","\u0648\u0643","\u0648\u0644","\u0648\u0645","\u0648\u0646","\u0648\u0647","\u0648\u0648","\u0648\u064a","\u064a\u0621","\u064a\u0627","\u064a\u0628","\u064a\u062a","\u064a\u062b","\u064a\u062c","\u064a\u062d","\u064a\u062e","\u064a\u062f","\u064a\u0630","\u064a\u0631","\u064a\u0632","\u064a\u0633","\u064a\u0634","\u064a\u0635","\u064a\u0636","\u064a\u0637","\u064a\u0638","\u064a\u0639","\u064a\u063a","\u064a\u0641","\u064a\u0642","\u064a\u0643","\u064a\u0644","\u064a\u0645","\u064a\u0646","\u064a\u0647","\u064a\u0648","\u064a\u064a"];
var logOddStem = [-3.965,-0.855,-3.032,-0.153,-4.024,-4.673,-2.63,-4.404,-2.524,-4.655,-2.479,-3.843,-2.685,-4.803,-5.562,-6.147,-5.08,-6.44,-1.397,-6.54,-2.785,-3.066,-3.252,-1.213,-1.811,-2.067,-1.119,-3.108,-1.019,1.366,3.174,2.036,3.064,0.64,1.015,1.383,0.828,1.75,-0.007,2.385,0.299,1.691,0.533,0.741,0.222,0.639,-0.491,1.651,0.079,1.547,1.607,1.35,3.405,2.338,2.481,1.967,1.865,2.664,-1.032,1.782,-0.074,1.296,-1.547,-1.26,-0.478,-1.682,0.412,-1.852,0.624,-2.199,-0.073,-0.867,-1.366,-0.827,-0.613,-3.069,0.365,-1.252,-0.967,-0.271,-0.217,1.034,-0.027,0.615,0.762,0.088,1.139,-1.488,1.852,1.011,0.985,-1.325,-0.236,-0.01,-0.697,0.214,-1.776,1.021,-0.849,-0.39,-0.772,-0.66,-1.526,-0.906,-1.788,0.542,-1.593,0.213,0.427,0.155,0.863,0.742,0.622,0.97,0.519,1.385,-2.442,-0.268,-2.971,-0.781,-1.888,-4.307,-6.706,-7.199,-5.865,-7.725,-0.226,-7.764,-6.72,-6.706,-7.616,-8.418,-6.994,-8.418,-6.238,-5.442,-3.015,-2.446,-4.747,-1.123,-1.866,-1.265,-1.942,-2.225,-0.455,-1.402,0.843,-0.281,0.485,-4.354,-3.312,-2.318,-5.818,0.717,-3.141,-0.675,-0.968,-1.902,-3.464,-5.966,-6.238,-5.549,-6.034,-0.521,-5.293,-3.32,-5.025,-2.598,-0.077,0.076,-0.193,-0.196,-0.358,0.495,-2.68,1.085,-0.331,0.967,-0.523,-0.965,-3.301,-6.1,0.181,-3.553,-0.316,-1.711,-0.86,-2.429,-2.354,-2.334,-2.676,-1.896,-4.936,-6.601,-1.725,-0.449,-0.879,-0.06,0.063,-0.417,-0.201,-0.296,0.579,-2.723,0.442,-1.651,0.235,-5.442,-1.811,-6.108,-4.629,-0.97,-2.32,-0.086,-3.697,-2.505,-3.649,-0.325,-3.521,-1.547,-6.614,-3.395,-6.958,-0.961,-2.418,-3.215,-0.067,-0.796,-1.376,-1.026,-1.016,0.028,-1.296,1.212,-1.73,0.8,-0.874,-2.17,-3.324,-1.456,-0.875,-6.085,-0.165,-3.971,-1.918,-2.629,-5.108,-5.841,-4.488,-5.665,-1.259,-4.083,-1.73,-0.289,-1.631,-0.613,0.173,-0.225,0.109,-0.078,0.664,-3.711,0.129,-1.778,-1.161,-7.687,-3.745,-5.086,-6.1,-6.196,-3.562,-1.389,-8.585,-7.051,-7.032,-8.093,-8.786,-7.687,-8.585,-4.414,-7.848,-4.708,-3.907,-0.688,-1.092,-4.078,-1.893,-0.752,-2.515,-0.791,-0.044,1.761,0.19,1.687,-3.275,-0.636,-0.415,-1.841,-0.481,-5.276,-0.813,-2.118,-0.947,-1.893,-2.596,-0.853,-2.105,-5.466,-0.309,-1.549,0.051,-0.492,-0.713,-0.851,-0.089,-0.135,0.733,0.61,1.391,-1.713,-0.347,-3.137,-0.778,-6.706,-1.569,-3.309,-4.95,-1.937,-7.805,-2.006,-2.715,-5.163,-5.576,-6.872,-7.582,-6.013,-7.013,-2.02,-5.064,-3.542,-3.281,-3.525,-1.427,-1.428,-1.205,-1.548,-1.586,-0.676,-0.566,1.195,0.231,1.223,-2.876,-1.708,-0.918,-1.755,-0.514,-3.095,0.253,-3.376,-1.163,-2.848,-4.035,-3.832,-0.757,-4.129,-0.17,-2.808,-0.952,-0.578,-1.1,0.374,-0.028,0.111,-0.023,0.023,0.874,-0.924,0.249,-1.282,-0.04,-5.883,-3.285,-2.95,-1.045,-1.31,-4.271,-0.139,-4.446,-3.678,-3.25,-1.142,-7.294,-2.568,-6.429,-0.867,-3.165,-1.602,-1.347,-0.798,-0.973,-2.261,-1.31,-0.596,-0.993,0.177,-2.961,0.265,-1.136,0.276,-7.013,-6.049,-0.479,-3.823,-1.113,-7.848,-0.191,-7.051,-6.179,-5.075,-1.605,-7.457,-3.098,-7.372,-1.774,-2.068,-0.726,-2.039,-3.576,-0.372,-1.968,-1.437,-0.789,-0.726,0.041,-2.566,-0.5,-2.719,-0.979,-7.892,-3.689,-1.877,-4.701,-3.683,-8.904,-1.689,-8.093,-6.72,-5.726,-7.428,-4.878,-3.101,-8.418,-0.958,-4.643,-1.345,-3.01,-2.896,-1.683,-2.435,-2.191,-1.568,-1.581,-0.598,-2.097,0.148,-0.82,-0.215,-7.091,-4.979,-2.45,-3.663,-3.812,-7.651,-0.46,-4.789,-4.054,-4.459,-6.976,-7.428,-3.43,-6.856,-0.769,-4.296,-1.374,-0.788,-3.785,-0.384,-1.296,-1.292,-1.162,-1.021,-0.218,-5.157,-0.897,-4.419,-1.059,-7.892,-6.958,-6.72,-7.051,-5.877,-8.68,-1.086,-7.987,-6.398,-6.601,-7.805,-7.892,-4.701,-5.972,-4.704,-7.399,-0.834,-5.83,-4.922,-2.257,-1.674,-1.971,-1.438,-2.746,-1.216,-1.79,1.496,0.039,0.904,-3.17,-0.836,-4.722,-5.549,0.58,-2.926,0.344,-1.688,-2.28,-1.063,-2.222,-0.937,-1.924,-2.445,-3.324,-6.056,-0.654,-0.615,-1.52,1.072,0.671,0.802,0.329,-0.303,0.913,-3.154,-0.504,-1.265,-0.442,-4.71,-5.785,-6.147,-6.763,-2.831,-5.218,0.23,-3.029,-3.147,-4.952,-3.97,-2.757,-3.028,-5.494,-5.446,-5.341,-0.747,-3.092,-4.176,-1.264,-1.493,-2.002,-1.275,-2.245,-0.027,-2.055,1.076,-2.328,0.834,-4.226,-2.091,-1.206,-2.928,-0.173,-2.769,0.23,-2.407,-0.503,-1.827,-1.434,-1.255,-1.063,-2.338,-0.846,-3.224,-1.632,0.078,-0.613,0.163,-0.777,0.15,0.51,-0.517,1.417,-0.703,1.111,-0.026,1.023,-6.027,-5.334,-3.387,-5.741,-0.002,-3.645,0.395,-3.687,-1.942,-2.664,-0.557,-2.299,-1.11,-4.276,-0.496,-6.212,-1.209,-1.18,-2.759,0.439,-0.202,-0.783,0.068,-0.369,0.531,-2.518,1.416,0.559,1.249,-0.585,-3.187,-3.603,-4.553,-1.403,-2.074,0.689,-2.779,-1.611,-2.189,-4.226,-4.957,-4.514,-5.511,-2.878,-4.593,-0.957,-3.18,-1.624,0.453,-0.007,1.049,-0.101,-0.248,0.517,0.392,3.065,1.538,2.56,-0.099,0.553,0.956,0.249,1.266,-0.275,1.867,-0.203,1.299,0.247,0.423,-0.476,0.306,-0.61,1.153,0.186,1.297,1.303,1.36,1.866,2.169,1.802,1.54,1.717,2.391,-0.9,2.106,-0.001,1.874,-1.203,-0.306,-0.138,-1.095,0.302,-1.58,0.919,-0.318,0.086,-0.235,-0.928,-0.891,-0.714,-1.313,0.962,-1.583,0.067,0.249,0.162,1.235,0.735,1.64,0.861,0.996,1.191,-1.224,1.641,-0.584,1.093,-3.145,-0.816,-1.025,-2.889,0.078,-2.247,-0.33,-1.763,0.063,-1.465,-1.003,-2.489,-1.545,-0.601,-0.772,-3.149,-0.06,-0.002,-0.813,-0.741,-0.143,-0.154,0.899,-0.155,1.122,-1.627,1.532,-1.618,-0.042,-4.931,-2.52,-4.165,-4.648,-0.931,-0.173,-0.96,-2.789,-3.291,-2.538,-4.686,-4.025,-4.262,-5.494,-3.709,-5.293,-2.53,-2.78,-1.455,-0.871,0.185,-0.804,-0.276,-0.204,-0.018,-0.704,2.252,0.362,1.659,-1.627,0.154,0.059,-1.078,0.777,-1.399,0.878,-1.308,-0.009,-0.981,-0.432,-0.742,-0.839,-1.234,0.665,-1.602,0.412,0.536,0.118,1.561,0.837,1.155,0.938,0.543,1.495,-0.483,1.615,0.198,1.936,-1.244,-0.461,-0.331,-1.123,0.627,-2.201,1.049,-1.115,-0.083,-0.986,-1.448,-1.289,-1.212,-2.626,0.075,-2.203,0.057,0.2,-0.018,0.662,0.549,1.246,1.146,0.485,0.83];
var logOddPositive = [0.09,0.026,-0.082,0.036,0.188,-0.024,-0.485,-0.139,-0.028,-0.042,0.051,-0.291,0.01,0.055,0.08,-0.132,-0.165,0.105,0.673,-0.577,-0.092,0.213,0.171,0.089,0.102,0.065,-0.01,0.04,0.113,0.102,0.001,-0.043,-0.022,-0.059,-0.03,0.023,-0.001,0.011,0.064,-0.002,0.057,0.013,0.001,-0.022,-0.053,0.009,0.026,0.081,-0.148,-0.046,0.01,-0.015,-0.004,0.035,0.031,-0.001,-0.022,-0,0.02,-0.034,-0.003,0.003,-0.002,0.003,0.027,-0.003,0.012,-0.022,0.008,0.011,-0.089,-0.019,-0.025,-0.156,-0.067,-0.086,-0.044,-0.174,-0.031,0.015,-0.025,-0.071,-0.011,0.005,-0.014,-0.081,0,0.302,0.027,-0.043,0.048,0.254,-0.008,0.082,0.007,-0.003,0.062,-0,0.308,0.036,-0.039,-0.015,-0.057,-0.001,-0.11,0.074,-0.038,-0.006,0.005,0.039,0.01,0.034,0.071,0.007,-0.024,0.015,0.565,0.01,0.227,0.135,-0.308,-0.131,0.554,0.445,0.279,0.543,-0.002,0.177,0.089,-0.092,0.124,-0.778,-0.123,-0.373,0.26,0.127,-0.025,0.014,0.195,-0.101,0.039,0.192,-0.018,0.105,0.067,-0.093,0.023,0.049,-0.072,0.116,-0.026,0.104,0.039,0.031,0.059,0.03,-0.146,-0.052,-0.166,-0.117,-0.218,-0.092,-0.094,0.107,0.207,0.096,0.105,0.196,0.134,0.07,0.052,-0.047,-0.013,0.115,0.047,-0.005,0.064,-0.022,-0.041,-0.201,0.028,-0.005,-0.042,-0.093,0.039,-0.086,-0.041,-0.457,-0.012,-0.012,-0.022,0.13,0.016,0.295,0.173,0.144,0.066,0.03,0.016,0.108,0.037,-0.03,0.061,-0.057,-0.014,-0.34,0,0.157,-0.05,0.225,-0.879,-0.05,-0.013,-0.049,0.086,0.001,-0.064,-0.041,0.112,-0.056,0.361,-0.106,-0.224,-0.036,0.141,0.301,0.028,0.021,-0.025,-0.031,0.03,-0.072,0.219,0.005,0.009,-0.004,-0.073,-0.096,-0.078,-0.03,0.037,0.002,0.025,-0.208,0.127,-0.019,-0.228,-0.385,-0.074,0.079,0.082,0.034,-0.055,0.049,0.159,0.012,-0.054,0.037,-0.026,0.035,-0.025,0.036,0.008,0.083,0.056,0.362,-0.376,0.159,0.254,0.113,0.418,-0.068,-0.206,-0.199,-0.46,-0.411,0.282,0.195,0.082,-0.064,0.155,-0.005,0.181,-0.012,-0.029,-0.018,0.1,0.044,0.03,0.083,0.196,0.045,0.013,-0.012,0.12,-0.054,0.15,0.107,-0.039,0.021,-0.105,-0.001,0.04,-0.119,-0.038,-0.164,0.04,-0.093,0.353,-0.027,-0.104,0.093,0.088,0.039,-0.001,0.055,-0.007,0.004,-0.013,-0.172,-0.037,-0.149,-0.047,-0.005,-0.234,-0.07,0.037,-0.021,0.113,0.124,-0.223,0.164,-0.253,-0.073,-0.228,0.055,0.259,-0.274,0.05,0.036,-0.035,0.202,-0.036,0.022,0.088,0.041,-0.06,-0.037,-0.24,0.019,-0.082,0.04,0.788,0.041,0.106,-0.254,0.026,0.058,0.005,-0.336,0.004,-0.02,0.018,-0.11,0.065,0.085,0.074,-0.118,-0.14,0.056,0.077,-0.017,0.054,0.144,-0.029,-0.069,-0.018,0.069,0.024,-0.034,-0.037,0.168,0.17,0.019,-0.075,0.063,-0.129,0.09,-0.419,0.093,0.136,-0.103,0.044,0.026,0.177,0.083,-0.027,0.035,0.089,0.029,-0.151,0.073,-0.044,-0.028,-0.019,0.01,0.06,-0.023,0.046,-0.062,0.168,0.03,0.049,0.002,0.029,0.26,-0.029,-0.354,-0.127,-0.19,-0.19,-0.035,-0.05,0.121,0.027,-0.037,-0.109,0.115,0.226,-0.053,0.092,-0.064,-0.065,-0.026,-0.049,0.029,-0.005,0.008,-0.08,-0.899,-0.36,-0.048,0.069,0.111,-0.655,-0.017,-0.698,-0.078,-0.38,-0.064,-0.329,-0.006,-1.472,-0.42,-0.071,-0.398,-0.229,0.039,-0.003,-0.003,-0.022,-0.12,-0.122,-0.317,-0.083,0.036,-0.107,-0.054,-0.401,0.024,-0.27,-0.153,0.047,0.159,0.042,0.265,0.037,0.083,-0.141,-0.853,0.093,0.298,0.007,0.059,0.002,0.039,0.116,-0.099,0.175,0.168,0.007,0.014,0.003,0.127,0.034,0.039,0.016,-0.052,0.203,0.232,0.42,0.25,-1.209,-0.058,-0.111,0.246,-0.153,0.4,-0.052,-0.172,0.287,-0.032,-0.092,0.061,0.322,0.241,0.223,0.181,0.021,0.06,0.098,0.115,0.103,0.001,0.051,-0.016,0.026,-0.019,0.15,0.137,-0.044,0.126,0.026,-0.045,0.045,0.064,0.031,-0.178,-0.065,0.154,-0.52,-0.223,-0.164,0.08,0.115,0.025,0.032,0.002,0.046,0.04,-0.007,-0.041,-0.041,-0.063,0.002,-0.015,-0.154,-0.342,-0.236,0.046,0.099,-0.22,0.064,0.101,-0.332,0.26,-0.088,-0.059,0.093,-0.254,0.086,-0.267,-0.038,-0.033,-0.138,-0.026,0.074,-0.149,0.06,-0.211,0.019,-0.011,0.008,-0.059,-0.115,-0.062,-0.015,0.276,0.011,0.03,-0.027,-0.232,0.066,-0.402,-0.047,-0.117,-0.04,0.019,0.003,-0.203,0.067,-0.029,-0.06,-0.012,0.031,0.046,-0.055,-0.024,-0.014,0.04,0.004,0.004,-0.032,0.215,0.172,-0.269,0.128,-0.023,-0.315,0.028,-0.543,0.041,-0.104,-0.175,0.057,-0.184,0.259,-0.04,0.33,-0.078,0.336,0.232,-0.046,0.008,0.038,0.017,-0.054,0.007,-0.028,-0.054,-0.101,-0.078,-0.031,-0.252,0.041,-0.132,-0.092,-0.109,-0.043,0.05,-0.096,-0.044,-0.122,0.167,0.009,0.052,0.063,-0.138,0.037,-0.315,-0.001,0.064,0.037,-0.087,-0.112,-0.024,-0.029,0.02,-0.03,-0.056,-0.041,-0.097,-0.031,0.026,0.002,0.018,0.083,-0.02,-0.072,-0.028,-0.017,-0.072,-0.06,0.019,0.055,0.04,-0.192,-0.066,0,-0.066,-0.039,-0.004,0.009,-0.007,-0.031,-0.014,0.006,0.028,-0.159,0.083,-0.04,-0.05,0.045,-0.177,-0.008,0.035,-0.015,0.412,-0.032,-0.219,-0.037,-0.317,-0.007,-0.003,0.027,-0.23,-0.068,-0.086,-0.039,-0.066,0.054,0.041,0.006,-0.068,0.03,0.201,0.046,0.064,0.002,0.041,-0.146,0.212,0.065,-0.005,0.057,0.025,0.006,0.064,-0.082,0.047,0.065,0.024,0.046,0.038,0.054,0.031,0.003,0.083,0.018,-0.04,0.088,-0.023,0.013,0.029,0.194,-0.02,0.066,-0.016,0.107,0.047,0.033,-0.02,0.127,0.009,0.005,-0.019,-0.006,-0.099,0.02,-0.03,0.034,0.018,-0.041,0.096,-0.087,-0.103,-0.105,-0.015,0.059,0.004,-0.014,0.025,0.007,0.084,0.022,0.022,0.033,0.05,-0.009,0.069,0.068,0.018,0.01,0.059,-0,0.063,0.038,0.009,-0.152,0.079,0.109,0.043,-0.072,0.047,0.032,0.017,-0.008,0.067,0.046,0.01,0.039,-0.004,-0.261,0.02,0.02,0.025,0.019,0.028,0.083,0.061,0.044,0.064,-0.052,0.068,-0.01,0.049,0.012,0.008,0.032,0.036,0.057,0.001,-0.053,0.04,0.025,0.034,0.013,0.043,-0.039,0.005,0.045];
var logOddNegative = [-0.014,-0.003,0.033,0.019,-0.251,-0.003,0.349,-0.025,-0.003,-0.192,-0.129,0.292,-0.044,-0.234,-0.047,0.16,0.143,-0.017,-1.038,0.346,0.1,-0.242,-0.119,-0.102,-0.153,-0.04,0.059,-0.049,-0.029,-0.074,-0.013,0.028,0.007,0.006,0.007,-0.021,-0.013,0.001,-0.058,-0.02,-0.041,-0.011,0.014,0.005,0.018,-0.015,-0.021,-0.085,0.092,0.037,-0.009,0.019,-0.001,-0.029,-0.027,0.003,0.011,-0.004,-0.024,0.037,0.013,0.022,-0.021,0.053,-0.018,0.033,0.019,0.092,-0.006,0.048,0.042,0.013,0.046,0.011,0.048,0.058,0.023,0.139,0.038,0.027,0.04,0.046,0.01,-0.008,0.011,-0.004,-0.001,-0.233,-0.015,0.05,-0.035,-0.221,-0.021,-0.074,-0.024,-0.014,-0.01,-0.013,-0.256,-0.065,0.067,0.004,0.038,-0.035,0.02,-0.074,0.036,0.001,0.002,-0.021,-0.002,-0.026,-0.05,-0.003,0.015,-0.006,-0.484,-0.027,-0.16,-0.108,0.101,0.157,-0.586,-1.049,-0.081,-0.341,-0.046,-0.148,-0.093,0.107,-0.045,0.863,-0.091,-0.341,-0.064,-0.072,-0.176,-0.126,-0.366,0.035,-0.046,-0.119,-0.054,-0.199,-0.058,-0.035,0.006,-0.051,0.037,-0.176,0.097,-0.122,0.038,-0.001,-0.084,-0.009,0.089,0.062,0.176,0.219,0.018,0.086,0.027,-0.115,-0.234,-0.093,0.003,-0.174,-0.169,-0.084,-0.066,0.022,-0.037,-0.166,-0.051,-0.014,-0.079,0.024,-0.015,0.152,0.018,0.049,0.038,0.029,-0.05,0.129,-0.041,0.389,0.023,0.005,0.076,-0.166,-0.177,-0.312,-0.13,-0.101,-0.116,-0.051,-0.031,-0.198,-0.025,0.027,-0.076,0.052,0.014,0.457,-0.001,-0.046,0.031,-0.223,0.724,0.107,-0.033,0.034,0.019,0.124,0.103,0.026,-0.134,0.044,-0.536,0.137,0.191,-0.082,-0.109,-0.292,-0.036,0.045,0.038,0.026,-0.046,0.087,-0.257,0.031,0.067,0.024,0.013,0.149,0.1,0.003,-0.046,-0.109,-0.014,0.2,-0.129,0.091,0.102,0.246,-0.155,-0.115,-0.008,0.013,0.086,0.043,-0.175,-0.021,0.059,-0.015,0.026,-0.042,0.039,0.004,0.02,-0.076,-0.078,-0.225,0.392,-0.509,-0.425,-0.404,-0.475,0.074,0.519,0.285,0.352,0.432,0.027,-0.379,0.519,0.037,0.187,0.071,0.087,-0.034,-0.002,-0.002,-0.14,-0.015,0.001,-0.115,-0.129,-0.01,-0.04,0.038,-0.106,0.067,-0.116,-0.17,0.038,-0.038,0.144,-0.046,-0.052,0.142,0.08,-0.122,-0.089,-0.01,-0.337,-0.019,0.062,-0.086,-0.083,-0.015,-0.034,-0.053,0.02,0.026,-0.006,0.004,0.023,0.241,0.082,0.068,0.115,-0.047,-0.04,-0.005,-0.261,-0.093,0.316,-0.173,0.173,0.233,0.122,0.087,-0.206,0.129,-0.121,0.042,0.039,-0.19,0.069,-0.046,-0.098,-0.004,0.066,0.038,0.332,-0.01,0.045,-0.02,-0.908,-0.041,-0.061,0.256,-0.037,0.099,-0.04,0.297,-0.021,0.091,-0.073,0.074,-0.108,-0.073,-0.101,0.122,0.201,-0.033,-0.003,0.011,-0.043,-0.144,0.02,0.099,0.047,0.076,-0.005,-0.005,0.047,-0.286,-0.22,0.008,0.044,-0.038,0.234,-0.053,0.316,-0.142,0.063,0.065,-0.166,-0.04,-0.133,-0.112,0.065,-0.004,-0.119,-0.041,0.111,-0.046,0.07,0.023,0.029,0.062,-0.137,0.019,-0.049,0.057,-0.012,0.02,0.061,0.081,-0.032,0.187,0.005,0.027,0.128,0.323,0.13,-0.098,0.032,-0.288,-0.133,-0.077,0.122,-0.09,-0.206,0.021,-0.128,0.068,0.043,-0.009,0.011,-0.046,-0.029,-0.013,0.103,0.232,0.29,-0.023,-0.14,-0.022,0.655,-0.006,0.181,0.041,0.483,-0.127,0.329,0.062,0.958,0.391,0.113,0.445,0.049,-0.05,0.034,0.013,0.004,0.08,0.079,0.147,0.012,-0.027,0.093,0.056,-0.058,0.019,0.222,0.071,-0.008,-0.127,-0.073,-0.186,0.055,0.004,0.163,0.055,-0.109,-0.169,0.049,-0.315,-0.081,0.008,-0.071,0.101,-0.069,-0.186,-0.026,-0.041,-0.006,-0.294,-0.044,0.099,-0.04,0.232,-0.415,-0.304,-0.322,-0.243,-0.484,0.004,-0.261,0.037,0.209,-0.666,0.337,0.268,-0.359,0.189,0.314,-0.04,-0.077,-0.1,-0.276,-0.196,0.052,-0.07,-0.133,-0.092,-0.062,-0.001,-0.084,-0.01,-0.04,-0.041,-0.049,-0.283,0.024,-0.102,-0.042,0.054,-0.034,-0.001,-0.061,0.006,0.059,-0.124,0.334,0.168,0.228,-0.097,-0.108,0.008,-0.009,-0.001,-0.038,-0.049,0.04,0.096,0.044,0.021,-0.015,0.073,0.086,0.4,0.402,-0.051,-0.055,0.15,-0.101,-0.146,0.132,-0.253,0.029,0.15,-0.073,0.131,-0.422,0.149,0.02,0.026,0.108,-0.067,-0.042,0.1,-0.051,0.179,-0.033,0.014,-0.002,0.062,0.089,0.077,0.083,-0.15,0.055,0.002,0.025,0.216,-0.062,0.373,-0.054,0.117,0.055,0.03,0.03,0.213,-0.078,0.088,0.046,0.03,0.027,0.024,0.049,0.028,0.002,-0.016,0.014,-0.112,0.058,-0.193,-0.22,0.22,-0.006,0.014,0.411,0.003,0.456,-0.073,0.108,0.081,-0.074,0.165,-0.298,-0.011,-0.244,0.006,-0.257,-0.154,-0.004,0.044,-0.035,-0.016,-0.048,-0.007,-0.013,0.041,0.091,0.075,-0.02,0.167,-0.075,0.057,0.099,0.071,0.033,-0.109,0.051,0.069,-0.018,-0.156,-0.056,-0.142,-0.17,0.156,-0.034,0.186,0.042,0.007,0.012,0.053,0.11,0.018,0.008,-0.037,0.029,0.033,0.021,0.003,0.017,-0.045,-0.02,-0.01,-0.089,-0.01,0.045,0.02,0.023,0.031,0.025,-0.035,-0.053,-0.056,0.139,0.054,-0.008,0.036,0.064,0.016,-0.019,0.006,0.01,0.004,-0.005,-0.031,0.075,-0.067,0.015,0.015,-0.055,0.241,0.012,-0.011,-0.018,-0.434,0.027,0.22,-0.009,-0.023,-0.006,0.006,-0.052,0.179,0.049,-0.042,0.05,0.055,-0.04,-0.024,0.004,0.001,-0.04,-0.103,-0.04,-0.081,0.011,0.008,0.168,-0.137,-0.027,0.088,-0.116,-0.038,0.026,-0.061,0.081,0.03,-0.071,-0.039,-0.068,-0.052,-0.014,-0.032,0.05,-0.055,-0.02,0.074,-0.07,0.017,-0.032,-0.012,-0.192,0.022,0,0.044,0.009,-0.027,0.026,0.115,-0.107,0.053,0.027,-0.011,0.051,0.169,0.048,-0.053,0.105,-0.03,0.12,0.121,0.14,0.203,0.111,0.027,-0.061,0.017,0.032,-0.029,-0.013,-0.038,-0.011,-0.031,-0.037,-0.106,-0.011,-0.059,-0.02,-0.021,-0.031,-0.062,0,-0.064,0.02,0.002,0.082,-0.104,-0.048,-0.062,0.09,-0.055,-0.051,-0.021,0,-0.059,-0.041,-0.022,-0.056,0.006,0.314,-0.037,0.03,-0.012,-0.069,-0.014,-0.08,-0.102,-0.065,-0.072,0.03,-0.036,0.014,-0.017,-0.011,-0.05,-0.096,-0.037,-0.024,-0.008,0.088,-0.022,-0.012,-0.039,0.004,-0.036,0.027,0.017,-0.04];

function arSentiment(str, debug = false) {
    // set initial scores
    var positiveScore = 0;
    var negativeScore = 0;
    
    var isPositive;
    var probability;

    // remove mentions
    str = str.replace(/@\\S+/gu, '');
    
    // remove hashtags
    str = str.replace(/#\\S+/gu, '');
    
    // normalise Alef
    str = str.replace(/[أإآى]/gu, 'ا');
    
    // normalise Hamza
    str = str.replace(/[ؤئء]/gu, 'ء');
    
    // normalise Taa
    str = str.replace(/ة/gu, 'ه');
    
    // filter only Arabic text (white list)
    str = str.replace(/[^ ءابتثجحخدذرزسشصضطظعغفقكلمنهوي]+/gu, ' ');
    
    // exclude one letter words
    str = str.replace(/\\b\\S{1}\\b/gu, ' ');
    
    // remove extra spaces
    str = str.replace(/\\s{2,}/gu, ' ');
    str = str.replace(/^\\s+/gu, '');
    str = str.replace(/\\s+$/gu, '');
    
    // split string to words
    var words = str.split(/\s+/u);

    var negationWords = ['لا', 'ليس', 'غير', 'ما', 'لم', 'لن',
                        'لست', 'ليست', 'ليسا', 'ليستا', 'لستما',
                        'لسنا', 'لستم', 'ليسوا', 'لسن', 'لستن'];
    var negationFlag  = false;
  
    // for each word
    words.forEach(function(word) {
        if (word != '') {
            // split word to letters
            var letters = word.split('');
            var stems   = [];
            var logOdds = [];

            // get all possible 2 letters stems of current word
            for (var i = 0; i < letters.length - 1; i++) {
                for (var j = i + 1; j < letters.length; j++) {
                    // get stem key
                    stems.push(allStems.indexOf(letters[i] + letters[j]));
                }
            }

            // get log odd for all word stems
            stems.forEach(function(key) {
                logOdds.push(logOddStem[key]);
            });
            
            // select the most probable stem for current word
            var selStemKey = 0;
            
            for (var k = 1; k < logOdds.length; k++) {
                if (logOdds[k] < logOdds[selStemKey]) selStemKey = k;
            }
            
            var selStem = stems[selStemKey];

            if (negationFlag) {
                // switch positive/negative sentiment because of negation word effect
                positiveScore += -1 * logOddPositive[selStem];
                negativeScore += -1 * logOddNegative[selStem];

                if (debug) console.log(word + ' score ' + (Math.round((logOddNegative[selStem] - logOddPositive[selStem])*1000)/1000).toFixed(3));
                
                negationFlag = false;
            } else {
                // retrive the positive and negative log odd scores and accumulate them
                positiveScore += logOddPositive[selStem];
                negativeScore += logOddNegative[selStem];
                
                if (debug) console.log(word + ' score ' + (Math.round((logOddPositive[selStem] - logOddNegative[selStem])*1000)/1000).toFixed(3));
            }    

            if (negationWords.includes(word)) negationFlag = true;
        }
    });

    if (positiveScore > negativeScore) {
        isPositive  = true;
        probability = Math.exp(positiveScore) / (1 + Math.exp(positiveScore));
    } else {
        isPositive = false;
        probability = Math.exp(negativeScore) / (1 + Math.exp(negativeScore));
    }
    
    return [isPositive, probability];
}