Contributing to Elessar
=======================

Thanks for your contribution! Let's check a few things before you get started:

Code of Conduct
---

First and foremost, please read and follow the [Code of Conduct](CODE_OF_CONDUCT.md). This outlines what is and is not acceptible behaviour for participants in the repository, as well as how to raise a complaint.

Writing an issue
---

Please include:

- Your browser and operating system
- The code you're using to set up Elessar, including all configuration. If possible, create a [JSBin](http://jsbin.com/) to demonstrate the issue
- Concise but exact steps to reproduce the issue
- What you expected to happen, and what actually happened

Creating a Pull Request
---

- Elessar uses the [Angular Commit Message Conventions](https://gist.github.com/stephenparish/9941e89d80e2bc58a153). In short:
  - If it's a bugfix, prefix the message with `fix:`
  - If it's a new feature, prefix with `feat:`
  - If it introduces a breaking change, explain it with `BREAKING CHANGE:` in the [commit description](http://stackoverflow.com/questions/16122234)
- Take the time before pushing to run the tests locally, using `make test-local`. A more comprehensive test suite will run when you push
- Don't be disheartened if your PR is rejected! We appreciate the time you took, but not every change is a good fit. Stick around and keep contributing!
