<?php 
use Classes\Cookie;
use Illuminate\Database\Capsule\Manager as DB;
use Classes\Hash;
use Classes\Token;

require_once(__DIR__ . "/../../php/init.php");


function category_qty($cat,$list){
	$qty=0;
	foreach ($list as $key => $item) {
		$dish = dish($item['id']);
		
		if ($dish) {
			if ($dish->category_id()==$cat) {
				$qty+=$item['qty'];
			}
		}
	}
	

	return $qty;
}

$function = isset($_POST['f'])?$_POST['f']:(isset($_GET['f'])?$_GET['f']:'');


switch ($function) {

	case 'otp':
		$cart = json_decode($_POST['cart'],true);


		$branch = false;



		if (isset($cart['b'])) {
			if (strlen($cart['b'])>5) {
				$check = $db->row("SELECT * FROM branches WHERE id = ? ",[dr($cart['b'])]);

				if ($check) {
					$branch=$check;
				}
			}
		}


		$cart['messages']=[];	
		if (strlen($cart['customer']['phone'])==8  && $branch) {

			$phone = $cart['customer']['phone'];

			if (!isset($_SESSION['attempts'])) {
				$_SESSION['attempts']=0;
			}else{
				$_SESSION['attempts']+=1;
			}

			$attempts = $db->single("SELECT count(*) FROM login_otp WHERE phone=? AND date(created_at) =?",[$phone,date('Y-m-d')]);
			$attempts = ($_SESSION['attempts']+$attempts)/2;
			
			$delay = ($attempts-1)*10 + 60;

			$recent = $db->row("SELECT * FROM login_otp WHERE phone = ? AND created_at >= NOW() - INTERVAL ".$delay." SECOND",[$phone]);

			// var_dump($recent);

			if (!$recent) {
				$otp = rand ( 1000 , 9999 );

				$_SESSION['PHONE'] = $phone;
				$_SESSION['OTP_valid'] = false;
				$_SESSION['otp'] = $otp;

				

				$db->query("INSERT INTO login_otp(otp,phone) VALUES(?,?)",[$otp, $phone]);


				$sms = tr("Your OTP: ").$otp;
				
				sms_q($sms,$phone);
				$cart['delay']=$delay;
				$cart['messages']=[tr("We have send OTP to your phone ")];
				
			}else{

				$cart['delay']=$cart['delay']-date('s',time()-strtotime($recent['created_at']));
				$cart['messages']=[tr("OTP already sent to your phone. you can re attempt in few seconds")];
				
			}




		
		}

		echo json_encode($cart,JSON_NUMERIC_CHECK );
	break;
	case 'refresh':

			$cart = [
            	"code"=> md5(microtime(true)),
                "list"=>[],
            
                "discount"=>0,
                "price"=>0,
                "payable"=>0,
                "type"=>'In Store',
                "amount"=>0,
                "payment_method"=>'Cash',
                "note"=>'',
                "table"=>'',
                "totalBillPrice"=>0,
                "tax"=>0,
                "otp"=>'',
                "delay"=>0,
                "messages"=>[],
                // price_rate=>0,

                "customer"=>[
                    "name"=>'',
                    "phone"=>'',
                    "address"=>'',
                    "car"=>'',
                ],
                "b"=>$_GET['b']
            ];

			if (!isset($_SESSION['cart']) || !isset($_SESSION['code'])) {
				
				$_SESSION['cart']=$cart;
				$_SESSION['code']=md5(microtime(true));
			}
		

		$cart = json_decode($_POST['cart'],true);

		$branch=false;
		if (isset($cart['b'])) {
			if (strlen($cart['b'])>5) {
				$check = $db->row("SELECT * FROM branches WHERE id = ? ",[dr($cart['b'])]);

				if ($check) {
					$branch=$check;
				}
			}
		}

		$cart['messages']=[];
		$total= 0;
		$totaltax= 0;
		$totaldiscount= 0;

		for ($i=0; $i < count($cart['list']); $i++) { 
			$item = $cart['list'][$i];
			$dish = dish($item['id']);

			if ($dish) {
				$price = $dish->price($item['size']);
				$tax = $dish->tax();
				$discount =  0;
				$appdiscount=0;
				$category = $dish->category();
				$total_price=$price;

				if ($category['discount']>0) {
				
					if (category_qty($dish->category_id(),$cart['list']) >= $category['discount_qty']) {
						
						$total_price=$price-($price*$category['discount']/100);
						$totaldiscount+=($price*$category['discount']/100);
						$appdiscount=($price*$category['discount']/100);
						// console.log('totla')
						// console.log(pos.cart.list[i].price-(pos.cart.list[i].price*pos.cart.list[i].category.discount/100))
					}
				}


				$total_price = $total_price-($total_price*$discount/100);


				$selected_addons = $dish->validate_addons($item['selected_addons']);

				foreach ($selected_addons as $key => $addon) {
					if ($addon['price']>0) {
						$total_price+=$addon['price'];
					}
				}
			
				$itemtax=$total_price*$tax['percent']/100;
				$total_price+=$itemtax;

				$data = [

					"id"         => $dish->id(),
	                "name"       => $dish->name(),
	                "name_ar"       => $dish->name_ar(),
	                "description"=> $dish->description(),
	   
	                "sizes"      => $dish->size_and_price(),
	                "addons"     => $dish->addon_and_price(),
	                "discount"     => 0,
	                "appdiscount"     => $appdiscount,
	                "discountable"     => $dish->discountable(),
	                "max_discount"     => $dish->max_discount(),
	                "category"     => $dish->category(),
	            
	                "tax"     => $itemtax,
	                "tax_percent"     => $tax['percent'],
	                "price"     => $price,
	                "cat_id"=>$dish->category_id(),
	                "size"     => $dish->size($item['size']),
	                "total_price"=>$total_price,
	                "selected_addons"=>$selected_addons,
	                "note"=>isset($item['note'])?escap($item['note']):'',
	                "qty"=>(int)$item['qty'],
                ];

                $total+=$total_price*(int)$item['qty'];
                $totaltax+=(int)$item['qty']*$itemtax;
                


                $cart['list'][$i]=$data;

        

				
			}
		}

		
        $cart['totalBillPrice']=$total;
        $cart['tax']=$totaltax;
        $cart['discount']=$totaldiscount;
        $cart['code']=$_SESSION['code'];
        $cart['note']=isset($cart['note'])?escap($cart['note']):'';


		$_SESSION['cart']=$cart;

		// var_dump(Cookie::get("cart"));

		// var_dump($_POST['status']);
		// 
		if (isset($_POST['status'])) {
			$valid = true;
			$phone = $cart['customer']['phone'];
			$table = $cart['table'];
			$carplate = $cart['customer']['car'];

			if (!in_array($cart['type'], ["In Store","Take Away"])) {
				$valid=false;
				$cart['messages']=[tr("Select order type.")];
			}


			if ($cart['type']=="In Store") {
				if (strlen($table)<1 ) {
					$valid = false;
					$cart['messages']=[tr("Select table.")];
				}
			}

			// if ($cart['type']=="Take Away") {
			// 	if (strlen($cart['customer']['car'])<3 ) {
			// 		$valid = false;
			// 		$cart['messages']=[tr("Enter car plate.")];
			// 	}
			// }

			if (strlen($cart['customer']['phone'])!=8) {
				
					$valid = false;
					$cart['messages']=[tr("Invalid phone")];
				
			}

			if (strlen($cart['customer']['name'])<=2) {
				
					$valid = false;
					$cart['messages']=[tr("Invalid name")];
				
			}

			if (!isset($_SESSION['otp']) || !isset($cart['otp'])) {
				
					$valid = false;
					$cart['messages']=[tr("Enter OTP.")];
				
			}

			if ($branch && $valid) {

				


				if ( $_SESSION['PHONE'] == $cart['customer']['phone']) {
				
					if ((int)$cart['otp'] == $_SESSION['otp'] ) {

						$check_customer = DB::table("customers")->where("phone",(int)$cart['customer']['phone'])->count();

						if ($check_customer==0) {
							$customer_id = DB::table('customers')->insertGetId([
								"name"         =>$cart['customer']['name'],
								"phone"        =>(int)$cart['customer']['phone'],
							]);

							unset($_SESSION['otp']);
							unset($_SESSION['OTP_valid']);

							
							$customer = DB::table("customers")->where("id",$customer_id)->first();
						}else{
							$customer =  DB::table("customers")->where("phone",(int)$cart['customer']['phone'])->first();
						}

						$_SESSION['customer']=$customer->id;

						$order_id = DB::table('website_orders')->insertGetId([
							"customer_id"=>$customer->id,
							"cart"       =>json_encode($cart),
							"branch_id"       =>$branch['id'],
						
						
						]);

						$display->success(tr("Order created successfully."));

						$db->query("DELETE FROM login_otp WHERE phone = ?",[(int)$cart['customer']['phone']]);

						unset($_SESSION['cart']);
						unset($_SESSION['attempts']);

						die(json_encode(
							[
								"order"=>$app_url."/c/?v=completed&order=".cr($order_id)."&b=".cr($branch['id']),

							]
						));
						// $redirect->to($app_url."/c/?v=completed&order=".cr($order_id));
					}else{
						$cart['messages']=[tr("Invalid OTP.")];
					}
				}
			}
		}
		


		echo json_encode($cart,JSON_NUMERIC_CHECK );
		



	break;
	
	default:
		// code...
		break;
}

die;