
    <div class="container-fluid p-0 mb-5">
        <div id="blog-carousel" class="carousel slide overlay-bottom" data-ride="carousel">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img class="w-100" src="<?= file_get(get_option("cms_bg1")) ?>" alt="Image">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <h2 class="text-primary font-weight-medium m-0"></h2>
                        <h1 class="display-1 text-white m-0"><?= (get_option("cms_title")) ?></h1>
                        <h2 class="text-white m-0"><?= nl2br(get_option("cms_subtitle")) ?></h2>
                    </div>
                </div>
       
            </div>
            <a class="carousel-control-prev" href="#blog-carousel" data-slide="prev">
                <span class="carousel-control-prev-icon"></span>
            </a>
            <a class="carousel-control-next" href="#blog-carousel" data-slide="next">
                <span class="carousel-control-next-icon"></span>
            </a>
        </div>
    </div>
    <!-- Carousel End -->


    <!-- About Start -->
    <div class="container-fluid py-5">
        <div class="container">
            <div class="section-title">
                <h4 class="text-primary text-uppercase" style="letter-spacing: 5px;"></h4>
                <h1 class="display-4"><?= tr("Select a branch") ?></h1>
            </div>
            <div class="row justify-content-center">
                <?php foreach ($db->query("SELECT * FROM branches WHERE website=1 AND deleted_01=0 ") as $key => $item): ?>
                    <div class="col-lg-4 py-0 py-lg-5">
                       <a href="<?= $app_url ?>/c/?v=menu&b=<?= cr($item['id']) ?>">
                        <div class="card card-body shadow text-center text-light bg-primary">
                            <i class="fas fa-map-marker-alt  fa-2x"></i>
                            <br>
                            <h4 class="text-light"><?= $item[trl('address','address_en')] ?></h4>
                        </div>

                       </a>
                    </div>
                <?php endforeach ?>
                
                
            
            </div>
        </div>
    </div>
    <!-- About End -->

<?php if (count($db->query("SELECT * FROM dishes WHERE deleted_01=0 AND website=1 AND favorite=1"))): ?>
    
    <!-- Menu Start -->
<div class="container-fluid pt-5">
    <div class="container">
        <div class="section-title">
            <h4 class="text-primary text-uppercase" style="letter-spacing: 5px;"><?= tr("Favorite") ?></h4>
            <h1 class="display-4"><?= tr("Menu") ?></h1>
        </div>
        <div class="row justify-content-center">
            <?php foreach ($db->query("SELECT * FROM dishes WHERE deleted_01=0 AND website=1 AND favorite=1") as $key => $dish): ?>
            <?php
            $dish = dish($dish['id']);
            $data=[
            "id"         => $dish->id(),
            "name"       => $dish->name(),
            "name_ar"       => $dish->name_ar(),
            "description"=> $dish->description(),
            "cat_id"     => $dish->category_id(),
            "sizes"      => $dish->size_and_price(),
            "addons"     => $dish->addon_and_price(),
            "category"     => $dish->category(),
            "tax"     => $dish->tax(),
            ];
            $sizes = $data['sizes'];
            ?>
            <div class="col-md-4">
                <div class="row align-items-center mb-5">
                    <div class="col-4 align-items-center">
                        
                        <div class="w-100 h-100 rounded-circle" style="background:url(<?= $dish->img() ?>) no-repeat center center ; height:100px !important;width:100px !important;background-size: fill;">
                            
                        </div>
                 
                        
                    </div>
                    <div class="col-8 align-items-center">
                        <h4><?= $data['name'] ?>
                        <?php if (strlen($dish->name_ar())>2): ?>
                        <br>
                        <?= $dish->name_ar() ?>
                        <?php endif ?>
                        </h4>
                        <p style="" class="m-0"><?= nl2br($data['description']) ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach ?>
            
        </div>
    </div>
</div>
    <!-- Menu End -->

<?php endif ?>
