<?php
use Classes\Cookie;
?>
<div class="container-fluid page-header mb-5 position-relative overlay-bottom">
    <div class="d-flex flex-column align-items-center justify-content-center pt-0 pt-lg-5" style="min-height: 400px">
        <h1 class="display-4 mb-3 mt-0 mt-lg-5 text-primary text-uppercase"><?= tr("Menu") ?></h1>
        <!-- <div class="d-inline-flex mb-lg-5">
            <p class="m-0 text-white"><a class="text-white" href="">Home</a></p>
            <p class="m-0 text-white px-2">/</p>
            <p class="m-0 text-white">Menu</p>
            
        </div> -->
    </div>
</div>
<!-- Page Header End -->
<!-- Menu Start -->
<style>
.fixed-action-btn {
position: fixed;
bottom: 50px;
left: 50px;
height: 60px;
width: 60px;
z-index: 5;
}
.btn-floating {
height:60px !important;
width:60px  !important;
border-radius: 45px;

position: relative;

}
.floating-badge{
position: absolute;
top: 0;
right: 0;
font-size: 0.8rem;
}
.loading-modal {
display:    none;
position:   fixed;
z-index:    1200;
top:        0;
left:       0;
height:     100%;
width:      100%;
background: rgba( 255, 255, 255, .8 );

}
.loader {
left: 50%;
margin-left: -4em;
font-size: 10px;
border: .8em solid rgba(218, 219, 223, 1);
border-left: .8em solid #8D8D8D;
animation: spin 1.1s infinite linear;
}
.loader, .loader:after {
border-radius: 50%;
width: 8em;
height: 8em;
display: block;
position: absolute;
top: 40%;
margin-top: -4.05em;
}
@keyframes spin {
0% {
transform: rotate(360deg);
}
100% {
transform: rotate(0deg);
}
}
body.loading {
overflow: hidden;
}
body.loading .loading-modal {
display: block;
}

</style>

    <style>
  .ck-button {
    margin:4px;
    background-color:#EFEFEF;
    border-radius:4px;
    border:1px solid #D0D0D0;
    overflow:auto;
    float:left;
}

.ck-button:hover {
    background:#7CB488;
}

.ck-button label {
    float:left;
    width:4.0em;
}

.ck-button label {
    text-align:center;
    padding:3px 0px;
    display:block;
}

.ck-button label input {
    position:absolute;
    top:-20px;
}

.ck-button input:checked {
    background-color:#11992E;
    color:#fff;
}
</style>
<div class="container-fluid pt-5" id="app">
    <div class="">
        <ul class="list-inline" style="overflow-x: auto;white-space: nowrap">
            <?php foreach ($db->query("SELECT * FROM categories WHERE deleted_01 = 0") as $key => $cat): ?>
            <?php
            $list = $db->query("SELECT * FROM dishes WHERE category_id = ? AND deleted_01 = 0 AND website = 1",[$cat['id']]);
            ?>
            <?php if (count($list)): ?>
            <li class="list-inline-item" style="display: inline-block;"><a href="#category-<?= $cat['id'] ?>" class="btn btn-outline-dark rounded-pill mx-2 w-auto"><strong><?= $cat['name'] ?></strong></a>
                <?php endif ?></li>
            <?php endforeach ?>
        </ul>
        <br>
        <div class="row">
            <?php foreach ($db->query("SELECT * FROM categories WHERE deleted_01 = 0") as $key => $cat): ?>
            <?php
            $list = $db->query("SELECT * FROM dishes WHERE category_id = ? AND deleted_01 = 0 AND website = 1",[$cat['id']]);
            ?>
            <?php if (count($list)): ?>
            <div class="col-md-12 mb-3" id="category-<?= $cat['id'] ?>">
                <h1 class="mb-5"><?= $cat['name'] ?></h1>
                <div class="row">
                <?php foreach ($list as $key => $dish): ?>
                <?php
                $dish = dish($dish['id'],$branch['id']);
                $data=[
                "id"         => $dish->id(),
                  "name"       => $dish->name(),
                  "name_ar"       => $dish->name_ar(),
                  "description"=> $dish->description(),
                  "cat_id"     => $dish->category_id(),
                  "sizes"      => $dish->size_and_price(),
                  "addons"     => $dish->addon_and_price(),
                  "category"     => $dish->category(),
                  "tax"     => $dish->tax(),
                ];
                $sizes = $data['sizes'];
                ?>
                <div class="col-6 col-xs-6 col-sm-4 col-md-3 col-lg-2 ">
                    <div class="card card-body shadow text-center mb-3 border-0">
                        
                        <div class="w-100 h-100 mx-auto rounded-circle shadow" style="background:url(<?= $dish->img() ?>) no-repeat center center ; height:100px !important;width:100px !important;background-size: fill;">
                            
                        </div>
                        <h5 class="text-center"><?= $data['name'] ?>
                        <?php if (strlen($dish->name_ar())>2): ?>
                            <br>
                                        <?= $dish->name_ar() ?>
                                    <?php endif ?>
                    </h5>
                        <h5 class="text-center ">
                        <?= amount($sizes[0]['price']) ?>
                        </h5>
                        <div class="text-center">
                            <button @click='add_to_cart(<?= (json_encode($data,JSON_NUMERIC_CHECK)) ?>,0);' class="btn btn-outline-secondary btn-block rounded-pill"><?= tr("Add") ?></button>
                        </div>
                   
                        
                        <p  class="m-0"><?= nl2br($data['description']) ?></p>
                    </div>
                </div>
                <?php endforeach ?>
                </div>
            </div>
            <?php endif ?>
            <?php endforeach ?>
        </div>
    </div>
    <div class="fixed-action-btn">
        <button data-toggle="modal" data-target="#cart-modal" type="button" class="btn-floating btn-primary btn-large red">
        <i class="fas fa-shopping-basket fa-lg"></i>
        <span class="floating-badge badge badge-dark rounded-circle">{{cart.list.length}}</span>
        </button>
        
    </div>
    <div class="modal fade" style="overflow-y: auto;"  id="cart-modal"   tabindex="-1" role="dialog" aria-labelledby="cart-modalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document" >
            <div class="modal-content" >
                <div class="modal-header">
                    <h5 class="modal-title" id="cart-modalLabel"><?= tr("Cart") ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <!-- <div class="modal-body"> -->
                <table class="table table-striped table-responsive">
                    <tr v-for="(item,index) in cart.list">
                        <td>{{index+1}}</td>
                        <td>{{item.name}} {{item.name_ar}} - <span 
                            @click="selected_item=index;$('#item-modal').modal('show')"
                            class="text-info">{{item.size}} <small><i class="fas fa-pen"></i></span></small></td>
                        <td>x{{item.qty}}</td>
                        <td>
                            {{to_price(item.total_price)}}
                            <small v-show="to_price(item.total_price+item.appdiscount)!=to_price(item.total_price)"> <br><s>{{to_price(item.total_price+item.appdiscount)}}</s></small>
                           
                        </td>
                        <th>{{to_price(float(item.total_price)*float(item.qty))}}</th>
                        <td class="text-center">
                            <button
                            @click="selected_item=index;$('#item-modal').modal('show')"
                            class="btn btn-link text-info"
                            type="button">
                            <i class="fas fa-pen"></i>
                            </button>
                            <button
                            @click="cart.list.splice(index,1);refresh()"
                            class="btn btn-link text-danger"
                            type="button"><i class="fas fa-times"></i></button>
                        </td>
                    </tr>
                    
                    
                </table>
                <table class="table table-sm">
                    <tr>
                        <td rowspan="5" colspan="3">
                            <label for=""><?= tr("Promo/Wallet code") ?></label>
                            <div class="d-flex" style="max-width: 250px;">
                                <input v-model="cart.promo" type="text" class="form-control"> <button @click="refresh()" class="btn btn-outline-secondary"><i class="fas fa-sync"></i></button>
                            </div>
                        </td>
                    </tr>
                    <tr class="border table-sm">
                        
                        <th colspan="2"><?= tr("Subtotal") ?></th>
                        <th>{{to_price(cart.totalBillPrice-cart.tax)}}</th>
                    </tr>
                    <tr class="border table-sm">
                        
                        <th colspan="2"><?= tr("VAT") ?></th>
                        <th>{{to_price(cart.tax)}}</th>
                    </tr>
                    <tr class="border table-sm">
                        
                        <th colspan="2"><?= tr("Discount") ?></th>
                        <th class="text-muted"><s>{{to_price(cart.discount)}}</s></th>
                    </tr>
                    <tr class="border table-sm">
                        <th colspan="2"><?= tr("Total") ?></th>
                        <th>{{to_price(cart.totalBillPrice)}} <br> <span class="text-muted"><s><small>{{to_price(cart.totalBillPrice+cart.discount)}}</small></s></span></th>
                    </tr>
                </table>
                <!-- </div> -->
                <div class="modal-footer" v-show="cart.list.length>0">
                    
                    <a href="<?= add_to_url($app_url."/c/",["v","b"],["checkout",cr($branch['id'])]) ?>" class="btn btn-primary btn-lg btn-block"><strong><?= tr("Checkout") ?></strong></a>
                </div>
            </div>
        </div>
    </div>


<!-- Modal -->
<div v-if="cart.list.length>0" class="modal" id="item-modal" tabindex="-1" role="dialog" aria-labelledby="payment-modalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="item-modalTitle">{{ cart.list[selected_item].name }} <br>{{ cart.list[selected_item].name_ar }} </h5>
        
      </div>
      <div class="modal-body">

        <div class="row">
          <div class="col">

           
            <div class="list-group ">
                <h6><?= tr("Options") ?></h6>

              <div v-for="(addon,index) in cart.list[selected_item].addons" class="btn-group py-0" >
                <label class="btn list-group-item py-0 rounded-0  mb-0 border-0 px-0"   :for="addon.addon+'-'+selected_item">
                    <table class="table my-0 border table-hover ">
                        <tr class="py-0">
                            <td class="text-start" style="width:300px">{{ addon.addon }}</td>
                            <td class="">{{ to_price(addon.price) }}</td>
                            <td class=""><i v-if="some(JSON.stringify(cart.list[selected_item].selected_addons),JSON.stringify(addon))" class="text-success fas fa-check"></i></td>
                        </tr>
                    </table>
                </label>
                  <input v-show=0 type="checkbox"  :id="addon.addon+'-'+selected_item" :value="addon" v-model="cart.list[selected_item].selected_addons" @change="refresh"> 
                
              </div>


            </div>
          </div>
        </div>

        <br>

        <h6><?= tr("Size") ?></h6>
        <div class="row">
          <div class="col">
            <div class="btn-group-vertical  btn-block" >
              <button 
              class="btn btn-outline-secondary btn-lg " 
              v-for="(size,index) in cart.list[selected_item].sizes" 
              :class="{'active':size.size==cart.list[selected_item].size}" 
              @click="cart.list[selected_item].size=size.size;cart.list[selected_item].price=size.price;">

                <div class="row">
                  <div class="col text-end">{{ size.size }} :</div>
                  <div class="col text-start"> {{ to_price(size.price+size.price*cart.list[selected_item].tax_percent/100) }} </div>
                </div>
              </button>
            </div>
          </div>
        </div>


        <br>
        <label><?= tr("Note") ?></label>
        <textarea class="form-control" v-model="cart.list[selected_item].note"></textarea><br>

      

        <div class="row bg-primary text-light text-center pt-2 mx-0 mt-1">
          <div class="col">
           <h5><?= tr("Total") ?> :  {{ to_price(cart.list[selected_item].total_price) }}</h5>
          </div>
        </div>
        
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-primary btn-lg" @click="refresh"  data-dismiss="modal"><?= tr("Apply") ?></button>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<div class="loading-modal">
    <div class=" loader " style="margin: auto;" role="status">
        <span class="sr-only">Loading...</span>
    </div>
</div>
<style>
</style>
<!-- Menu End -->
<script type="text/javascript">

let app = new Vue({
    el:"#app",
    data:{
    cart:<?= json_encode($_SESSION['cart'],JSON_NUMERIC_CHECK) ?>,
    selected_item:0,
},
methods:{
    add_to_cart(data,size){

    let job=this

    job.cart.list.push({
        id:data.id,
        name:data.name,
        price:data.sizes[size].price,
        // total_price:parseFloat(price)+parseFloat(price)*job.cart.tax/100,
        total_price:(parseFloat(data.sizes[size].price)+parseFloat(data.sizes[size].price)*parseFloat(data.tax.percent)/100),
        qty:1,
        size:data.sizes[size].size,
        tax:parseFloat(data.sizes[size].price)*parseFloat(data.tax.percent)/100,
        tax_percent:parseFloat(data.tax.percent),
        cat_id:data.cat_id,

        note:data.note,
        sizes:data.sizes,
        addons:data.addons,
        discount:data.discount,
        selected_addons:[],
    // note:'',
    });

    // setTimeout(function(){
    job.refresh();
    // },1000)




    },
    to_price(val){
        return parseFloat(this.toNearest(val)).toFixed(3)
    },
    toNearest(num){
        return Math.ceil(parseFloat(num) / 0.001) * 0.001
    },
    float(num){
        return parseFloat(num);
    },
    refresh(){
        let job = this;
        $('body').toggleClass('loading')
        $.post('<?= $app_url ?>/c/ax/?f=refresh&b=<?= cr($branch['id']) ?>',{'cart':JSON.stringify(job.cart)}, function(data) {
            console.log(data)
            $('body').toggleClass('loading')
            job.cart = data
        },'json');
    },
    some(array,object){
        // return 1
        
        return array.includes(object)
    }
}
});

$(document).ready(function() {
    $(document).on('show.bs.modal', '.modal', function() {
        const zIndex = 1040 + 10 * $('.modal:visible').length;
        $(this).css('z-index', zIndex);
        setTimeout(() => $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack'));
    });
});

console.log(
    app.some(
        JSON.stringify([{'name':1,'name2':1},{'name':2,'name2':2}]),
        JSON.stringify({'name':1,'name2':1})
    )
);
</script>