<?php
	$root="../..";
	require($root."/php/init.php");

	$user->authorize("manage-cashdrawer");


	$page=[
		"title"=>tr("Cash drawer"),
		"class"=>" sidebar-xs "
	];


	if (isset($_POST['stage'])) {

		$amount=isset($_POST['stage'])?$_POST['stage']:0;

		$v->validate([
			tr("Amount")=>[$amount,"required|min(0,number)"]
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO cash_d(type, amount, created_by) VALUES(?,?,?)",["stage", $amount, auth()->id]);
		}
	}

	if (isset($_POST['adjustment'])) {

		$amount=isset($_POST['adjustment'])?$_POST['adjustment']:0;

		$v->validate([
			tr("Amount")=>[$amount,"required"]
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO cash_d(type, amount, created_by) VALUES(?,?,?)",["adjustment", $amount, auth()->id]);
		}
	}


	if (isset($_POST['cash'])) {
		$v->validate([
			"cash"=>[$_POST['json'],'required']
		]);


		if ($v->passes()) {
			$db->query("UPDATE cash_d SET cash = ? WHERE type='stage' ORDER BY id DESC LIMIT 1",[$_POST['json']]);
		}
	}


	$logs = $db->query("SELECT c.*, u.name FROM cash_d c LEFT JOIN users u ON u.id = c.created_by WHERE c.created_at BETWEEN SUBDATE(CURDATE(), INTERVAL 1 YEAR) AND NOW() ORDER BY c.id DESC ");

	$last_stage = $db->row("SELECT * FROM cash_d WHERE type='stage'  ORDER BY id DESC LIMIT 1");

	if (!$last_stage) {
		$last_stage=[
			"created_at"=>0,
			"amount"=>0,
		];
	}

	$payments=$db->single("SELECT sum(pay_amount) FROM bill_payment WHERE pay_by='cash' AND deleted_01=0 AND TIMESTAMP(created_at)> TIMESTAMP(?) " ,[$last_stage['created_at']]);

	$refunds = $db->single("SELECT SUM(refund_amount) FROM refunds WHERE deleted_01 = 0 AND TIMESTAMP(created_at)>TIMESTAMP(?) ",[$last_stage['created_at']]);

		$expenses = $db->single("SELECT SUM(amount) FROM expenses WHERE deleted_01 = 0 AND cash_d = 1 AND  TIMESTAMP(created_at)> TIMESTAMP(?) " ,[$last_stage['created_at']]);

	$adjustments=$db->single("SELECT sum(amount) FROM cash_d WHERE type='adjustment' AND TIMESTAMP(created_at )> TIMESTAMP(?) " ,[$last_stage['created_at']]);

// var_dump(	$expenses );

	$pay_by=[];
	foreach ($payment_methods as $method) {

		$amount = $db->single(" SELECT   sum(pay_amount) FROM bill_payment WHERE pay_by=? AND deleted_01=0 AND TIMESTAMP(created_at)> TIMESTAMP(?) ",[$method,$last_stage['created_at']]);

		$pay_by[]=["value"=>amount($amount),"name"=>tr($method)];
	}


	$cash = $db->row("SELECT * FROM cash_d ORDER BY id DESC LIMIT 1");

	if (isset($_GET['i'])) {
		

			$stage = $db->row("SELECT * FROM cash_d WHERE type='stage' AND id = ?  LIMIT 1",[$_GET['i']]);

				$next_stage = $db->row("SELECT * FROM cash_d WHERE type='stage' AND id>?  ORDER BY id ASC LIMIT 1",[$_GET['i']]);

		if ($next_stage && $stage) {
					$payments=$db->single("SELECT sum(pay_amount) FROM bill_payment WHERE pay_by='cash' AND TIMESTAMP(created_at)< TIMESTAMP(?) AND TIMESTAMP(created_at)> TIMESTAMP(?) " ,[$next_stage['created_at'], $stage['created_at']]);

			$refunds = $db->single("SELECT SUM(refund_amount) FROM refunds WHERE deleted_01 = 0 AND TIMESTAMP(created_at)< TIMESTAMP(?) AND TIMESTAMP(created_at)> TIMESTAMP(?) " ,[$next_stage['created_at'], $stage['created_at']]);
			$expenses = $db->single("SELECT SUM(amount) FROM expenses WHERE deleted_01 = 0 AND cash_d = 1 AND TIMESTAMP(created_at)< TIMESTAMP(?) AND TIMESTAMP(created_at)> TIMESTAMP(?) " ,[$next_stage['created_at'], $stage['created_at']]);

			$adjustments=$db->single("SELECT sum(amount) FROM cash_d WHERE type='adjustment' AND TIMESTAMP(created_at)< TIMESTAMP(?) AND TIMESTAMP(created_at)> TIMESTAMP(?) " ,[$next_stage['created_at'], $stage['created_at']]);




			$pay_by=[];
			foreach ($bill->payment_methods as $method) {

				$amount = $db->single(" SELECT   sum(pay_amount) FROM bill_payment WHERE pay_by=? AND deleted_01=0 AND TIMESTAMP(created_at)< TIMESTAMP(?) AND TIMESTAMP(created_at)> TIMESTAMP(?)",[$method,$next_stage['created_at'], $stage['created_at']]);

				$pay_by[]=["value"=>amount($amount),"name"=>tr($method)];
			}


			$cash = $stage;
		}


			
	}


	$payments    = $payments?$payments:0;
	$refunds     = $refunds?$refunds:0;
	$adjustments = $adjustments?$adjustments:0;
	$expenses = $expenses?$expenses:0;
	$cash_d      = $payments+$last_stage['amount']+$adjustments-$refunds-$expenses;






	if (!$cash || !$cash['cash']) {
	
		$cash['cash'] ="[
				{count:0,val:50.000},
				{count:0,val:20.000},
				{count:0,val:10.000},
				{count:0,val:5.000},
				{count:0,val:1.000},
				{count:0,val:0.500},
				{count:0,val:0.100},
				{count:0,val:0.050},
				{count:0,val:0.025},
				{count:0,val:0.010},
				{count:0,val:0.005},
			]";
	}
	

		$display->error($v->errors()->all());
?>
<!DOCTYPE html>
<html <?= $local ?>>
	<?php require($root."/inc/head.php") ?>
	
	<body class=" <?= isset($page['class'])?$page['class']:'' ?> " >
		<?php require($root."/inc/header.php") ?>
		
		
		
		<div class="row">
			<div class="col">
				<br>
				<?php $display->display_messages() ?>
				<div id="notify"></div>
				
				
				<br>
				<h2><?= tr("Cash drawer") ?></h2>
				<div class="row">
					<div class="col-md-6 p-0">
						<div class="row">
							<div class="col-lg-12">
								<div class="card ">
									<div class="card-body">
										<p dir="ltr"><?= date("Y-m-d h:i A",strtotime($last_stage['created_at'])) ?></p>
										<h1 class="text-success text-center text-monospace" style="font-size: 4rem">										<?= amount($cash_d) ?>
										</h1>
									</div>

									
						
											<table class="table  table-sm table-striped ">
								
												<tbody>
																	<?php foreach ($pay_by as $key => $payment): ?>
													<tr>
														<td><strong><?= tr($payment['name']) ?></strong>:</td>
														<td><strong><?= amount($payment['value']) ?></strong></td>
													</tr>
														<?php endforeach ?>

														<tr>
														<td><strong><a href="<?= $app_url ?>/refunds"><?= tr('refunds') ?></a></strong>:</td>
														<td><strong><?= amount($refunds) ?></strong></td>
													</tr>
													<tr>
														<td><strong><a href="<?= $app_url ?>/expenses"><?= tr('Expenses') ?></a></strong>:</td>
														<td><strong><?= amount($expenses) ?></strong></td>
													</tr>
												</tbody>
											</table>

											
									

									
									
								</div>
							</div>
							<div class="col-lg-6">
								<div class="card ">
									<div class="card-body">
										<h3><?= tr("Stage") ?></h3>
										<form method="post">
											<div class="row align-items-end">
												<div class="col">
													<label for=""><?= tr("Amount") ?></label>
													<input type="number" class="form-control" value="0" step="0.1" name="stage" onfocus="$(this).select()">
												</div>
												<div class="col-md-3">
													<button class="btn btn-primary mt-auto"><?= tr("Set") ?></button>
												</div>
											</div>
											
										</form>
									</div>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="card ">
									<div class="card-body">
										<h3><?= tr("Adjustment") ?></h3>
										<form method="post">
											<div class="d-flex align-items-end">
												<div class="col">
													<label for=""><?= tr("Amount") ?></label>
													<input type="number" class="form-control" value="0" step="0.1" name="adjustment" onfocus="$(this).select()">
												</div>
												
												<div class="col-md-3">
													<button class="btn btn-primary mt-auto"><?= tr("Add") ?></button>
												</div>
											</div>
											
										</form>
									</div>
								</div>
							</div>

							
						</div>
					</div>
					<div class="col-md-6">
						<div class="card ">
							<div class="card-header">
								<h3><?= tr("Logs") ?></h3>
							</div>
							<table class="table table-sm" id="datatable-tabletools">
								<thead>
									<tr>
										<th>#</th>
										<th><?= tr("Date") ?></th>
										<th><?= tr("Created by") ?></th>
										<th><?= tr("Amount") ?></th>
										<th><?= tr("Type") ?></th>
									</tr>
								</thead>
								<tbody>
									<?php foreach ($logs as $key => $log): ?>
									<tr class=" <?= ($log['type']=='stage'?'bg-info-700':'') ?>">
										<?php if ($log['type']=='stage'): ?>
											<td class="text-monospace text-white"><a class="text-white" href="<?= add_to_url($this_url,["i"],[$log['id']]) ?>"><?= $log['id'] ?></a></td>
										<?php else: ?>
											<td class="text-monospace text-white"><?= $log['id'] ?></td>
										<?php endif ?>
										<td class="text-monospace"><?= $log['created_at'] ?></td>
										<td><?= escap($log['name']) ?></td>
										<td class="text-monospace"><?= amount($log['amount']) ?></td>
										<td><?= tr($log['type']) ?></td>
										
										
									</tr>
									<?php endforeach ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>

				<div class="row" id="app">
					<div class="col">
						<div class="card">
							<div class="card-header">
								


								<div class="row">
									<div class="col">
										<h5 class="card-title"><?= tr("Quick Cash") ?></h5>
								<?php if ($cash): ?>
									<p><?= $cash['created_at'] ?></p>
								<?php endif ?>
									</div>
									<div class="col text-end">
										<div class="btn-group justify-content-center">
										<a href="#" class="btn bg-success-800 dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><?= tr("Print") ?> <i class="fas fa-print"></i></a>

										<div class="dropdown-menu" x-placement="bottom-start" >
											<a href="<?= $app_url ?>/apps/cashdrawer/print/?i=<?= $cash['id'] ?>" target="_blank"  class="dropdown-item"><?= tr("Print") ?> A4 A5</a>
										
								
									
										</div>
									</div>
									</div>
								</div>
							</div>
							<div class="table-responsive">
								<table class="table text-monospace font-weight-black">
								<tbody>
									<tr v-for="btn in cash">


									<th width="30%">
										<div class="input-group">
											<span class="input-group-append bg-dark">
											
												<span class="input-group-text bg-dark"><strong>{{to_price(btn.val)}}</strong></span>
											</span>
											<span class="input-group-append">
											
												<button class="btn btn-light" @click="btn.count>0?btn.count--:false"><i class="fas fa-minus"></i></button>
											</span>
											<input type="text" class="form-control text-center font-weight-black" onfocus="this.select()" v-model="btn.count">
											<span class="input-group-append">
												<button class="btn btn-light" @click="btn.count++"><i class="fas fa-plus"></i></button>
										
											</span>
							
										</div>
									</th>
									<td dir="ltr" class="text-center">
										{{btn.count}} 
									</td>
									<td dir="ltr" class="text-center">
									{{to_price(btn.val)}}
									</td>
									<td dir="ltr" class="text-center bg-light font-size-lg">
										  <strong>{{to_price(btn.val*btn.count)}}</strong>
									</td>
								</tr>
								</tbody>
								<tfoot>
									<tr class="bg-light font-size-lg">
										<td colspan="2"></td>
										<td class="text-center"><strong><?= tr("Total") ?></strong></td>
										<td class="text-center"><strong>{{to_price(total)}}</strong></td>
									</tr>
								</tfoot>
								</table>
							</div>

							<form method="post" class="p-3">
								<input type="hidden" name="json" :value="JSON.stringify(cash)">
									<br>
								<button name="cash" class="btn btn-primary"><?= tr("Save") ?></button>
								<br>
								
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	
	<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>


<script>
	app = new Vue({
		el:"#app",
		data:{
			total:0,
			cash:<?= $cash['cash']  ?>,
		},
		methods:{
				to_price(val){
					return parseFloat(this.toNearest(val)).toFixed(3)
				},
				toNearest(num,frac=0.001){
					return Math.ceil(parseFloat(num) / frac) * frac
				},
				quickCashVal:function(){ // quick cash buttons
					let job = this
					var total=0
					for (var i = 0; i < job.cash.length; i++) {
						total+=parseFloat(job.cash[i].count)*parseFloat(job.cash[i].val)
					}
					job.total=parseFloat(total).toFixed(3)
				},
		},
		watch:{
			cash:{
				deep:true,
				handler(val){
					this.quickCashVal()
				}
			}
		},

		mounted(){
			this.quickCashVal()
		}
	})
</script>

	<script>
		$(document).ready(function() {
				var $table = $('#datatable-tabletools');

				 table = $table.dataTable({
				 	
        
			    language: {
		              search: '<span></span> _INPUT_',
		              searchPlaceholder: '<?= tr("Search") ?>',
		              lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [10, 50, 100,500],
			          [10, 50, 100,500]
			        ],
			        "order": [[ 0, "desc" ]],
		
					"columnDefs": [
					    { "orderable": false, "targets": [1]},
					 
					],
					// stateSave: true,
			        // processing: true,
			        // serverSide: true,
		
					
					// sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
					dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,
					 buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
		              }
		          },
		          buttons: [
		    
		         

		          ],
		      },

					
				});




				
			});
	</script>

</body>
</html>
