<?php 
namespace Pprint;
use Mpdf\Mpdf;


class Pprint
{
		
	private $_pdfdst = __DIR__."/../pdf/";
	private $_pdf2printer = __DIR__.'/../PDFtoPrinter.exe';


	private $_html = "";
	private $_pdffile = "";

	public $pdfconfig = [
        'mode' => 'utf-8',
        'format' => [72,297],    // format - A4, for example, default ''
        // 'default_font_size' => 0,     // font size - default 0
        'default_font' => '',    // default font family
            'margin_left' => 1,     // 15 margin_left
            'margin_right' => 1,        // 15 margin right
            'margin_top' => 1,      // 15 margin right
            'margin_bottom' => 1,       // 15 margin right
            'mgt' => 0,     // 16 margin top
            'mgb' => 0,     // margin bottom
        'margin_header' => 0,     // 9 margin header
        'margin_footer' => 0,     // 9 margin footer
            'orientation' => 'p',   // L - landscape, P - portrait
            "autoScriptToLang"=>1,
            "autoLangToFont"=>1,
            "allow_charset_conversion"=>1,
            "packTableData"=>1,
            "keep_table_proportions"=>1,
            "shrink_tables_to_fit"=>1,
            // 'tempDir' => "" ,


    ];

	// function __construct()
	// {
	// 	// code...
	// }


	public function html($html){
		$this->_html = $html;
		return $this;
	}


	public function pdf($html=null){
		if ($html ==null) {
			$html = $this->_html;
		}

		$filename = date("ymdhis").".pdf";

		$filedir = $this->_pdfdst.$filename;

		$mpdf = new Mpdf($this->pdfconfig);

		$mpdf->WriteHTML($html);

		$mpdf->Output($filedir, 'F');

		$this->_pdffile=$filedir;

		return $this;
	}

	public function print($printer, $file=null){

		if ($file==null) {
			$file = $this->_pdffile;
		}
		echo $this->_pdf2printer. ' "'.$file.'" ' .'"'.$printer.'"';
		exec($this->_pdf2printer. ' "'.$file.'" ' .'"'.$printer.'"');
	}
}