<?php
ini_set('max_execution_time', "0");
set_time_limit ( 0 );
require_once(__DIR__ ."/php/init.php");



use Noodlehaus\Config;

use Mike42\Escpos\PrintConnectors\CupsPrintConnector;
use Mike42\Escpos\PrintConnectors\UriPrintConnector;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
use Mpdf\Mpdf;


use Mike42\Escpos\CapabilityProfile;
use Mike42\Escpos\Printer;
use Mike42\Escpos\Devices\AuresCustomerDisplay;



try {
    $files = glob(__DIR__.'/pdf/*'); 
    foreach($files as $file){ 
      if(is_file($file)) {
        unlink($file); 
      }
    }
} catch (Exception $e) {
    
}

$pole_start = false;
function start_pole($name){
    global $pole_start;

    
    if (!$pole_start) {
        $ps='

    $strCOMPort="'.$name.'"  
    $strCOMBaud="9600"      
    $strCOMParity="None"
    $strCOMDataBits="8"
    $strCOMStopBits="one"
    $displaysleep=7000 
    $intdebug=0


    $usb = New-Object System.IO.Ports.SerialPort $strCOMPort,$strCOMBaud,$strCOMParity,$strCOMDataBits,$strCOMStopBits

    $usb.Open()

    $usb.WriteLine("START")

    $usb.Close()
    ';

    file_put_contents(__DIR__.'/wel.ps1', $ps);
    $pole_start=true;
    shell_exec('Powershell.exe -ExecutionPolicy ByPass -File '.__DIR__.'/wel.ps1');
    }
}

try {

    echo '> Starting server on ws://localhost:40213 ...', "\n";

    $websocket = new Hoa\Websocket\Server(
        new Hoa\Socket\Server('ws://localhost:40213')
   
);



    $websocket->on('open', function (Hoa\Event\Bucket $bucket) {
        echo '> Connected', "\n";
        return;
    });

    $websocket->on('message', function (Hoa\Event\Bucket $bucket) {
        global $db;

        $raw = $bucket->getData();
        echo '> Received request ', "\n";

        $raw = $raw['message'];

        $data = explode("||",$raw);
        $job = $data[0];


        echo $job;

         $path = __DIR__;
       
        // echo $path;

        if ($job=="print") {
            $html = $data[1];

            echo $raw;

            $html = gzuncompress(base64_decode($html));


            $print = new Pprint\Pprint;

            $print->html($html)->pdf();

            echo $data[2];

            for ($i=2; $i < count($data); $i++) { 
                echo $data[$i];
                // echo $data[$i];
                // exec($path.'/../PDFtoPrinter.exe "pdf/'.$filename.'" "'.$data[$i].'"');
                $print->print($data[$i]);
            }


            
        }
        
        if ($job=="pole") {
            
        
        start_pole($data[2]);

            $line = $data[1];

            $connector = new WindowsPrintConnector($data[2]);

            // Profile and display
            $profile = CapabilityProfile::load("OCD-300");
            $display = new AuresCustomerDisplay($connector, $profile);


            $display -> clear();
            $display -> text($line);

            $display -> close();
          
        }

        

        
            
        echo '> Done print task ', "\n";
        return;
    });

    $websocket->on('close', function (Hoa\Event\Bucket $bucket) {
        echo '> Disconnected', "\n";
        return;
    });

    try {
        echo '> Server started', "\n";
        $websocket->run();
    } catch (Exception $e) {
        echo '> Error occurred, server stopped. ', $e->getMessage(), "\n";
    }
} catch (Exception $e) {
    echo '> Error: ', $e->getMessage(), "\n";
}

