<?php 
require_once(__DIR__ ."/php/init.php");


use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\CapabilityProfile;
use Mike42\Escpos\Printer;
use Mike42\Escpos\Devices\AuresCustomerDisplay;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;

// $connector = new WindowsPrintConnector("Receipt Printer");
/*
 * Device appears as a serial port.
 * 
 *   stat /dev/ttyACM0
 *   sudo usermod -a -G dialout [username]
 */
$connector = new WindowsPrintConnector("COM3");

// Profile and display
$profile = CapabilityProfile::load("OCD-300");
$display = new AuresCustomerDisplay($connector, $profile);


// Make a really long test string
$inputsOk = array(
        "Danish" => "Quizdeltagerne spiste jordbær med fløde, mens cirkusklovnen Wolther spillede på xylofon.\n",
        "German" => "Falsches Üben von Xylophonmusik quält jeden größeren Zwerg.\n",
        "Greek" => "Ξεσκεπάζω την ψυχοφθόρα βδελυγμία\n",
        "English" => "The quick brown fox jumps over the lazy dog.\n",
        "Spanish" => "El pingüino Wenceslao hizo kilómetros bajo exhaustiva lluvia y frío, añoraba a su querido cachorro.\n",
        "French" => "Le cœur déçu mais l'âme plutôt naïve, Louÿs rêva de crapaüter en canoë au delà des îles, près du mälström où brûlent les novæ.\n",
        "Irish Gaelic" => "D'fhuascail Íosa, Úrmhac na hÓighe Beannaithe, pór Éava agus Ádhaimh.\n",
        "Hungarian" => "Árvíztűrő tükörfúrógép.\n",
        "Icelandic" => "Kæmi ný öxi hér ykist þjófum nú bæði víl og ádrepa.\n",
        "Latvian" => "Glāžšķūņa rūķīši dzērumā čiepj Baha koncertflīģeļu vākus.\n",
        "Polish" => "Pchnąć w tę łódź jeża lub ośm skrzyń fig.\n",
        "Russian" => "В чащах юга жил бы цитрус? Да, но фальшивый экземпляр!\n",
        "Turkish" => "Pijamalı hasta, yağız şoföre çabucak güvendi.\n",
        "Japanese (Katakana half-width)" => implode("\n", array("ｲﾛﾊﾆﾎﾍﾄ ﾁﾘﾇﾙｦ ﾜｶﾖﾀﾚｿ ﾂﾈﾅﾗﾑ",  "ｳｲﾉｵｸﾔﾏ ｹﾌｺｴﾃ ｱｻｷﾕﾒﾐｼ ｴﾋﾓｾｽﾝ")) . "\n",
        "Vietnamese" => "Tiếng Việt, còn gọi tiếng Việt Nam hay Việt ngữ, là ngôn ngữ của người Việt (người Kinh) và là ngôn ngữ chính thức tại Việt Nam.\n"
        );

/*
 * These strings are not expected to print correctly, if at all, even on an Epson printer. This is due to a mix of
 * escpos driver, printer, and PHP language support issues.
 * 
 * They are included here as a collection of things not yet implemented.
 */
$inputsNotOk = array(
        "Thai (No character encoder available)" => "นายสังฆภัณฑ์ เฮงพิทักษ์ฝั่ง ผู้เฒ่าซึ่งมีอาชีพเป็นฅนขายฃวด ถูกตำรวจปฏิบัติการจับฟ้องศาล ฐานลักนาฬิกาคุณหญิงฉัตรชฎา ฌานสมาธิ\n",
        "Japanese (Hiragana)" => implode("\n", array("いろはにほへとちりぬるを",  " わかよたれそつねならむ", "うゐのおくやまけふこえて",  "あさきゆめみしゑひもせす")) . "\n",
        "Japanese (Katakana full-width)" => implode("\n", array("イロハニホヘト チリヌルヲ ワカヨタレソ ツネナラム",  "ウヰノオクヤマ ケフコエテ アサキユメミシ ヱヒモセスン")) . "\n",
        "Arabic (RTL not supported, encoding issues)" => "صِف خَلقَ خَودِ كَمِثلِ الشَمسِ إِذ بَزَغَت — يَحظى الضَجيعُ بِها نَجلاءَ مِعطارِ" . "\n",
        "Hebrew (RTL not supported, line break issues)" => "דג סקרן שט בים מאוכזב ולפתע מצא לו חברה איך הקליטה" . "\n"
        );
$input = "";
foreach ($inputsOk as $str) {
    $input .= $str;
}

// Wrap at a fixed width (as ASCII...), and show the user
// what's about to be sent to the printer
$wrapped = wordwrap($input, 20);
echo($wrapped);

// // Roll out each line with 0.5s delay
foreach (explode("\n", $wrapped) as $line) {
    $display -> feed();
    $display -> text($line);
    usleep(500000);
}

// Finish by showing "Hello World"
$display -> clear();
$display -> text("Hello World\n h");

// Dont forget to close the device
$display -> close();

die;

$name = "Thank You.";


$name_len = strlen($name);

$line1 = str_replace(" ", '"+[char]32+"', '"'.$name.'"');

for ($i=0; $i < 20-($name_len); $i++) { 
    $line1.='+[char]32';
}


$line2 = '[char]32';
for ($i=0; $i < 19; $i++) { 
    $line2.='+[char]32';
}
$space="[char]32";
for ($i=0; $i < 39; $i++) { 
    $space.='+[char]32';
}
$ps='

$strCOMPort="COM3"  
$strCOMBaud="9600"      
$strCOMParity="None"
$strCOMDataBits="8"
$strCOMStopBits="one"
$displaysleep=7000 
$intdebug=0


$usb = New-Object System.IO.Ports.SerialPort $strCOMPort,$strCOMBaud,$strCOMParity,$strCOMDataBits,$strCOMStopBits

$usb.Open()

$usb.WriteLine('.$space.')

$usb.Close()


$usb.Open()

$usb.WriteLine('.$line2.'+'.$line1.')

$usb.Close()


';

file_put_contents(__DIR__.'/wel.ps1', $ps);

shell_exec('Powershell.exe -ExecutionPolicy ByPass -File '.__DIR__.'/wel.ps1');