<?php

if (isset($_POST['new']) && $tk->passes() && can("manage-customers")) {

	
	$name = isset($_POST['name'])?$_POST['name']:'';
	$phone = isset($_POST['phone'])?$_POST['phone']:'';



	$v->validate([
		tr("Name")=>[$name,"required"],
		tr("Phone")=>[$phone,"required|unique_phone(customers,phone)"],

	]);

	if ($v->passes() ) {

		$db->query("INSERT INTO customers( name, phone) VALUES(?,?) ",[$name,$phone]);

		$display->success(tr("Customer created successfully."));
		$redirect->to(add_to_url($this_url,["v","i"],["edit",$db->lastInsertId()]));
	}
}

if (isset($_POST['edit']) && $tk->passes() && can("manage-customers")) {


	$id = isset($_POST['id'])?$_POST['id']:'';

	$name = isset($_POST['name'])?$_POST['name']:'';
	$phone = isset($_POST['phone'])?$_POST['phone']:'';
	$points = isset($_POST['points'])?$_POST['points']:0;



	$v->validate([
		
		tr("ID")=>[$id ,"required|in_table(customers,id)"],
		tr("Name")=>[$name,"required"],
		tr("Phone")=>[$phone,"required|unique_phone(customers,phone,$id)"],


	]);


	if ($v->passes() ) {

		$db->query("UPDATE customers  SET name=?, phone=?, points=? WHERE id = ? ",[$name,$phone,$points,$id]);

		$display->success(tr("Customer updated successfully."));

	}
}

if (isset($_POST['delete']) && can("manage-customers")) {
	$id = isset($_POST['id'])?$_POST['id']:'';
	$v->validate([
		tr("ID")=>[$id,"required"],
	]);

	if ($v->passes() && $tk->passes()) {

		$db->query("UPDATE customers SET deleted_01=0 WHERE id=? ",[$id]);
		$display->success(tr("Customer deleted successfully."));
		$redirect->to(remove_from_url($this_url,["i","v"]));
	}
		
}

$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';

$page=[
	"title"=>tr("Customers"),
	"active"=>"customers"
];

switch ($view) {
	// case 'new':
		
	// 	$page_nav=[
	// 		"breadcrumb"=>[
	// 			tr("Customers")=>$app_url."/customers",
	// 			tr("New")=>$app_url."/customers",
	// 		],
	// 	];
	// 	$page_view = "views/new.php";
	// break;

	case 'edit':
			$user->authorize("manage-customers");
			$page_nav=[
				"breadcrumb"=>[
					tr("Customers")=>$app_url."/customers",
					tr("Edit")=>$app_url."/customers",
				],
			];
			

			if (isset($_GET['i']) && is_numeric($_GET['i'])) {
				$data = $db->row("SELECT * FROM customers WHERE id = ? ",[$_GET['i']]);

				if (!$data) {
					$redirect->to(404);
				}
			}


			$page_view = "views/edit.php";
		

	
	break;
	
	default:
		$user->authorize("manage-customers|view-customers");
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Customers")=>$app_url."/customers",
			],
		];


		$list = $db->query("SELECT * FROM  customers WHERE  deleted_01=0");


		$page_view = "views/index.php";

	break;
}