
		<div class="card shadow">
			<div class="card-header d-flex justify-content-between bg-primary">
				<h3><?= tr("Customers") ?></h3>
				<div class="text-end">
					<!-- <a href="<?= add_to_url($this_url,"v","new") ?>" class="btn btn-light px-3 rounded-pill"><?= tr("New") ?></a> -->
				</div>
			</div>
			<table class="table table-sm" id="datatable-tabletools">
				<thead>
					<tr>
						<th><?= tr("No.") ?></th>
						<th><?= tr("Name") ?></th>
						<th><?= tr("Phone") ?></th>
						<th><?= tr("Points") ?></th>
		
						

						<th class="text-center"><i class="fas fa-exclamation"></i></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($list as $key => $item): ?>
						<tr>
							<td><?= $item['id'] ?></td>
							<td><?= $item['name'] ?></td>
							<td><?= $item['phone'] ?></td>
							<td>
								<?= $item['points'] ?> (<?= amount($item['points']*$point_rate) ?>)<br>
	
							</td>
					
			
			
							<td class="text-center">
								<?php if (can("manage-customers")): ?>
									<a href="<?= add_to_url($this_url,["v","i"],["edit",$item['id']]) ?>" class="btn btn-sm btn-light"><?= tr("View") ?></a>
								<?php endif ?>
			
							</td>

						</tr>
					<?php endforeach ?>
				</tbody>
			</table>
		</div>



<script>
	$(document).ready(function() {

		var table=''
		$(document).ready(function() {
				var $table = $('#datatable-tabletools');

				 table = $table.dataTable({
				 	
        
			    language: {
		              search: '<span></span> _INPUT_',
		              searchPlaceholder: '<?= tr("Search") ?>',
		              lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [25, 100, 500,1000],
			          [25, 100, 500,1000]
			        ],
			        "order": [[ 0, "asc" ]],
		
					"columnDefs": [
					    { "orderable": false, "targets": [4]},
					 
					],
					stateSave: true,
			        // processing: true,
			        // serverSide: true,
		
					
					// sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
					dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,
					 buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
		              }
		          },
		          buttons: [
		    
		         

		          ],
		      },

					
				});

			
				 $('#datatable-tabletools_length').attr({
				 	"dir": 'ltr',
			
				 });;

				 $('<div />').addClass('dt-buttons mb-2 pb-1 text-start').prependTo('#datatable-tabletools_wrapper');



		
				$table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper ' ).addClass('text-right m-2 mx-3');
				


				
			});
	});
</script>