<?php
	$root=".";
	require($root."/php/init.php");

$links=[

	[
		"title"=>"POS",
		"color"=>"#307A7B",
		"url"=>$app_url."/pos",
		"icon"=>'<i class="fas fa-shopping-basket fa-1x"></i>',
		"role"=>""
	],
	[
		"title"=>"Orders",
		"color"=>"#5E4B44",
		"url"=>$app_url."/orders",
		"icon"=>'<i class="fas fa-ballot fa-1x"></i>',
		"role"=>"manage-orders|view-orders"
	],
	[
		"title"=>"Menu",
		"color"=>"#745759",
		"url"=>$app_url."/dishes",
		"icon"=>'<i class="fas fa-burger-soda fa-1x"></i>',
		"role"=>"manage-dishes"
	],
	[
		"title"=>"Expenses",
		"color"=>"#464A65",
		"url"=>$app_url."/expenses",
		"icon"=>'<i class="fas fa-comments-dollar fa-1x"></i>',
		"role"=>"manage-expenses|add-expenses"
	],

];

if (isset($_POST['stage'])) {

		$amount=isset($_POST['stage'])?$_POST['stage']:0;

		$v->validate([
			tr("Amount")=>[$amount,"min(0,number)"]
		]);

		if ($v->passes() && $tk->passes()) {
			echo "string";
			$db->query("INSERT INTO cash_d(type, amount, created_by) VALUES(?,?,?)",["stage", $amount, auth()->id]);
		}
	}

	if (isset($_POST['adjustment'])) {

		$amount=isset($_POST['adjustment'])?$_POST['adjustment']:0;

		$v->validate([
			tr("Amount")=>[$amount,"required"]
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO cash_d(type, amount, created_by) VALUES(?,?,?)",["adjustment", $amount, auth()->id]);
		}
	}


$last_stage = $db->row("SELECT * FROM cash_d WHERE type='stage' AND created_by=?  ORDER BY id DESC LIMIT 1",[auth()->id]);

	if (!$last_stage) {
		$last_stage=[
			"created_at"=>0,
			"amount"=>0,
		];
	}
$expenses = $db->single("SELECT SUM(amount) FROM expenses WHERE deleted_01 = 0 AND cash_d = 1 AND  TIMESTAMP(created_at)> TIMESTAMP(?) AND created_by=?" ,[$last_stage['created_at'],auth()->id]);
$expenses2 = $db->single("SELECT SUM(amount) FROM expenses WHERE deleted_01 = 0  AND  TIMESTAMP(created_at)> TIMESTAMP(?) AND created_by=?" ,[$last_stage['created_at'],auth()->id]);

	$adjustments=$db->single("SELECT sum(amount) FROM cash_d WHERE type='adjustment' AND TIMESTAMP(created_at )> TIMESTAMP(?) AND created_by=?" ,[$last_stage['created_at'],auth()->id]);
$pay_by=[];
	foreach ($payment_methods as $method) {

		$amount = $db->single(" SELECT   sum(amount) FROM payments WHERE method=? AND deleted_01=0 AND TIMESTAMP(created_at)> TIMESTAMP(?) AND created_by=?",[$method,$last_stage['created_at'],auth()->id]);

		$pay_by[]=["value"=>amount($amount),"name"=>tr($method)];
	}
	$payments=$db->single("SELECT sum(amount) FROM payments WHERE method='Cash' AND deleted_01=0 AND TIMESTAMP(created_at)> TIMESTAMP(?) AND created_by=?" ,[$last_stage['created_at'],auth()->id]);
	$payments    = $payments?$payments:0;
	$adjustments = $adjustments?$adjustments:0;
	$expenses = $expenses?$expenses:0;
	$cash_d      = $payments+$last_stage['amount']+$adjustments-$expenses;
?>
<!DOCTYPE html>
<html lang="<?= strtolower($ml->lang) ?>" dir="<?= $ml->lang=="AR"?'rtl':'ltr' ?>">
	<?php require($root."/inc/head.php") ?>
	



	<body class=" <?= isset($page['class'])?$page['class']:'' ?> " >
		<?php require($root."/inc/header.php") ?>
		
	<br>
	<?= $display->display_messages() ?>




	<div class="card shadow">
		<div class="card-body row p-3 justify-content-center">
			<?php foreach ($links as $key => $link): ?>
				<?php if (can($link['role'])): ?>
					<div class="col-md-3 text-center p-2" >
						<a href="<?= $link['url'] ?>" class="my-0">
						<div class="card card-body shadow card-hover my-0" style="background: <?= $link['color'] ?>;color:white">
							<h1><?= $link['icon'] ?></h1>
							<h3><?= tr($link['title']) ?></h3>
						</div>
					</a>
					</div>
				<?php endif ?>
			<?php endforeach ?>
		</div>
	</div>


	<div class="row">
		<div class="col-md-6 pb-1">
			<div class="card shadow h-100">
				<p dir="ltr" class="px-5 py-3 text-monospace"><strong><?= date("Y-m-d h:i A",strtotime($last_stage['created_at'])) ?></strong></p>
				<table class="table  table-sm table-striped ">
								
					<tbody>
						<?php 
						$total = -$expenses2;
						 ?>
										<?php foreach ($pay_by as $key => $payment): ?>
						<tr>
							<td><strong><?= tr($payment['name']) ?></strong>:</td>
							<td><strong><?= amount($payment['value']) ?></strong></td>
						</tr>
							<?php $total+=$payment['value']; endforeach ?>

					
						<tr>
							<td><strong><a href="<?= $app_url ?>/expenses"><?= tr('Expenses') ?></a></strong>:</td>
							<td><strong><?= amount($expenses2) ?></strong></td>
						</tr>

						<tr class="table-active">
							<td><strong><?= tr("Total") ?></strong>:</td>
							<td><strong><?= amount($total) ?></strong></td>
						</tr>
					</tbody>
				</table>

			</div>
		</div>
		<div class="col-md-6 pb-1">
			<div class="card shadow h-100">
				<div class="card-body">
					<h3><?= tr("Cash Drawer") ?></h3>
					<h1 class="text-success text-center text-monospace" style="font-size: 4rem">										<?= amount($cash_d) ?> <small>(<?= amount($last_stage['amount']) ?>)</small>
										</h1>

										<br>


										<div class="row">
											<div class="col-md-12">

												<form method="post">
											<div class="row align-items-end">
												<div class="col">
													<label for=""><?= tr("Amount") ?></label>
													<input type="number" class="form-control" value="0" step="0.1" name="stage" onfocus="$(this).select()">
												</div>
												<div class="col-md-3">
													<button class="btn btn-primary mt-auto"><?= tr("Reset") ?></button>
												</div>
											</div>
											
										</form>

								
										
											</div>
										</div>
				</div>
			</div>
		</div>
	</div>


	<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>


	
	
	</body>
</html>