<?php 
$root="../..";
header('Access-Control-Allow-Origin: *'); 
require_once($root.'/php/g.php');


// storing  request (ie, get/post) global array to a variable  
$requestData= $_REQUEST;
$columns = array( 
// datatable column index  => database column name
	0 => 'd.id', 
	1 => 'd.reference',
	2 => 'name',
	3 => 'd.site',
	4 => 'i.note',
	5 => 'paid2',
	6 => 'cost',
	
);


$rowCount=$db->single("SELECT count(*) FROM deposits WHERE deleted_01=0");
$totalData = $rowCount;


$sql = "

	SELECT *, 
			(SELECT SUM((dd.cost+(dd.cost*dd.tax/100))*dd.quantity) FROM deposit_data dd WHERE dd.deposit_id = d.id AND dd.deleted_01 = 1 )+d.others as cost, 
	
			(SELECT name FROM suppliers s WHERE d.supplier_id = s.id  ) as name 
			FROM deposits d  
			WHERE d.deleted_01=1 AND DATE(d.time_date )>=DATE( ? ) AND DATE(d.time_date)<=DATE( ? )

";


if( !empty($requestData['search']['value']) ) {   // if there is a search parameter, $requestData['search']['value'] contains search parameter

	$search = filter_var($requestData['search']['value'], FILTER_SANITIZE_STRING);
	$sql.=" AND ( i.id LIKE '%".$search ."%' "; 
	$sql.=" OR i_no LIKE '%".$search ."%' ";
	$sql.=" OR name LIKE '%".$search ."%' ";
	$sql.=" OR note LIKE '%".$search ."%' ";
	$sql.=" OR i_day LIKE '%".$search ."%' ";
	$sql.="  )";


}


$rowCount = $conn->query($sql)->fetchAll();

$sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

$query         =$conn->query($sql)->fetchAll();


$totalFiltered = count($rowCount);


$data = array();

foreach ($query as $row) {

	$nestedData=array(); 

	$nestedData[] = $row["id"];
	$nestedData[] = escap($row["i_no"]);
	$nestedData[] = escap($row["name"]);
	$nestedData[] = escap($row["i_day"]);
	$nestedData[] = escap($row["note"]);
	$nestedData[] = amount($row["paid2"]);
	$nestedData[] = escap(   sprintf('%0.3f',(floatval($row["cost"])))   );
	
	$nestedData[] = '<div class="btn-group btns-action"><a title="'.$lang['view'].'" target="blank" href="<?= $app_url ?>/imports/view.php?i='.$row["id"].'" class="btn btn-sm btn-outline-secondary"><i class="fas fa-search"></i></a></div>';

	$data[] = $nestedData;
}


$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

echo json_encode($json_data);  // send data as json format
die();