<?php 

if (isset($_POST['new_dep']) && can("manage-deposits") && $tk->passes()) {

	$list   =isset($_POST['list'])?$_POST['list']:"[]";
	$sup_id =isset($_POST['sup_id'])?$_POST['sup_id']:"";
	$reference   =isset($_POST['reference'])?$_POST['reference']:"";
	$time_date  =isset($_POST['time_date'])?$_POST['time_date']:"";
	$site  =isset($_POST['site'])?$_POST['site']:"";
	$has_file  =isset($_POST['has_file'])?$_POST['has_file']:"";


	$note   =isset($_POST['note'])?$_POST['note']:"";
	$others   =isset($_POST['others'])?$_POST['others']:0;

	$v->validate(
		[
			"list"         =>[$list,"required"],
			tr("Supplier") =>[$sup_id,"required|in_table(suppliers,id)"],
			tr("Refrance") =>[$reference,"required|depostit_ref($sup_id)"],
			tr("Date")     =>[$time_date,"required"],
		
		]
	);

	if ($v->passes() ) {
		


		$db->query("INSERT INTO deposits(supplier_id,reference,time_date,note,others, site,created_by) VALUES (?,?,?,?,?,?,?)",
			[ $sup_id,$reference,$time_date,$note,$others,$site,auth()->id ]);
		
		$deposit_id=$db->lastInsertId();


		$list = json_decode($list);

		foreach ($list as $ro) {

			$db->query("INSERT INTO deposit_data(deposit_id, item_id,supplier_id, cost, tax, quantity) VALUES
				(?,?,?,?,?,?)",[
					$deposit_id,
					$ro->id,
					$sup_id,
					$ro->cost,
					$ro->tax,
					$ro->qty,
				]
			);
			
		}

		$cost = $others + $db->single("SELECT sum((cost*quantity)+(cost*quantity*tax/100)) FROM deposit_data WHERE deleted_01=0 AND deposit_id=?",[$deposit_id]);
		$db->query("UPDATE deposits SET cost=? WHERE id = ? ",[$cost,$deposit_id]);

		if ($has_file=="true") {
			$file = new Classes\File;
			$file = $file->save($_FILES['file'])->resize();
			if (!$file->saved()) {
				$display->error($file->errors());
			}else{
				$db->query("UPDATE deposits SET file=? WHERE id = ? ",[$file->id,$deposit_id]);
			}
		}

		$display->success(tr("Deposits created successdully."));
		$redirect->to(add_to_url($this_url,["i","v"],[$deposit_id,"view"]));
	}
}

if (isset($_POST['update_dep']) && can("manage-deposits") && $tk->passes() ) {

	$list   =isset($_POST['list'])?$_POST['list']:"[]";
	$deleted_list   =isset($_POST['deleted_list'])?$_POST['deleted_list']:"[]";
	$sup_id =isset($_POST['sup_id'])?$_POST['sup_id']:"";
	$note   =isset($_POST['note'])?$_POST['note']:"";
	$tax   =isset($_POST['tax'])?$_POST['tax']:"";
	$id   =isset($_POST['id'])?$_POST['id']:"";
	$others   =isset($_POST['others'])?$_POST['others']:0;
	$reference   =isset($_POST['reference'])?$_POST['reference']:"";
	$time_date  =isset($_POST['time_date'])?$_POST['time_date']:"";
	$site  =isset($_POST['site'])?$_POST['site']:"";
	$has_file  =isset($_POST['has_file'])?$_POST['has_file']:"";
	$status  =isset($_POST['status'])?$_POST['status']:"Active";
	$ready_01  =isset($_POST['ready_01'])?1:0;




	$v->validate(
		[
			"list"         =>[$list,"required"],
			"id"         =>[$id,"required"],
			tr("Supplier") =>[$sup_id,"required|in_table(suppliers,id)"],
			tr("Refrance") =>[$reference,"required|depostit_ref($sup_id,$id)"],
			tr("Date")     =>[$time_date,"required"],
	
		]
	);

	if ($v->passes()) {
		
		

		
			$db->query("UPDATE deposits SET supplier_id=?,reference=?, site =? ,tax=?,note=?, others=?,time_date=?, status=?, ready_01=?,updated_at=?,updated_by=? WHERE id = ?",
			[ $sup_id,$reference, $site,$tax,$note,$others,$time_date,$status, $ready_01,timestamp(),auth()->id,$id ]);

		

			$list = json_decode($list);
			$deleted_list = json_decode($deleted_list);

			foreach ($list as $ro) {
				
				if (isset($ro->dd_id) && !empty($ro->dd_id)  && is_numeric($ro->dd_id) ) {
					$db->query("UPDATE deposit_data SET supplier_id=?, cost=?, tax=?, quantity=? WHERE id = ? ",
						[
							$sup_id,
							$ro->cost,
							$ro->tax,
							$ro->qty,
							$ro->dd_id,
						]
					);
					
					
				}else{
					
					$db->query("INSERT INTO deposit_data(deposit_id, item_id,supplier_id, cost, tax, quantity) VALUES
						(?,?,?,?,?,?)",[
							$id ,
							$ro->id,
							$sup_id,
							$ro->cost,
							$ro->tax,
							$ro->qty,
						]
					);
				
				}
			}

			foreach ($deleted_list as $ro) {
				// var_dump($ro->q_id );
				if (is_numeric($ro->dd_id) ) {
					$db->query("UPDATE deposit_data SET deleted_01 = 1 WHERE id = ? ",[$ro->dd_id]);
				}
			}
			$cost = $others + $db->single("SELECT sum((cost*quantity)+(cost*quantity*tax/100)) FROM deposit_data WHERE deleted_01=0 AND deposit_id=?",[$id ]);
			$db->query("UPDATE deposits SET cost=? WHERE id = ? ",[$cost,$id ]);


			if ($has_file=="true") {
				$file = new Classes\File;
				$file = $file->save($_FILES['file'])->resize();
				if (!$file->saved()) {
					$display->error($file->errors());
				}else{
					$db->query("UPDATE deposits SET file=? WHERE id = ? ",[$file->id,$id]);
				}
			}
			$display->success(tr("Deposit updated successdully."));
		
		



		
		
	}
}

if (isset($_POST['update_dep2']) && can("manage-deposits") && $tk->passes() ) {




	$note   =isset($_POST['note'])?$_POST['note']:"";

	$id   =isset($_POST['id'])?$_POST['id']:"";
	
	$reference   =isset($_POST['reference'])?$_POST['reference']:"";
	$time_date  =isset($_POST['time_date'])?$_POST['time_date']:"";

	$has_file  =isset($_POST['has_file'])?$_POST['has_file']:"";





	$v->validate(
		[

			"id"         =>[$id,"required"],

			tr("Refrance") =>[$reference,"required|unique_table(deposits,reference,".$id.")"],
			tr("Date")     =>[$time_date,"required"],
	
		]
	);

	if ($v->passes()) {
		
		

		
			$db->query("UPDATE deposits SET reference=? ,note=?,time_date=?,updated_at=?,updated_by=? WHERE id = ?",
			[ $reference,$note,$time_date,timestamp(),auth()->id,$id ]);



			if ($has_file=="true") {
				$file = new Classes\File;
				$file = $file->save($_FILES['file'])->resize();
				if (!$file->saved()) {
					$display->error($file->errors());
				}else{
					$db->query("UPDATE deposits SET file=? WHERE id = ? ",[$file->id,$id]);
				}
			}
			$display->success(tr("Deposit updated successdully."));
				
		$_POST=[];
	}
}




if (isset($_POST['delete_pur'])  && can("manage-deposits") ) {

	$id   =isset($_POST['id'])?$_POST['id']:"";

	$v->validate(
		[
			"id"         =>[$id,"required"],
		]
	);

	if ($tk->passes() && $v->passes()) {
	
		$db->query("UPDATE deposits SET deleted_01=1 ,updated_by=?,updated_at=? WHERE id = ?",[auth()->id,timestamp(),$id]);
		$db->query("UPDATE deposit_data SET deleted_01=1 WHERE deposit_id = ?",[$id]);

		$display->success(tr("Deposits deleted successfully."));

		$redirect->to(remove_from_url($this_url,["v","i"]));
	}
}

if (isset($_POST['delete_pur_file'])  && can("manage-deposits") ) {

	$id   =isset($_POST['id'])?$_POST['id']:"";

	$v->validate(
		[
			"id"         =>[$id,"required"],
		]
	);

	if ($tk->passes() && $v->passes()) {

		$data = $db->row("SELECT * FROM deposits WHERE id = ? ",[$id]);

		if (file_remove($data['file'])) {
			$db->query("UPDATE deposits SET file=0 ,updated_by=?,updated_at=? WHERE id = ?",[auth()->id,timestamp(),$id]);

			$display->success(tr("Deposits updated successfully."));
		}

	

	}
}

if (isset($_POST['new_file']) && $tk->passes() && can("manage-deposits")) {

	$name = isset($_POST['name'])?$_POST['name']:'';
	$has_file = isset($_POST['has_file'])?$_POST['has_file']:'';

	$id = isset($_POST['id'])?$_POST['id']:'';

	$v->validate([
		tr("File")=>[$has_file,"required"],
		"ID"=>[$id,"required|in_table(deposits,id)"],
	]);

	if ($v->passes()) {

		if ($has_file=="true") {

			$file = new Classes\File;
			$file->save($_FILES['file'])->resize();
			if (!$file->saved()) {
				$display->error($file->errors());

			}else{

				$db->query("INSERT INTO deposit_files( file_id, deposit_id) VALUES(?,?)",[$file->id,$id]);

				$display->success("File added successfully.");
			}
			
		}
	}
}


if (isset($_POST['delete_file']) && $tk->passes() && can("manage-deposits")) {

	$id = isset($_POST['id'])?$_POST['id']:'';
	
	$v->validate([

		"ID"=>[$id,"required|in_table(deposit_files,id)"],
	]);

	if ($v->passes()) {
		$file = $db->single("SELECT file_id FROM deposit_files WHERE id = ? ",[$id]);
		$status = file_remove($file);
	
		if ($status) {
			$db->query("DELETE FROM deposit_files WHERE id = ?  ",[$id]);

			$display->success("File deleted successfully.");
		}else{
			$display->error("Unable to delete file.");
		}
		

	}
}


$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':

		$page_nav=[
			"back"=>remove_from_url($this_url,["v","i"]),
			"breadcrumb"=>[
				tr("Deposits")=>$app_url."/deposits/",
				tr("New")=>"",
			],
		];

		$page=[
			"title"=>tr("New deposite"),
			"active"=>"deposits",
			"class"=>"sidebar-xs"
		];

	
		$page_view = "views/new.php";
	break;

	case 'view':
		// $user->authorize("manage-deposits|view-deposits");
		$page_nav=[

			"breadcrumb"=>[
				tr("Deposites")=>$app_url."/deposits/",
				tr("View")=>"",
			],
		];


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("
				SELECT * FROM deposits WHERE id=? 
				",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}

		$list=$db->query("
				SELECT dd.*, i.name FROM deposit_data dd LEFT JOIN items i ON dd.item_id = i.id 
				WHERE dd.deleted_01 = 0 AND dd.deposit_id = ? 
				",[$_GET['i']]);


		

		$deposit_data=[];


		foreach ($list as $key => $ro) {
			$deposit_data[]=[
				
				"id"         =>$ro['item_id'],
				"dd_id"       =>$ro['id'],
				"name"       =>$ro['name'],
				"cost"       =>$ro['cost'],
				"qty"       =>$ro['quantity'],
				"tax"       =>$ro['tax'],
			];

		}
	
	

		$page=[
			"title"=>tr("Deposits")." #".$_GET['i'],
			"active"=>"diposits",
			"class"=>"sidebar-xs"
		];


		$page_view = "views/view.php";
	break;

	case 'deleted':
		// $user->authorize("view-deposits|manage-deposits");

		$from = date("Y-m-d",strtotime("-1 year"));
		$to   = date("Y-m-d");



		if (isset($_GET['from'])) {
		  $from = date("Y-m-d",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d",strtotime($_GET['to']));
		}

		$list=$db->query( "

			SELECT *, 
			(SELECT SUM((dd.cost+(dd.cost*dd.tax/100))*dd.quantity) FROM deposit_data dd WHERE dd.deposit_id = d.id AND dd.deleted_01 = 1 )+d.others as cost, 
	
			(SELECT name FROM suppliers s WHERE d.supplier_id = s.id  ) as name 
			FROM deposits d  
			WHERE d.deleted_01=1 AND DATE(d.time_date )>=DATE( ? ) AND DATE(d.time_date)<=DATE( ? )
			
		",[$from,$to]);

			$page_nav=[
				"reload"=>1,
				"breadcrumb"=>[
					tr("Deposits")=>$app_url."/deposits",
					tr("Deleted")=>$app_url."/deposits",
				],
				"date_filter"=>[
					"from"=>$from,
					"to"=>$to
				]
			];

			$page=[
				"title"=>tr("Deposits")." ".$from."-".$to,
				"active"=>"deposits",
			];


		$page_view = "views/deleted.php";
	break;

	case 'site':
		$user->authorize("view-deposits|manage-deposits");

		$from = date("Y-m-d",strtotime("-1 year"));
		$to   = date("Y-m-d");



		if (isset($_GET['from'])) {
		  $from = date("Y-m-d",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d",strtotime($_GET['to']));
		}

		$list=$db->query( "

			SELECT *, 
			(SELECT SUM((dd.cost+(dd.cost*dd.tax/100))*dd.quantity) FROM deposit_data dd WHERE dd.deposit_id = d.id AND dd.deleted_01 = 0 )+d.others as cost, 
			(SELECT sum(s.amount) FROM sup_payment s WHERE s.deleted_01=0 AND d.id IN (SELECT deposit_id FROM sup_payment_deposits)  ) as paid2,
			(SELECT name FROM suppliers s WHERE d.supplier_id = s.id  ) as name 
			FROM deposits d  
			WHERE d.deleted_01=0 AND DATE(d.time_date )>=DATE( ? ) AND DATE(d.time_date)<=DATE( ? ) AND site=?
			ORDER BY paid2 DESC
		",[$from,$to,$_GET['site']]);

			$page_nav=[
				"reload"=>1,
				"breadcrumb"=>[
					tr("Deposits")=>$app_url."/deposits",
				],
				"date_filter"=>[
					"from"=>$from,
					"to"=>$to
				]
			];

			$page=[
				"title"=>tr("Deposits")." ".$from."-".$to,
				"active"=>"deposits",
			];


		$page_view = "views/view_site.php";
	break;
	
	default:
		// $user->authorize("view-deposits|manage-deposits");

		$from = date("Y-m-d",strtotime("-6 month"));
		$to   = date("Y-m-d");



		if (isset($_GET['from'])) {
		  $from = date("Y-m-d",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d",strtotime($_GET['to']));
		}

		$list=$db->query( "

			SELECT *, 
			(SELECT SUM((dd.cost+(dd.cost*dd.tax/100))*dd.quantity) FROM stock_product_quantity dd WHERE dd.deposit_id = d.id  )+d.others as cost, 
		
			(SELECT name FROM suppliers s WHERE d.sup_id = s.id  ) as name 
			FROM imports d  
			WHERE d.deleted_01=0 AND DATE(d.time_date )>=DATE( ? ) AND DATE(d.time_date)<=DATE( ? )
			ORDER BY d.id DESC
		",[$from,$to]);

			$page_nav=[
				"reload"=>1,
				"breadcrumb"=>[
					tr("Deposits")=>$app_url."/deposits",
				],
				"date_filter"=>[
					"from"=>$from,
					"to"=>$to
				]
			];

			$page=[
				"title"=>tr("Deposits")." ".$from."-".$to,
				"active"=>"deposits",
			];


		$page_view = "views/index.php";
	break;
}