<?php 
	$root="..";
	require($root."/php/init.php");
	$user->authorize('view-reports');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

function writeXLSX($filename, $rows, $keys = [], $formats = []) {
    // instantiate the class
    $doc = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $doc->getActiveSheet();

    // $keys are for the header row.  If they are supplied we start writing at row 2
    if ($keys) {
        $offset = 2;
    } else {
        $offset = 1;
    }

    // write the rows
    $i = 0;
    foreach($rows as $row) {
        $doc->getActiveSheet()->fromArray($row, null, 'A' . ($i++ + $offset));
    }

    // write the header row from the $keys
    if ($keys) {
        $doc->setActiveSheetIndex(0);
        $doc->getActiveSheet()->fromArray($keys, null, 'A1');
    }

    // get last row and column for formatting
    $last_column = $doc->getActiveSheet()->getHighestColumn();
    $last_row = $doc->getActiveSheet()->getHighestRow();

    // autosize all columns to content width
    for ($i = 'A'; $i <= $last_column; $i++) {
        $doc->getActiveSheet()->getColumnDimension($i)->setAutoSize(TRUE);
    }

    // if $keys, freeze the header row and make it bold
    if ($keys) {
        $doc->getActiveSheet()->freezePane('A2');
        $doc->getActiveSheet()->getStyle('A1:' . $last_column . '1')->getFont()->setBold(true);
    }

    // format all columns as text
    $doc->getActiveSheet()->getStyle('A2:' . $last_column . $last_row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_TEXT);
    if ($formats) {
        // if there are user supplied formats, set each column format accordingly
        // $formats should be an array with column letter as key and one of the PhpOffice constants as value
        // https://phpoffice.github.io/PhpSpreadsheet/1.2.1/PhpOffice/PhpSpreadsheet/Style/NumberFormat.html
        // EXAMPLE:
        // ['C' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER_00, 'D' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER_00]
        foreach ($formats as $col => $format) {
            $doc->getActiveSheet()->getStyle($col . $offset . ':' . $col . $last_row)->getNumberFormat()->setFormatCode($format);
        }
    }

    // write and save the file
    $writer = new PhpOffice\PhpSpreadsheet\Writer\Xlsx($doc);
    $writer->save($filename);
}


$from = date("Y-m-d",strtotime("-1 month"));
$to = date("Y-m-d");



if (isset($_GET['from'])) {
  $from = date("Y-m-d",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
  $to = date("Y-m-d",strtotime($_GET['to']));
}



$type = "excel";

if (isset($_GET['type'])) {
	$type = $_GET['type'];
}

switch ($type) {
	case 'value':
		// code...
		break;
	
	default:
		
	  $list=$db->query( "


        SELECT *, 
            (SELECT SUM((dd.cost+(dd.cost*dd.tax/100))*dd.quantity) FROM deposit_data dd WHERE dd.deposit_id = d.id AND dd.deleted_01 = 0 )+d.others as cost, 
            (SELECT SUM((dd.cost*dd.tax/100)*dd.quantity) FROM deposit_data dd WHERE dd.deposit_id = d.id AND dd.deleted_01 = 0 ) as tax, 
            (SELECT sum(s.amount) FROM sup_payment s WHERE s.deleted_01=0 AND d.id IN (SELECT deposit_id FROM sup_payment_deposits)  ) as paid2,
            (SELECT name FROM suppliers s WHERE d.supplier_id = s.id  ) as name ,
            (SELECT vat_in FROM suppliers s WHERE d.supplier_id = s.id  ) as vat_in 
            FROM deposits d  
            WHERE d.deleted_01=0 AND DATE(d.time_date )>=DATE( ? ) AND DATE(d.time_date)<=DATE( ? ) AND d.status='Active' ORDER BY d.time_date
        


        ",[$from,$to]);

      $data=[];

      $totals=[
        "cost"=>0,
        "paid"=>0,
        "vat"=>0,
        "taxed"=>0,
        "tax_free"=>0,
      ];

      foreach ($list as $key => $ro) {

        $files = $db->column("SELECT file_id FROM deposit_files WHERE deposit_id=?",[$ro['id']]);
        $file_list=[];
        foreach($files as  $file){
            array_push($file_list, file_get($file));
        }

        $site = "--";

        if ($ro['site']==0) {
            // code...
        }

        if ($ro['site']=="-1") {
            // code...
        }

        if ($ro['site']=="-2") {
            // code...
        }

        if ($ro['site']>0) {
           $site = $db->single("SELECT name FROM sites WHERE id = ? ",[$ro['site']]);
        }

       

        $taxed= $db->single("SELECT sum(cost*quantity) FROM deposit_data pd WHERE pd.deleted_01=0 and deposit_id=? and tax>0 ",[$ro['id']]);
        $tax_free=$ro['others']+$db->single("SELECT sum(cost*quantity) FROM deposit_data pd WHERE pd.deleted_01=0 AND tax=0 and deposit_id=?",[$ro['id']]);

         $totals['taxed']+=$taxed;
         $totals['tax_free']+=$tax_free;
         $totals['vat']+=$ro['tax'];
         $totals['paid']+=($ro['paid2']>0?$ro['cost']:0);
         $totals['cost']+=$ro['cost'];

         $data[]=[
                tr("No") => $ro['id'],
                tr("Site") => $site,
              tr("Date") => $ro['time_date'],
              tr("Refrence") => $ro['reference'],
              tr("Supplier") => $ro['name'],
              tr("VAT IN") => $ro['vat_in'],
              tr("Cost") => amount($ro['cost']),
              tr("Paid") => amount(($ro['paid2']>0?$ro['cost']:0)),
              tr("VAT") => amount($ro['tax']),
        
              tr("Taxed") => amount($taxed),
              tr("Tax free") => amount($tax_free),
               tr("Status")=>$ro['status'],
              tr("Files")=>implode(' | ', $file_list),
             
            ];
      }

      $data[]=[
                tr("No") => "",
                tr("Site") => "",
              tr("Date") => "",
              tr("Refrence") => "",
              tr("Supplier") => "",
              tr("VAT IN") => "",
              tr("Cost") => "",
              tr("Paid") => "",
              tr("VAT") => "",
        
              tr("Taxed") => "",
              tr("Tax free") => "",
               tr("Status")=>"",
              tr("Files")=>"",
             
            ];


      $data[]=[
                tr("No") => "",
                tr("Site") => "",
              tr("Date") => "",
              tr("Refrence") => "",
              tr("Supplier") => "",
              tr("VAT IN") => "TOTAL",
              tr("Cost") => amount($totals['cost']),
              tr("Paid") => amount($totals['paid']),
              tr("VAT") => amount($totals['vat']),
        
              tr("Taxed") => amount($totals['taxed']),
              tr("Tax free") => amount($totals['tax_free']),
               tr("Status")=>"",
              tr("Files")=>"",
             
            ];




	  $keys = array_keys(current($data));
	$formats = ['B' => \PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER_00];



	 header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. tr("Deposit")." ".$from."-".$to.".xlsx").'"';


        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. tr("Deposit")." ".$from."-".$to.".xlsx".'"');
        writeXLSX('php://output', $data, $keys, $formats);
	break;
}
sleep(1);
