<?php 

	$ispaid = 0;
 ?>
<form method="post" class="row" id="viewImportPage" autocomplete="off" enctype="multipart/form-data">
	<div class="col" >
		<div class="card">
			<div class="card-header">
				<div class="row">
					<div class="col-md-6 text-start">
						<h3><?= tr("Deposits")." #".$data['id'] ?></h3>
						<?php if ($data['deleted_01']==0): ?>
													<div class="d-flex">
							<div class="input-group col-6">
								<div class="input-group-prepend">
									<span class="input-group-text"><span class="badge badge-<?= $data['status']=='Active'?'success':'danger' ?>"><?= tr($data['status']) ?></span></span>
								</div>
						
									<select name="status" class="form-control">
										<option <?= $data['status']=='Active'?'selected':'' ?> value="Active"><?= tr("Active") ?></option>
										<option <?= $data['status']=='Inactive'?'selected':'' ?> value="Inactive"><?= tr("Inactive") ?></option>
									</select>
								
							</div>

					<?php if ($db->single("SELECT SUM(amount) FROM sup_payment WHERE id IN (SELECT payment_id FROM sup_payment_deposits WHERE deposit_id=?)  AND deleted_01=0",[$data['id']])<=0): ?>
														<div class="form-check">
  <input class="form-check-input" type="checkbox" value="1" name="ready_01" id="defaultCheck1" <?= $data['ready_01']==1?'checked':'' ?>>
  <label class="form-check-label" for="defaultCheck1">
    <?= tr("Ready to pay") ?>
  </label>
</div>
					<?php endif ?>

						</div>
						<?php endif ?>

					</div>
					<?php if ($data['deleted_01']==0): ?>
								<div class="col-md-6 text-end">
						<?php if ($db->single("SELECT SUM(amount) FROM sup_payment WHERE id IN (SELECT payment_id FROM sup_payment_deposits WHERE deposit_id=?)  AND deleted_01=0",[$data['id']])<1 && $data['ready_01']==1): ?>
							<button onclick='window.open("<?= $app_url ?>/suppliers/payment.php?v=new&popup=1&deposit=<?=  $data['id'] ?>&opener=<?= urlencode($this_url) ?>","_blank","height=820px width=640px");'   role="button" class="btn btn-info" ><?= tr("Payment vouchers") ?></button>
						<?php endif ?>
						
						
						<?php if (can("manage-deposits")): ?>
						<?php if ($db->single("SELECT count(*) FROM sup_payment WHERE deleted_01=0 AND id IN (SELECT payment_id FROM sup_payment_deposits WHERE deposit_id=?) ",[$data['id']])==0): ?>
										<button type="button" data-target="#delete-modal" data-toggle="modal" role="button" class="btn btn-danger" title="<?= $lang['delete'] ?>"><i class="fas fa-trash"></i></button>
						<?php endif ?>
			
						<?php endif ?>
						
					</div>
					<?php endif ?>
			
				</div>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-md-4 ">
						<div class="row">
							<div class="col-12 form-group">
								<label for=""><?= tr("Supplier") ?></label>
								
					

								<div class="d-flex">
									<select v-model="sup" <?= $ispaid?"disabled":'' ?> onchange="viewImportPage.sup=$(this).val()" name="sup_id" class=" form-control text-center sup-select" data-live-search="true" data-size="8" data-style="btn-default border text-center">
											<option  v-for="(supr, index) in suppliers" :value="supr.id" >{{supr.name}}</option>
										</select>
										<!-- <button data-toggle="modal" data-target="#new-supplier-modal" type="button" class="btn btn-outline-primary btn-sm"><i class="fas fa-plus"></i></button> -->
								</div>
									
						
								
								<label><?= tr("Refrence") ?></label>
								<input type="text" class="form-control" name="reference" required="" value="<?= old('reference',$data['reference']) ?>"><br>
								
								<label><?= tr("Date") ?></label>
								<input type="date" class="form-control " name="time_date" required="" value="<?= old('time_date',$data['time_date']) ?>"><br>

									<label for=""><?= tr("Site") ?></label>

							<select name="site" class="form-control select2" >
								<option <?= old("site",$data['site'])=="-1"?'selected':'' ?> value="-1"><?= tr("None") ?></option>
								<option <?= old("site",$data['site'])=="-2"?'selected':'' ?> value="-2"><?= tr("Office") ?></option>
								<option value="0" <?= old("site",$data['site'])=="0"?'selected':'' ?>><?= tr("All") ?></option>
								<?php foreach ($db->query("SELECT * FROM sites WHERE deleted_01 = 0 AND (status='Active' OR id = ? )",[$data['site']]) as $key => $site): ?>
									<option <?= old("site",$data['site'])==$site['id']?'selected':'' ?> value="<?= $site['id'] ?>">#<?= $site['id'] ?> <?= $site['name'] ?></option>
								<?php endforeach ?>
							</select>	
	
						



								<label for=""><?= tr("Note") ?></label>
								<textarea name="note"  cols="30" rows="3" class="form-control" ><?= old('note',$data['note']) ?></textarea><br>
								<!-- <label for=""><?= tr("Attachment") ?></label>
								<?= file_input('form-control') ?><br>
								<?php if ($data['file']): ?>
								<a href="<?= file_get($data['file']) ?>" target="_blank" class="btn btn-outline-secondary" title="<?= tr("View") ?>"><i class="fas fa-paperclip"></i></a>
								<a href="#" data-toggle="modal" data-target="#delete-file-modal" class="btn btn-outline-danger" title="<?= tr("Delete") ?>"><i class="fas fa-trash-alt"></i></a>
								<?php endif ?> -->
									 <label for=""><?= tr("Attachment") ?></label>
								<table class="table table-sm border">
									<thead class="bg-indigo">
										<tr >
											<td><?= tr("File") ?></td>
											<td class="text-center">!</td>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($db->query("SELECT u.file_name,d.id,u.id,d.id as did FROM deposit_files d LEFT JOIN uploads u ON d.file_id=u.id WHERE d.deposit_id=?",[$data['id']]) as $key => $file): ?>
											<tr>
												<td>
													<a href="<?= file_get($file['id']) ?>" target="blank"><?= $file['file_name'] ?></a>
												</td>
												<td class="text-center">
													<a href="#" data-toggle="modal" data-target="#delete-file-modal" onclick="$('#file-id').val(<?= $file['did'] ?>)"><?= tr("Delete") ?></a>
												</td>
											</tr>
										<?php endforeach ?>
									</tbody>
									<tfoot>
										<tr>
											<td colspan="2">
												<button type="button" data-toggle="modal" data-target="#new-file-modal" class="btn btn-light"><?= tr("New") ?></button>
											</td>
										</tr>
									</tfoot>
								</table>
							</div>
						</div>
						<hr>
		
						<?php $sup_pay_table=$db->query("SELECT * FROM sup_payment WHERE deleted_01=0 AND id IN (SELECT payment_id FROM sup_payment_deposits WHERE deposit_id=?) ",[$data['id']]) ?>
						<div class="row" v-show="<?= count($sup_pay_table) ?>">
							<h6><?= tr("Payments") ?></h6>
							<table class="col-12 table table-sm border">
								<thead class="bg-secondary text-light">
									<tr>
										<th>#</th>
										<th><?= tr("Amount") ?></th>
										<th><?= tr("Date") ?></th>
										<th class="text-center">!</th>
									</tr>
								</thead>
								<tbody class="text-monospace">
									<?php foreach ($sup_pay_table as $key => $pay): ?>
										<tr>
											<td><?= $pay['id'] ?></td>
											<td><?= amount($pay['amount']) ?>/<?= amount($data['cost']) ?></td>
											<td><?= $pay['p_day'] ?></td>
											<td><a href="<?= $app_url ?>/suppliers/payment.php?v=view&i=<?= $pay['id'] ?>"><?= tr("View") ?></a></td>
										</tr>
									<?php endforeach ?>
								</tbody>
							</table>
						</div>
						
					</div>
					<div class="col-md-8">
						<div class="row ">
							<div class="col">
								<div class="input-group">
									<div class="input-group-prepend">
										<span class="input-group-text"><i class="fas fa-search"></i></span>
									</div>
									<input
									type="text"
									:class="{'form-control':true, 'is-invalid':barcode_error}"
									v-model="search"
									placeholder="<?= tr("Search") ?>"
									id="search-input"
									<?= $ispaid?"disabled":'' ?>
									@keyup.enter="addToListByEnter()">
									<div class="input-group-append">
										<a class="btn btn-outline-secondary" target="_blank" href="<?= $app_url ?>/items/?v=new"><?= tr("New") ?></a>
									</div>
									<div class="invalid-feedback" v-show='barcode_error'>
										<?= tr("Item not exist") ?> <a href="<?= $app_url ?>/items/?v=new" target="_blank"><?= tr("New") ?></a>
									</div>
								</div>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col p-0 table-responsive">
								<table class="table table-sm table-hover table-striped border">
									<thead class="bg-indigo text-light">
										<tr>
											<th>#</th>
											<th><?= tr("Item") ?></th>
									
											<th class="text-center"><?= tr("Quantity") ?></th>
											<th class="text-center"><?= tr("Cost") ?></th>
											<th class="text-center"><?= tr("VAT") ?> %</th>
				
											<th class="text-center"><?= tr("Total") ?></th>
											<th class="text-center"><i class="fas fa-exclamation-circle"></i></th>
										</tr>
									</thead>
									<tbody>
										<tr v-for="(item,index) in list" :class="{'table-warning':(item.id==exist_id)}">
											<td scope="row">{{ index+1 }}</td>
											<td>{{ item.name }}</td>
											
											<td class="text-center px-0" style="padding: 0 !important;"><input @focus="$event.target.select()" @change="getTotalListcost()" <?= $ispaid?"disabled":'' ?> @keyup="getTotalListcost()"  v-model="item.qty" type="number" min="0" step="0.000001" class="form-control text-center text-monospace"></td>

											<td class="text-center px-0"><input @focus="$event.target.select()" @change="getTotalListcost()" @keyup="getTotalListcost()" <?= $ispaid?"disabled":'' ?> v-model="item.cost" type="number" min="0" step="0.000001" class="form-control text-center text-monospace"></td>

											<td class="text-center"><input @focus="$event.target.select()" @change="getTotalListcost()" @keyup="getTotalListcost()" <?= $ispaid?"disabled":'' ?> v-model="item.tax" type="number" min="0" step="0.000001" class="form-control text-center text-monospace"></td>

										
												<td class="text-center text-monospace">{{ (parseFloat(item.qty) *  (parseFloat(item.cost)+parseFloat(item.cost)*parseFloat(item.tax)/100)).toFixed(3)}}</td>
											<td class="text-center">
												<div class="btn-group btns-action">
													<button type="button" @click="deleteFromList(index)" class="btn btn-sm btn-outline-danger"><i class="far fa-trash-alt"></i></button>
									
												</div>
											</td>
										</tr>
											<tr>
											<th colspan="2" class="text"><?= tr("Other") ?></th>
											<th  class="text-center text-monospace px-0"><input name="others" <?= $ispaid?"disabled":'' ?> type="number" v-model="others" step="0.000001"  class=" form-control text-center text-monospace"></th>
												<th class="text-center"></th>
												<th class="text-center"></th>
											<th  class="text-center text-monospace">{{parseFloat(others).toFixed(3)}}</th>
											<th class="text-center"></th>
										</tr>
										<tr>
											<th colspan="5" class="text-end"><?= tr("Total") ?>:</th>
											<th class="text-center text-monospace">{{ (parseFloat(totalcost)+parseFloat(others)).toFixed(3) }}</th>
											<th class="text-center"></th>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					
						
					</div>
			
				</div>
				
			</div>
			<div class="card-footer">
				<?php if (can("manage-deposits") && $data['deleted_01']==0): ?>
						
										<button   name="update_dep" class="btn btn-primary "><?= tr("Save") ?></button>
					
				
				<?php endif ?>
				
			</div>
		</div>
	</div>
	<input type="hidden" :value="JSON.stringify(list)" name="list">
	<input type="hidden" :value="JSON.stringify(deleted_list)" name="deleted_list">
	<input type="hidden" value="<?= $data['id'] ?>" name="id">
</form>


<form method="post" enctype="multipart/form-data">
<div class="modal fade" id="new-file-modal" tabindex="-1" role="dialog" aria-labelledby="new-file-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-file-modalLabel"><?= tr("New") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
      	<div class="alert table-warning"><?= tr("All changes will be disregard. Please save first.") ?></div>
        <label for=""><?= tr("Attachment") ?></label>
        <?= file_input() ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
        <button  class="btn btn-primary" name="new_file"><?= tr("Submit") ?></button>
      </div>
    </div>
  </div>
</div>
<input type="hidden" name="id" value="<?= $data['id'] ?>">
</form>

<form method="post">
<div class="modal fade" id="delete-file-modal" tabindex="-1" role="dialog" aria-labelledby="delete-file-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-file-modalLabel"><?= tr("Are you sure?") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p><?= tr("This file will be deleted.") ?></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
        <button  class="btn btn-danger" name="delete_file"><?= tr("Submit") ?></button>
      </div>
    </div>
  </div>
</div>
<input type="hidden" name="id" id="file-id" value="0">
</form>

	<script>
		const viewImportPage=new Vue({
			el:"#viewImportPage",
			data:{
				error:false,
				id:'<?= escap($data['id']) ?>',
				search:'',
				saved:true,
				others:<?= old("others",$data['others']) ?>,
				
				list:<?= json_encode($deposit_data) ?>,
				deleted_list:[],
	
		
				exist_id:0,
				sup:'<?= escap($data['supplier_id']) ?>',
     			suppliers:[],
     	
	
				totalcost:0,

				barcode_error:false,
				timer:false,

			},
			methods:{

				addToListByEnter:function(event){ // add item to list when press enter
					viewImportPage.search = viewImportPage.search.toString()
					if ( viewImportPage.search.length) {
						$.get('<?= $app_url ?>/items/ajax/', {"f":'enter',"code": viewImportPage.search}, function(data) {
							
							data=JSON.parse(data)

							if (data.length>=1) {
								viewImportPage.add_to_list(data[0])
			
									viewImportPage.search='';
									viewImportPage.barcode_error=false
								
				
							}else{
								viewImportPage.barcode_error=true
							}

						});
				    }
				},
				add_to_list_by_click:function(index){
					
					viewImportPage.add_to_list(viewImportPage.search_list[index])
					
				},
				add_to_list:function(item){
					item.cost=1
					item.qty=1
					item.tax=0
					viewImportPage.list=viewImportPage.list.concat(item)
					viewImportPage.exist_id=0
				},
				deleteFromList:function(index){
					viewImportPage.deleted_list=viewImportPage.deleted_list.concat(viewImportPage.list[index])
					viewImportPage.list.splice(index, 1)
				},
				getTotalListcost:function(){ // calculate total bill cost
					var total=0
					for (var i = 0; i < viewImportPage.list.length; i++) {
						total+= (parseFloat(viewImportPage.list[i].cost )+parseFloat(viewImportPage.list[i].tax)*parseFloat(viewImportPage.list[i].cost )/100 )*parseFloat(viewImportPage.list[i].qty)
					}
					viewImportPage.totalcost=parseFloat(total);

				},
				is_exist:function(id){ // check if item alrady exist in the bill
					for (var i =0; i <viewImportPage.list.length; i++) {
						if (viewImportPage.list[i].id==id) {
							viewImportPage.last=viewImportPage.list[i]

							this.getTotalListcost()
							return true
						}
					}
				},
	
				suppliersList:function(id=<?= $data['supplier_id'] ?>){
			        $.get('<?= $app_url ?>/suppliers/ajax/get-suppliers.php', function(data) {
			          viewImportPage.suppliers=JSON.parse(data)
			        }).then(function(){
			        	   
			        	selectVal=id

			           
			          viewImportPage.sup=selectVal;
			
			          $('.sup-select').val(viewImportPage.sup);

						$('.sup-select').select2()
			        });
			      },
	

			},
		    mounted(){
		      
		    },
		    updated(){
	
		    },

			watch:{
				list:function(){
					this.getTotalListcost()
				},
	
				
			},

		});

		$(document).ready(function() {
			 viewImportPage.suppliersList()
			 viewImportPage.getTotalListcost()


			 	$('#search-input').autocomplete({
	            minLength: 1,
	            source: function(request, response) {

	            	console.log(request)
	                var term = request.term;
	  
	     

	                $.get('<?= $app_url ?>/items/ajax/?f=search&search='+term, function(data) {
	                	
	                    response(data);
	                },'json');
	            },
	
	            select:function(event, ui,item){
	          
	  
	            	viewImportPage.search=ui.item.id
	            	viewImportPage.addToListByEnter()
	            },
	            search: function() {
	                $(this).parent().addClass('ui-autocomplete-processing');
	            },
	            open: function() {
	                $(this).parent().removeClass('ui-autocomplete-processing');
	            }
	        })
	        .focus(function () {
			    $(this).autocomplete("search");
			})
	        .autocomplete('instance')._renderItem = function(ul, item) {
            return $('<li>').append('<span class="font-weight-semibold border-top pb-0">' +'#' + item.id + ' ' + item.name + '</span>').appendTo(ul);
        };

       
		});






		
			
	</script>

<form method="post">
			<div class="modal" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="delete-productLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
	  <div class="modal-dialog modal-dialog-centered" role="document">
	    <div class="modal-content ">
	      <div class="modal-header">
	        <h5 class="modal-title" id="delete-productLabel"><?= tr("Are you sure?") ?></h5>
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          <span aria-hidden="true" style="font-size: 24px">&times;</span>
	        </button>
	      </div>
	      <div class="modal-body">
	        <?= tr("This purchases will be deleted.") ?>
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
	        <button name="delete_pur" class="btn btn-danger" ><?= tr("Yes") ?></button>
	      </div>
	    </div>
	  </div>
	</div>
	<input type="hidden" name="id" value="<?= $data['id'] ?>">
</form>
<form method="post">
			<div class="modal" id="delete-file-modal" tabindex="-1" role="dialog" aria-labelledby="delete-productLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
	  <div class="modal-dialog modal-dialog-centered" role="document">
	    <div class="modal-content ">
	      <div class="modal-header">
	        <h5 class="modal-title" id="delete-productLabel"><?= tr("Are you sure?") ?></h5>
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          <span aria-hidden="true" style="font-size: 24px">&times;</span>
	        </button>
	      </div>
	      <div class="modal-body">
	        <?= tr("This file will be deleted.") ?>
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
	        <button name="delete_pur_file" class="btn btn-danger" ><?= tr("Yes") ?></button>
	      </div>
	    </div>
	  </div>
	</div>
	<input type="hidden" name="id" value="<?= $data['id'] ?>">
</form>