<?php

if (isset($_POST['new']) && $tk->passes() && can("manage-dishes")) {

	$name = isset($_POST['name'])?$_POST['name']:'';
	$name_ar = isset($_POST['name_ar'])?$_POST['name_ar']:'';
	$note = isset($_POST['note'])?$_POST['note']:'';
	$category_id = isset($_POST['category_id'])?$_POST['category_id']:0;
	$sizes = isset($_POST['sizes'])?$_POST['sizes']:[];
	$prices = isset($_POST['prices'])?$_POST['prices']:[];
	$addons = isset($_POST['addons'])?$_POST['addons']:[];
	$aprices = isset($_POST['aprices'])?$_POST['aprices']:[];

	$ingredients = isset($_POST['ingredients'])?$_POST['ingredients']:'[]';
	$ingredients=is_json($ingredients)?$ingredients:"[]";
	$discount=isset($_POST['discount'])?1:0;
	$website=isset($_POST['website'])?1:0;
	$favorite=isset($_POST['favorite'])?1:0;
	$tax_id=isset($_POST['tax_id'])?$_POST['tax_id']:'';
	$readyin=isset($_POST['readyin'])?$_POST['readyin']:0;
	$max_discount=isset($_POST['max_discount'])?$_POST['max_discount']:0;

	$has_file = isset($_POST['has_file'])?$_POST['has_file']:false;
	$has_file = $has_file=="true"?true:false;

	$v->validate([
		tr("Name")=>[$name,"required"],
		tr("Sizes")=>[$sizes,"required"],
		tr("Category")=>[$category_id,"required|in_table(categories,id)"],
	]);

	if ($v->passes() ) {

		$db->query("INSERT INTO dishes(
				name, 
				name_ar, 
				description, 
				category_id, 
				sizes,
				prices,
				addons,
				aprices,
				ingredients,
				discount,
				max_discount,
				website,
				favorite,
				tax_id,
				created_by
			) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ",
			[
				
				$name,
				$name_ar,
				$note,
				$category_id,
				json_encode($sizes),
				json_encode($prices),
				json_encode($addons),
				json_encode($aprices),
				$ingredients,
				$discount,
				$max_discount,
				$website,
				$favorite,
				$tax_id,
				auth()->id
			]
		);

		$id=$db->lastInsertId();

		$file = new Classes\File;
		if ($has_file) {
			$file->save($_FILES['file'])->resize([200, 200]);
			if ($file->saved()) {
				$db->query("UPDATE dishes SET file=? WHERE id = ? ",[$file->id,$id]);
			}else{
				$display->error($file->errors());
			}
		}
		$_POST=[];
		$display->success(tr("Dish created successfully."));
		// $redirect->to(add_to_url($this_url,["v","i"],["edit",$id]));
	}
}

if (isset($_POST['edit']) && $tk->passes() && can("manage-dishes")) {


	$id = isset($_POST['id'])?$_POST['id']:'';

	$name = isset($_POST['name'])?$_POST['name']:'';
	$name_ar = isset($_POST['name_ar'])?$_POST['name_ar']:'';
	$note = isset($_POST['note'])?$_POST['note']:'';
	$category_id = isset($_POST['category_id'])?$_POST['category_id']:0;
	$sizes = isset($_POST['sizes'])?$_POST['sizes']:[];
	$prices = isset($_POST['prices'])?$_POST['prices']:[];
	$addons = isset($_POST['addons'])?$_POST['addons']:[];
	$aprices = isset($_POST['aprices'])?$_POST['aprices']:[];

	$ingredients = isset($_POST['ingredients'])?$_POST['ingredients']:'[]';
	$ingredients=is_json($ingredients)?$ingredients:"[]";

	$has_file = isset($_POST['has_file'])?$_POST['has_file']:false;
	$has_file = $has_file=="true"?true:false;
	$remove_file = isset($_POST['remove_file'])?$_POST['remove_file']:false;
	$remove_file = $remove_file=="true"?true:false;


	$discount=isset($_POST['discount'])?1:0;
	$website=isset($_POST['website'])?1:0;
	$favorite=isset($_POST['favorite'])?1:0;
	$tax_id=isset($_POST['tax_id'])?$_POST['tax_id']:'';
	$readyin=isset($_POST['readyin'])?$_POST['readyin']:0;
	$max_discount=isset($_POST['max_discount'])?$_POST['max_discount']:0;


	$website = isset($_POST['website'])?1:false;
	$favorite = isset($_POST['favorite'])?1:false;

	$v->validate([
		
		tr("ID")=>[$_POST['id'],"required"],
		tr("Name")=>[$name,"required"],
		tr("Sizes")=>[$sizes,"required"],
		tr("Category")=>[$category_id,"required|in_table(categories,id)"],

	]);


	if ($v->passes() ) {

		$data = $db->row("SELECT * FROM dishes WHERE id = ? ",[$id]);

		$db->query(
			"UPDATE dishes  SET 
				name=?, 
				name_ar=?,
				description=?, 
				category_id=?, 
				sizes=?,
				prices=?,
				addons=?,
				aprices=?,
				ingredients=?,
				website=?,
				favorite=?,
				discount=?,
				max_discount=?,
				tax_id=?,
				updated_by=? WHERE id = ? ",
			[
				$name,
				$name_ar,
				$note,
				$category_id,
				json_encode($sizes),
				json_encode($prices),
				json_encode($addons),
				json_encode($aprices),
				$ingredients,
				$website,
				$favorite,
				$discount,
				$max_discount,
				$tax_id,
				auth()->id
				,$id
			]
		);

		if ($remove_file) {
			$db->query("UPDATE dishes SET file=0 WHERE id = ? ",[$id]);
			file_remove($data['file']);
		}

		$file = new Classes\File;
		if ($has_file) {
			$file->save($_FILES['file'])->resize([200, 200]);
			if ($file->saved()) {
				$db->query("UPDATE dishes SET file=? WHERE id = ? ",[$file->id,$id]);
				file_remove($data['file']);
			}else{
				$display->error($file->errors());
			}
		}

		$display->success(tr("Dish updated successfully."));

	}
}



if (isset($_POST['manage_discount']) && $tk->passes() && can("manage-discount")) {


	$categories = isset($_POST['categories'])?$_POST['categories']:[];

	var_dump($categories);
	$discount=isset($_POST['discount'])?1:0;

	$max_discount=isset($_POST['max_discount'])?$_POST['max_discount']:0;


	foreach ($categories as $key => $cat) {
		$db->query(
			"UPDATE dishes  SET 
	
				discount=?,
				max_discount=?,
		
				updated_by=? WHERE category_id = ? ",
			[
				$discount,
				$max_discount,
		
				auth()->id
				,$cat
			]
		);
	}


	$display->success(tr("Discount updated."));
		
}

if (isset($_POST['delete']) && can("manage-dishes")) {
	$id = isset($_POST['id'])?$_POST['id']:'';
	$v->validate([
		tr("ID")=>[$id,"required"],
	]);

	if ($v->passes() && $tk->passes()) {

		$db->query("UPDATE dishes SET deleted_01=1,updated_by=? WHERE id=? ",[auth()->id,$id]);
		$display->success(tr("Dish deleted successfully."));
		$redirect->to(remove_from_url($this_url,["i","v"]));
	}
		
}

$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';

$page=[
	"title"=>tr("Dishes"),
	"active"=>"dishes"
];

switch ($view) {
	case 'new':
		$user->authorize("manage-dishes");
		$page_nav=[
			"breadcrumb"=>[
				tr("Dishes")=>$app_url."/dishes",
				tr("New")=>$app_url."/dishes",
			],
		];
		$page_view = "views/new.php";
	break;

	case 'edit':
			$user->authorize("manage-dishes");
			$page_nav=[
				"breadcrumb"=>[
					tr("Dishes")=>$app_url."/dishes",
					tr("Edit")=>$app_url."/dishes",
				],
			];
			

			if (isset($_GET['i']) && is_numeric($_GET['i'])) {
				$data = $db->row("SELECT * FROM dishes WHERE id = ? ",[$_GET['i']]);

				if (!$data) {
					$redirect->to(404);
				}
			}


			$page_view = "views/edit.php";
		

	
	break;
	
	default:
		$user->authorize("manage-dishes|view-dishes");
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Dishes")=>$app_url."/dishes",
			],
		];


		$list = $db->query("SELECT * FROM  dishes WHERE  deleted_01=0");


		$page_view = "views/index.php";

	break;
}