<?php 


$post_sizes  =old('sizes',[]);
$post_prices =old('prices',[]);


$sizes=[];

for ($i=0; $i < count($post_prices); $i++) { 
	$sizes[]=[
		'sizes'  =>$post_sizes[$i],
		'prices' =>$post_prices[$i],
	];
}


$post_addons  =old('addons',[]);
$post_aprices =old('aprices',[]);



$addons=[];

for ($i=0; $i < count($post_addons); $i++) { 
	$addons[]=[
		'addons'  =>$post_addons[$i],
		'aprices'=>$post_aprices[$i]?$post_aprices[$i]:0,
	];
}
$products =$db->query("SELECT *  FROM stock_poroducts WHERE deleted_01 = 0",);
?>
<form  method="post" enctype='multipart/form-data' id="new_product">
	<div class="card shadow">
		<div class="card-header bg-primary">
			<h3><?= tr("New Dish") ?></h3>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col-lg-7  ">
					<div class="card card-body shadow">
						<div class="row">
							<div class="form-group col">
								<label for=""><?= tr("Name") ?></label>
								<input type="text" class="form-control" name="name"  value="<?= old("name") ?>"><br>
								<label for=""><?= tr("Name") ?> AR</label>
								<input type="text" class="form-control" name="name_ar"  value="<?= old("name_ar") ?>"><br>
								<label for="" ><?= tr("Description") ?></label>
								<textarea name="note" class="form-control" cols="30" rows="3"><?= old("note") ?></textarea><br>
								<label for=""><?= tr("Category") ?></label>
								<select name="category_id" class="form-control">
									<option value="0" disabled  hidden="" selected>Select category</option>
									<?php foreach ($db->query("SELECT * FROM categories WHERE deleted_01=0") as $key => $cat): ?>
									<option <?= old("category_id")==$cat['id']?'selected':'' ?> value="<?= $cat['id'] ?>"><?= escap($cat['name']) ?></option>
									<?php endforeach ?>
								</select><br>
								
								<br>
							</div>
						</div>
						<div class="row border-top pt-2">
							<div class="col">
								<h5><?= tr("Sizes") ?></h5>
								<table class="table table-borderless">
									<tr v-for="(item,index) in list">
										<td>
											<input required=""  v-model="item.sizes"  type="text" class="form-control" name="sizes[]" placeholder="Title">
										</td>
										<td>
											<input required="" v-model="item.prices"  type="number" min="0" step="0.001" class="form-control" name="prices[]" placeholder="Price">
										</td>
										<td class="text-right">
											<button v-if="index>0" @click="list.splice(index, 1);" type="button" class="btn btn-link text-danger btn-sm"><i class="fas fa-trash-alt"></i></button>
										</td>
									</tr>
									<tr>
										<td colspan="3" class="text-end">
											<button @click="list.push({sizes:'',prices:''})" type="button" class="btn btn-info btn-sm"><?= tr("Add new") ?></button>
										</td>
									</tr>
								</table>
							</div>
						</div>
						<div class="row border-top pt-2" >
							<div class="col">
								<h5><?= tr("Addons") ?></h5>
								<table class="table table-borderless">
									<tr v-for="(item,index) in addons">
										<td>
											<input required="" v-model="item.addons" type="text" class="form-control" name="addons[]" placeholder="Name">
										</td>
										<td >
											<input  v-model="item.aprices"  type="number" min="0" step="0.001" class="form-control" name="aprices[]" placeholder="Price">
										</td>
										<td class="text-right">
											<button  @click="addons.splice(index, 1);" type="button" class="btn btn-link text-danger btn-sm"><i class="fas fa-trash-alt"></i></button>
										</td>
									</tr>
									<tr>
										<td colspan="3" class="text-end">
											<button @click="addons.push({addons:'',aprices:''})" type="button" class="btn btn-info btn-sm"><?= tr("Add new") ?></button>
										</td>
									</tr>
								</table>
							</div>
						</div>
						<div class="row border-top pt-2" v-show=0>
							<div class="col" >
								<h5><?= tr("Ingredients") ?></h5>
								<table class="table table-borderless">
									<tr v-for="(item,index) in ingredients">
										<td>
											<select class="form-control" v-model="item.p_id" name="product[]" required="">
												<?php foreach ($products as $key => $ro): ?>
												<option value="<?= $ro['id'] ?>"><?= escap($ro['name']) ?></option>
												<?php endforeach ?>
											</select>
										</td>
										<td>
											<input required="" v-model="item.qty"  type="number" min="0" step="0.001" class="form-control" name="qty[]" placeholder="Quantity">
										</td>
										<td class="text-right">
											<button  @click="ingredients.splice(index, 1);" type="button" class="btn btn-link text-danger btn-sm"><i class="fas fa-trash-alt"></i></button>
										</td>
									</tr>
									<tr>
										<td colspan="3" class="text-end">
											<button @click="ingredients.push({p_id:'',qty:''})" type="button" class="btn btn-info btn-sm"><?= tr("Add new") ?></button>
										</td>
									</tr>
								</table>
								<input type="text" :value="JSON.stringify(ingredients)" hidden="" name="ingredients">
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-5   ">
					
					<div class="card card-body shadow text-center pt-5">
						<div>
							<div class="bg-light" style="width: 150px;height: 150px;margin: 10px auto">
								<img class="rounded-0 fit" src="" onerror="this.onerror=null; this.src='<?= $root ?>/assets/images/noimg.png'" alt="<?= $root ?>/assets/images/noimg.png" id="prdimg">
							</div>
							<button type="button" class="btn btn-info" onclick="$('#file').trigger('click')"><?= tr("Upload Image") ?></button>
						</div>
					</div>


					<div class="card card-body shadow">

						<label for=""><?= tr('Tax') ?> *</label>
						<select name="tax_id" class="form-control" v-model="tax">
							<?php foreach ($db->query("SELECT * FROM taxes") as $key => $tax): ?>
							<option  value="<?= $tax['id'] ?>"><?= $tax['name'] ?> (<?= $tax['percent'] ?>%)</option>
							<?php endforeach ?>
						</select><br>

						<div class="form-check form-check-switchery">
							<label class="form-check-label">
								<input  onchange="app.discount=this.checked" type="checkbox" name="discount" value="1" class="form-check-input-switchery" <?= old('discount')?'checked':'' ?> data-fouc>
								<?= tr("Allow discount") ?>
							</label>
						</div>

						<div v-show="discount">
							<label><?= tr("Max discount") ?>%</label>
							<input type="number" name="max_discount" class="form-control form-control-sm" value="<?= old("max_discount",0) ?>">
							<br>
						</div>
						

						<div class="form-check form-check-switchery">
							<label class="form-check-label">
								<input type="checkbox" name="website" class="form-check-input-switchery" <?= old("website")?'checked':'' ?> data-fouc>
								<?= tr("Show in website") ?>
							</label>
						</div>

						<div class="form-check form-check-switchery">
							<label class="form-check-label">
								<input type="checkbox" name="favorite" class="form-check-input-switchery" <?= old("favorite")?'checked':'' ?> data-fouc>
								<?= tr("Favorite") ?>
							</label>
						</div>

					</div>
				</div>
			</div>
		</div>
		<div class="card-footer text-end">
			<button name="new" class="btn btn-primary"><?= tr("Submit") ?></button>
		</div>
	</div>
	
	<?= file_input([
	"id"=>"file",
	"accept"=>"image/*",
	"onchange"=>"readURL(this,$('#prdimg'));",
	"hidden"=>"1",
	]) ?>
</form>
<script>
	
	const app=new Vue({
		el:"#new_product",
		data:{
			list:<?= json_encode($sizes) ?>,
			addons:<?= json_encode($addons) ?>,
			ingredients:<?= old("ingredients",'[]') ?>,
			discount:<?= old("discount",0) ?>,
			tax:"<?= old('tax_id',$db->single('SELECT id FROM taxes WHERE default_01=1 LIMIT 1')) ?>",
		}
	});

	function readURL(input,target) {
	  if (input.files && input.files[0]) {
	    var reader = new FileReader();
	    
	    reader.onload = function(e) {
	      target.attr('src', e.target.result);
	    }
	    
	    reader.readAsDataURL(input.files[0]);
	  }
	}
</script>