<?php 


if (isset($_POST['new_expenses']) && can("manage-expenses|add-expenses")) {
	
	$type   = isset($_POST['type'])?$_POST['type']:'';
	$e_date = isset($_POST['e_date'])?$_POST['e_date']:'';
	$amount = isset($_POST['amount'])?$_POST['amount']:'';
	$note   = isset($_POST['note'])?$_POST['note']:'';
	$branch_id   = isset($_POST['branch_id'])?$_POST['branch_id']:$_SESSION['branch_id'];
	$cash_d   = isset($_POST['cash_d'])?1:0;
	$recurring   = isset($_POST['recurring'])?1:0;
	$recurring_type   = isset($_POST['recurring_type'])?$_POST['recurring_type']:'';

	in_array($recurring_type, ['Month',"Week","Day"])?:$recurring=false;

	$v->validate([
		tr("Type")=>[$type,'required'],
		tr("Amount")=>[$amount,'required'],
		tr("Date")=>[$e_date,'required'],
	]);

	if ($v->passes() && $tk->passes()) {
		$db->query(
			"INSERT INTO expenses(e_date, type, amount, note, recurring_type, recurring, cash_d,branch_id,created_by) VALUES(?,?,?,?,?,?,?,?,?)",
			[$e_date,$type,$amount,$note, $recurring_type, $recurring, $cash_d,$branch_id,auth()->id]
		);

		$id=$db->lastInsertId();

		if (isset($_POST['has_file'])) {
			if ($_POST['has_file']=="true") {
				$file = file_save($_FILES['file']);
				if (!$file['status']) {
					$display->error($file['message']);
				}else{
					$db->query("UPDATE expenses SET file=? WHERE id = ? ",[$file['id'],$id]);
				}
			}
		}

		$display->success(tr("Expenses added successfully."));
	}
}


if (isset($_POST['edit_expenses']) && can("manage-expenses")) {
	
	$type   = isset($_POST['type'])?$_POST['type']:'';
	$e_date = isset($_POST['e_date'])?$_POST['e_date']:'';
	$amount = isset($_POST['amount'])?$_POST['amount']:'';
	$note   = isset($_POST['note'])?$_POST['note']:'';
	$cash_d   = isset($_POST['cash_d'])?1:0;
	$recurring   = isset($_POST['recurring'])?1:0;
	$branch_id   = isset($_POST['branch_id'])?$_POST['branch_id']:$_SESSION['branch_id'];
	$recurring_type   = isset($_POST['recurring_type'])?$_POST['recurring_type']:'';


	

	// in_array($recurring_type, ['Month',"Week","Day"])?:$recurring=false;
	$id   = isset($_POST['id'])?$_POST['id']:'';

	$v->validate([
		tr("Type")=>[$type,'required'],
		tr("Amount")=>[$amount,'required'],
		tr("Date")=>[$e_date,'required'],
		"ID"=>[$id,'required'],
	]);

	if ($v->passes() && $tk->passes()) {
		$db->query(
			"UPDATE expenses SET e_date=?, type=?, amount=?, note=?,  recurring_type=?, recurring=?, cash_d=? ,updated_by=?,updated_at=? WHERE id = ?",
			[$e_date,$type,$amount,$note, $recurring_type, $recurring, $cash_d,auth()->id,timestamp(),$id]
		);

		$data = $db->row("SELECT * FROM expenses WHERE id = ? ",[$id]);


		$db->query("UPDATE expenses SET  recurring_type=?, recurring=?, cash_d=? WHERE id = ?  ",[$recurring_type, $recurring, $cash_d,$data['expensses_id']]);

		if (isset($_POST['has_file'])) {
			if ($_POST['has_file']=="true") {
				$file = file_save($_FILES['file']);
				if (!$file['status']) {
					$display->error($file['message']);
				}else{
					$db->query("UPDATE expenses SET file=? WHERE id = ? ",[$file['id'],$id]);
				}
			}
		}

		$display->success(tr("Expenses updated successfully."));
	}
}

if (isset($_POST['delete_expenses']) && can("manage-expenses")) {
	
	$id   = isset($_POST['id'])?$_POST['id']:'';

	$v->validate([
		"ID"=>[$id,'required'],
	]);

	if ($v->passes() && $tk->passes()) {
		$db->query(
			"UPDATE expenses SET deleted_01=1, updated_by=?, updated_at=? WHERE id= ? ",
			[auth()->id,timestamp(),$id]
		);

		$display->success(tr("Expenses deleted successfully."));
	}
}


$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':
		$user->authorize("manage-expenses|add-expenses");
		$page_nav=[
			"back"=>$app_url."/expenses",
			"breadcrumb"=>[
				tr("Expenses")=>$app_url."/expenses",
				tr("New")=>$app_url."/expenses",
			],
		];

		$page=[
			"title"=>tr("New expenses"),
			"active"=>"expenses",
		];
		$page_view = "views/new.php";
	break;

	case 'edit':
		$user->authorize("manage-expenses");
		$page_nav=[
			"back"=>$app_url."/expenses",
			"breadcrumb"=>[
				tr("Expenses")=>$app_url."/expenses",
				tr("Edit")=>$app_url."/expenses",
			],
	
		];
		
		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM expenses WHERE id = ? ",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}

		$page=[
			"title"=>tr("Expenses")." #".$data['id'],
			"active"=>"expenses",
		];


		$page_view = "views/edit.php";
	break;
	
	default:
		$user->authorize("manage-expenses|add-expenses");
		$from = date("Y-m-d",strtotime("-1 month"));
		$to   = date("Y-m-d");

		if (isset($_GET['from'])) {
		  $from = date("Y-m-d",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d",strtotime($_GET['to']));
		}

		$page_nav=[
			"reload"=>1,
			"branch"=>1,
			"breadcrumb"=>[
				tr("Expenses")=>$app_url."/expenses",
			],
			"date_filter"=>[
				"from"=>$from,
				"to"=>$to
			]
		];

		$page=[
			"title"=>tr("Expenses")." ".$from."-".$to,
			"active"=>"expenses",
		];

		$list = $db->query("SELECT * FROM expenses WHERE  DATE(e_date)>=date(?) 
AND DATE(e_date)<=date(?) AND ".branch()->query(),[$from,$to]);

		$page_view = "views/index.php";
	break;
}