<?php 
  $edit_expenses_token="";
  if ($user->is_signed) {
    $edit_expenses_token = $tk->generate('edit_expenses');
  }
  
?>



<div class="modal fade" id="edit-expenses-modal" tabindex="-1" role="dialog" aria-labelledby="edit-expenses-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="edit-customer-modal-title"><?= $lang['edit'] ?> - {{ id }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="edit_exp_form" method="post" enctype="multipart/form-data">
      <div class="modal-body">
        <div v-show="error" class="alert alert-danger" role="alert">
          <?= $lang['wents_wrong'] ?>
        </div>
       <div class="form-group">
         <label for=""><?= escap($lang['date']) ?></label>
         <input type="text" class="form-control edit-expenses-modal-date text-center" v-model="e_day" name="e_day">

         <label for=""><?= escap($lang['type']) ?></label>
         <input type="text" class="form-control" v-model="type" id="edit-exp-type-autoc" name="type">

         <label for=""><?= escap($lang['amount']) ?></label>
         <input type="number" min="0" class="form-control text-center" v-model="amount" name="amount">


        <label for=""><?= escap($lang['note']) ?></label>
        <textarea  id="" cols="30" rows="2" class="form-control" v-model="note" name="note" ></textarea>    

        <label for=""><?= $lang['incs'] ?></label>   
        <input type="file" class="form-control" name="file" onchange="$('#edit_exp_file').val('true')">
        

       </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger"  data-dismiss="modal"><?= $lang['cancel'] ?></button>
        <button :disabled="(!validate) ? true : false"   type="submit" class="btn btn-primary"><?= $lang['save'] ?></button>
      </div>


      <input type="text" hidden=""  name="has_file" value="false" id="edit_exp_file">
      <input type="text" hidden=""  name="token_val" v-model="token_val">
      <input type="text" hidden="" :value="token_name" name="token_name" >
      <input type="text" hidden="" value="update" name="func">
      <input type="text" hidden=""  name="id" v-model="id">
    </form>
    </div>
  </div>
</div>

<script>
  const editExpensesModal=new Vue({
    el:"#edit-expenses-modal",
    data:{
      token_val:'<?= $edit_expenses_token['val']; ?>',
      token_name:'<?= $edit_expenses_token['key']; ?>',
      id:0,
      e_day:'<?= date("d-m-Y") ?>',
      type:'',
      amount:'',
      note:' ',
      error:false
    },
    methods:{
      submit:function(event){
        var elem=event.currentTarget
        if (this.validate) {
          $(elem).button('loading')
          $.post('<?= $app_url ?>/expenses/ajax/expenses.php', 
            {
              'func':'update',
              'token_val':this.token_val,
              'token_name':this.token_name,
              'id':this.id,
              'e_day':this.e_day,
              'type':this.type,
              'amount':this.amount,
              'note':this.note,

            }, 
            function(data) {
              console.log(data)
              if (data=="OK") {
                bAlert("<?= escap($lang['wents_success']) ?>","success")
                window.location.reload()
              }else{
                this.error=true
              }

              $(elem).button('reset')
            }
          );
        }
      },
      getExpenses:function(){
        $.post('<?= $app_url ?>/expenses/ajax/expenses.php', 
          {
            func: 'get',
            'id':editExpensesModal.id
          }, 
          function(data) {
            editExpensesModal.e_day     =data.e_date
            editExpensesModal.type     =data.type
            editExpensesModal.amount   =data.amount
            editExpensesModal.note     =data.note


            $("#edit-expenses-modal").modal('show');
          },'json'
        );
      }
     
    },
    computed:{
      validate:function(){
        if (!(this.amount === undefined || this.amount == null ||this.amount == 0 || this.amount.length <= 0 || this.type === undefined || this.type == null ||this.type == 0 || this.type.length <= 0 || this.e_day === undefined || this.e_day == null ||this.e_day == 0 || this.e_day.length <= 0)) {
          return true
        }
      }
    },
    mounted(){
     
    }
  })

  $(document).ready(function() {

    $("#edit_exp_form").submit(function(e) {
            e.preventDefault();    
            var formData = new FormData(this);

            $.ajax({
                url: "<?= $app_url ?>/expenses/ajax/expenses.php",
                type: 'POST',
                data: formData,
                success: function (data) {
     
                  if (data=="OK") {
                    bAlert("<?= escap($lang['wents_success']) ?>","success")
                    window.location.reload()
                  }else{
                    this.error=true
                  }

                  $(elem).button('reset')

                },
                cache: false,
                contentType: false,
                processData: false
            });
        });



    $('.edit-expenses-modal-date').datepicker({
        <?php if ($isRtl) {echo "rtl: true,";} ?>
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,

        }).on('changeDate', function (selected) {
          editExpensesModal.e_day=selected.format('dd-mm-yyyy')
      });




    $("#edit-exp-type-autoc").autocomplete({
      minLength: 0,
      select:function(event, ui){
          console.log(ui.item.label)
          editExpensesModal.type=ui.item.label
        },
      source: function( request, response ) {

        $.post("<?= $app_url ?>/expenses/ajax/expenses.php", {"func":"get_type_list","type":request.term}, function(data, textStatus, xhr) {
          response( data);
        },
        "json");
      },

    }).focus(function () {
          $(this).autocomplete("search");
      });;
  });


</script>
