<?php 
$new_expenses_token="";
if ($user->is_signed) {
  $new_expenses_token = $tk->generate('new_expenses');
}
  set_lang(
[
  "incs",
],
[
  "المرفقات",
],
[

  "Attachments",
]
);
 ?>



<div class="modal fade" id="new-expenses-modal" tabindex="-1" role="dialog" aria-labelledby="new-expenses-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-customer-modal-title"><?= $lang['new_expenses'] ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="new_exp_form" method="post" enctype="multipart/form-data">
      <div class="modal-body">
        <div v-show="error" class="alert alert-danger" role="alert">
          <?= $lang['wents_wrong'] ?>
        </div>
       <div class="form-group">
         <label for=""><?= escap($lang['date']) ?></label>
         <input type="text" class="form-control new-expenses-modal-date text-center" v-model="e_day" name="e_day">

         <label for=""><?= escap($lang['type']) ?></label>
         <input type="text" class="form-control" id="exp-type-autoc"  v-model="type" name="type">

         <label for=""><?= escap($lang['amount']) ?></label>
         <input type="number" min="0" class="form-control text-center" v-model="amount" name="amount">


        <label for=""><?= escap($lang['note']) ?></label>
        <textarea  id="" cols="30" rows="2" class="form-control" v-model="note" name="note"></textarea> 


        <label for=""><?= $lang['incs'] ?></label>   
        <input type="file" class="form-control" name="file" onchange="$('#new_exp_file').val('true')">
        

       </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger"  data-dismiss="modal"><?= $lang['cancel'] ?></button>
        <button :disabled="(!validate) ? true : false"  name="new_exp" type="submit" class="btn btn-primary"><?= $lang['add'] ?></button>
      </div>

      <input type="text" hidden=""  name="has_file" value="false" id="new_exp_file">
      <input type="text" hidden=""  name="token_val" v-model="token_val">
      <input type="text" hidden="" :value="token_name" name="token_name" >
      <input type="text" hidden="" value="new" name="func">
      </form>
    </div>
  </div>
</div>

<script>
  const newExpensesModal=new Vue({
    el:"#new-expenses-modal",
    data:{
      token_val:'<?= $new_expenses_token['val']; ?>',
      token_name:'<?= $new_expenses_token['key']; ?>',
      e_day:'<?= date("d-m-Y") ?>',
      type:'',
      amount:'',
      note:'',
      error:false
    },
    methods:{
      submit:function(event){
        var elem=event.currentTarget
        if (this.validate) {
          $(elem).button('loading')
          $.post('<?= $app_url ?>/expenses/ajax/expenses.php', 
            {
              'func':'new',
              'token_val':this.token_val,
              'token_name':this.token_name,
              'e_day':this.e_day,
              'type':this.type,
              'amount':this.amount,
              'note':this.note,

            }, 
            function(data) {
              console.log(data)
              newExpensesModal.token_val=data.token
              if (data.status=="OK") {

              
                $("#new-expenses-modal").modal("hide")
                notifi('<?= $lang['expenses'] ?>',"<?= escap($lang['wents_success']) ?>","success")

                newExpensesModal.type=''
                newExpensesModal.amount=''
                newExpensesModal.note=''
                // window.location.reload()
              }else{
                this.error=true
              }

              $(elem).button('reset')
            },'json'
          );
        }
      },
     
    },
    computed:{
      validate:function(){
        if (!(this.amount === undefined || this.amount == null ||this.amount == 0 || this.amount.length <= 0 || this.type === undefined || this.type == null ||this.type == 0 || this.type.length <= 0 || this.e_day === undefined || this.e_day == null ||this.e_day == 0 || this.e_day.length <= 0)) {
          return true
        }
      }
    },
    mounted(){
     
    }
  })

  $(document).ready(function() {


    $("#new_exp_form").submit(function(e) {
            e.preventDefault();    
            var formData = new FormData(this);

            $.ajax({
                url: "<?= $app_url ?>/expenses/ajax/expenses.php",
                type: 'POST',
                data: formData,
                success: function (data) {
                  data = JSON.parse(data)
                  if (data.status=="OK") {
                    newExpensesModal.token_val=data.token
              if (data.status=="OK") {

                
                $("#new-expenses-modal").modal("hide")
                notifi('<?= $lang['expenses'] ?>',"<?= escap($lang['wents_success']) ?>","success")

                newExpensesModal.type=''
                newExpensesModal.amount=''
                newExpensesModal.note=''
                // window.location.reload()
              }else{
                this.error=true
              }

              $(elem).button('reset')

                  }else{
                    
                  }
                  neworder.customer=''
                  neworder.phone=''
                  neworder.title=''
                  neworder.odate=''
                  neworder.price=''
                  neworder.paid=''
                  neworder.note=''
                  neworder.files=[]
                },
                cache: false,
                contentType: false,
                processData: false
            });
        });




    $('.new-expenses-modal-date').datepicker({
        <?php if ($isRtl) {echo "rtl: true,";} ?>
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
      }).on('changeDate', function (selected) {
          newExpensesModal.e_day=selected.format('dd-mm-yyyy')
      });






    $("#exp-type-autoc").autocomplete({
      minLength: 0,
      select:function(event, ui){
        console.log(ui.item.label)
        newExpensesModal.type=ui.item.label
      },
      source: function( request, response ) {

        $.post("<?= $app_url ?>/expenses/ajax/expenses.php", {"func":"get_type_list","type":request.term}, function(data, textStatus, xhr) {
          response( data);
        },
        "json");
      },

    }).focus(function () {
          $(this).autocomplete("search");
      });;
  });


</script>

 <script>
  $( function() {

 
    
  } );
  </script>