<div class="modal fade" id="view-expenses-modal" tabindex="-1" role="dialog" aria-labelledby="view-expenses-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered " role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="view-expenses-modal-title"><?= $lang['expenses'] ?> - {{ id }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table class="table table-borederless table-striped border">
          <tbody>
            <tr>
              <th class="text-end"><?= $lang['date'] ?>:</th>
              <td>{{ e_date }}</td>
            </tr>
            <tr>
              <th class="text-end"><?= $lang['type'] ?>:</th>
              <td>{{ type }}</td>
            </tr>
            <tr>
              <th class="text-end"><?= $lang['amount'] ?>(<?= $currency ?>):</th>
              <td>{{ amount }}</td>
            </tr>
            <tr>
              <th class="text-end"><?= $lang['note'] ?>:</th>
              <td>{{ note }}</td>
            </tr>

            <tr v-if="file.length">
              <th class="text-end"><?= $lang['incs'] ?>:</th>
              <td><a :href="'./uploads/'+file" target="_blank" class="btn btn-outline-secondary"><i class="fas fa-paperclip"></i></a></td>
            </tr>
             <tr>
              <th class="text-end"><?= $lang['added_by'] ?>:</th>
              <td>{{ added_by }}</td>
            </tr>
            <tr>
              <th class="text-end"><?= $lang['added_on'] ?>:</th>
              <td>{{ added_on }}</td>
            </tr>
            <tr>
              <th class="text-end"><?= $lang['updated_on'] ?>:</th>
              <td>{{ updated_on }}</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
  const viewExpensesModal=new Vue({
    el:"#view-expenses-modal",
    data:{
      e_date:'',
      id:0,
      type:'',
      amount:0,
      note:'',
      error:false,
      added_on:'',
      added_by:'',
      updated_on:'',
      file:'',
    },
    methods:{

      getExpenses:function(){
        $.post('<?= $app_url ?>/expenses/ajax/expenses.php', 
          {
            func: 'get',
            'id':viewExpensesModal.id
          }, 
          function(data) {
            viewExpensesModal.e_date     =data.e_date
            viewExpensesModal.type     =data.type
            viewExpensesModal.amount   =data.amount
            viewExpensesModal.note     =data.note
            viewExpensesModal.added_on =data.added_on
            viewExpensesModal.added_by =data.added_by
            viewExpensesModal.updated_on =data.updated_on
            viewExpensesModal.file =data.file

            $("#view-expenses-modal").modal('show');
          },'json'
        );
      }
     
    }

  })

</script>
