
		<div class="card">
			<div class="card-header d-flex justify-content-between">
				<h3><?= tr("Expenses") ?></h3>
				<div class="text-end">
					<a href="<?= add_to_url($this_url,"v","new") ?>" class="btn btn-primary rounded-pill"><?= tr("New expenses") ?></a>
				</div>
			</div>
			<table class="table" id="datatable-tabletools">
				<thead>
					<tr>
						<th>#</th>
						<th><?= tr("Created at") ?></th>
            <th><?= tr("Date") ?></th>
            <th><?= tr("Warehouse") ?></th>
            <th><?= tr("Amount") ?></th>
            <th><?= tr("Type") ?></th>
						<th><?= tr("Note") ?></th>
						<th><?= tr("Status") ?></th>
						<th class="text-center"><?= tr("Action") ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($list as $key => $item): ?>
						<tr>
							<td><?= $item['id'] ?></td>
							<td><?= $item['created_at'] ?></td>
							<td><?= $item['e_date']  ?></td>
							<td><?= branch($item['branch_id'])->name() ?></td>
              <td><?= $item['amount'] ?></td>
              <td><?= escap($item['type']) ?></td>
							<td><?= escap($item['note']) ?></td>
							<td><?php if (!$item['deleted_01']): ?>
                <span class="badge badge-success"><?= tr("Active") ?></span>
              <?php else: ?>
                <span class="badge badge-danger"><?= tr("Deleted") ?></span>
              <?php endif ?></td>
							<td class="text-center">
                <?php if (can("manage-expenses")): ?>
                    <a href="<?= add_to_url($this_url,["v","i"],["edit",$item['id']]) ?>" class="btn btn-sm btn-lighr border" title="<?= tr("Edit") ?>"><i class="far fa-edit"></i></a>
                 <button type="button" onclick="$('#item-id').val(<?= $item['id'] ?>)" data-toggle="modal" data-target="#delete-modal"  class="btn btn-sm btn-lighr border" title="<?= tr("Delete") ?>"><i class="far fa-trash-alt"></i></button>
                <?php endif ?>
							
							</td>

						</tr>
					<?php endforeach ?>
				</tbody>
			</table>
		</div>

<form method="post">
<div class="modal" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="delete-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-modalLabel"><?= tr("Are you sure?") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?= tr("This expneses will be deleted.") ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary rounded-pill" data-dismiss="modal"><?= tr("Cancel") ?></button>
        <button class="btn btn-primary rounded-pill" name="delete_expenses"><?= tr("Yes") ?></button>
      </div>
    </div>
  </div>
</div>
<input type="hidden" name="id" value="0" id="item-id">

</form>



<script>
	$(document).ready(function() {

		var table=''
		$(document).ready(function() {
				var $table = $('#datatable-tabletools');

				 table = $table.dataTable({
				 	
        
			    language: {
		              search: '<span></span> _INPUT_',
		              searchPlaceholder: '<?= tr("Search") ?>',
		              lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [25, 100, 500,1000],
			          [25, 100, 500,1000]
			        ],
			        "order": [[ 0, "desc" ]],
		
					"columnDefs": [
					    { "orderable": false, "targets": [1,2,7]},
					 
					],
					// stateSave: true,
			        // processing: true,
			        // serverSide: true,
		
					
					// sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
					dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,
					 buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
		              }
		          },
		          buttons: [
		    
		         

		          ],
		      },

					
				});

			
				


				
			});
	});
</script>