<?php 




if (isset($_POST['new_cake'])) {

	$customer = isset($_POST['customer'])?$_POST['customer']:'';
	$phone= isset($_POST['phone'])?$_POST['phone']:'';
	$type= isset($_POST['type'])?$_POST['type']:'';
	$weight= isset($_POST['weight'])?$_POST['weight']:'';
	$number= isset($_POST['number'])?$_POST['number']:'';
	$text= isset($_POST['text'])?$_POST['text']:'';
	$branch= isset($_POST['branch'])?$_POST['branch']:'';
	$note= isset($_POST['note'])?$_POST['note']:'';

	$ddate= isset($_POST['ddate'])?$_POST['ddate']:'';
	$time_h= isset($_POST['time_h'])?$_POST['time_h']:'';
	$time_i= isset($_POST['time_i'])?$_POST['time_i']:'';
	$time_a= isset($_POST['time_a'])?$_POST['time_a']:'';
	$price= isset($_POST['price'])?$_POST['price']:0;
	$paid= isset($_POST['paid'])?$_POST['paid']:0;
	$method = isset($_POST['method'])?$_POST['method']:'';

	$v->validate([
		"Customer"      =>[$customer,"required"],
		"Phone"         =>[$phone,"required"],
		
		"Delivery Date" =>[$ddate,"required"],
		"Delivery Time H" =>[$time_h,"required"],
		"Delivery Time I" =>[$time_i,"required"],
		"Delivery Time A" =>[$time_a,"required"],
	]);

	if ($v->passes()) {
		$db->query(
			"INSERT INTO cake (customer, phone, type, weight,cake_number, text, branch, note, ddate, price, added_by) VALUES (?,?,?,?,?,?,?,?,?,?,?)",
			[
				$customer,
				$phone,
				$type,
				$weight,
				$number,
				$text,
				$branch,
				$note,
				($ddate. " " . sprintf("%02d", $time_h) . ":" .sprintf("%02d", $time_i)  . "" . $time_a),
				$price,
				auth()->id,
			]
		);
		$id = $db->lastInsertId();


		if (!$db->row("SELECT * FROM customers WHERE phone = ? ",[$phone])) {
			$db->query("INSERT INTO customers(name,phone) VALUES(?,?)",[$customer,$phone]);
		}

		// $files = [];
		// if (isset($_POST['has_file'])) {
		// 	$file = file_save_multi($_FILES['file'],$root . "/uploads/",count($_POST['has_file']));

		// 	if (count($file['files'])>0) {
		// 		for ($i=0; $i < count($_POST['has_file']); $i++) { 
		// 			if (count($file['error'][$i])==0) {
		// 				array_push($files, $file['files'][$i]);
		// 			}
		// 		}
		// 	}
		// }

		// $db->query("UPDATE cake SET files= ? WHERE id = ? ",[json_encode($files), $id ]);


		if (is_numeric($paid) && $paid>0) {

			if ($method=="Points") {
				$points_balance = $db->single("SELECT points FROM customers WHERE phone = ? ",[$phone]);

				if (($points_balance*$point_rate)<$paid) {
					$paid = $points_balance*$point_rate;

					$display->message(tr("Low points balance."));
				}

			}

			$db->query("INSERT INTO payments(form_id,amount,method,created_by) VALUES (?,?,?,?)",[$id,$paid,$method,auth()->id]);

			$db->query("UPDATE cake SET paid  = ? WHERE id = ? ",[$paid,$id]);
		}



		$redirect->to(add_to_url($this_url,["v","i"],["view",$id]));
	}
}




if (isset($_POST['edit_cake'])) {

	$customer = isset($_POST['customer'])?$_POST['customer']:'';
	$phone= isset($_POST['phone'])?$_POST['phone']:'';
	$type= isset($_POST['type'])?$_POST['type']:'';
	$weight= isset($_POST['weight'])?$_POST['weight']:'';
	$number= isset($_POST['number'])?$_POST['number']:'';
	$text= isset($_POST['text'])?$_POST['text']:'';
	$branch= isset($_POST['branch'])?$_POST['branch']:'';
	$note= isset($_POST['note'])?$_POST['note']:'';

	$ddate= isset($_POST['ddate'])?$_POST['ddate']:'';
	$time_h= isset($_POST['time_h'])?$_POST['time_h']:'';
	$time_i= isset($_POST['time_i'])?$_POST['time_i']:'';
	$time_a= isset($_POST['time_a'])?$_POST['time_a']:'';
	$price= isset($_POST['price'])?$_POST['price']:0;
	$paid= isset($_POST['paid'])?$_POST['paid']:0;
	$id= isset($_POST['id'])?$_POST['id']:'';
	$deleted_payment= isset($_POST['deleted_payment'])?$_POST['deleted_payment']:'[]';

	$deleted_payment = is_json($deleted_payment)?$deleted_payment:'[]';
	$deleted_payment = json_decode($deleted_payment);

	$v->validate([
		"Customer"      =>[$customer,"required"],
		"Phone"         =>[$phone,"required"],
		
		"Delivery Date" =>[$ddate,"required"],
		"Delivery Time H" =>[$time_h,"required"],
		"Delivery Time I" =>[$time_i,"required"],
		"Delivery Time A" =>[$time_a,"required"],
		"ID"=>[$id,"required"]
	]);

	if ($v->passes()) {

		$data = $db->row("SELECT * FROM cake WHERE id = ?",[$_POST['id']]);


		$db->query(
			"UPDATE cake SET customer=?, phone=?, type=?, weight=?,cake_number=?, text=?, branch=?, note=?, ddate=?, price=? WHERE id = ?",
			[
				$customer,
				$phone,
				$type,
				$weight,
				$number,
				$text,
				$branch,
				$note,
				($ddate. " " . sprintf("%02d", $time_h) . ":" .sprintf("%02d", $time_i)  . "" . $time_a),
				$price,
			
				$id,
			]
		);

		foreach ($deleted_payment as $key => $payment) {
			$db->query("UPDATE payments SET deleted_01 = 1 WHERE id = ? AND form_id=?",[$payment,$id]);
		}

		$paid = $db->single("SELECT sum(amount) FROM payments WHERE deleted_01=0 AND form_id=?",[$id]);

		$db->query("UPDATE cake SET paid  = ? WHERE id = ? ",[$paid,$id]);




	}
}


if (isset($_POST['status'])) {
	
	$status= isset($_POST['status'])?$_POST['status']:'';
	$id= isset($_POST['id'])?$_POST['id']:'';

	$v->validate([
		"ID"=>[$id,"required"]
	]);

	if ($v->passes()) {
		$db->query("UPDATE cake SET status=? WHERE id =? ",[$status,$id]);
	}
}


if (isset($_POST['delete_cake'])) {
	$id= isset($_POST['id'])?$_POST['id']:'';

	$v->validate([
		"ID"=>[$id,"required"]
	]);

	if ($v->passes()) {
		$db->query("UPDATE cake SET deleted_01=1 WHERE id = ? ", [ $id ] );
		$db->query("UPDATE payments SET deleted_01=1 WHERE form_id = ? ", [ $id ] );

		$redirect->to($app_url . "/from");
	}
}



if (isset($_POST['new_file'])) {
	$id= isset($_POST['id'])?$_POST['id']:'';
	$has_file= isset($_POST['has_file'])?$_POST['has_file']:'';


	$v->validate([
		"ID"=>[$id,"required"]
	]);

	if ($v->passes()) {

		$file = new Classes\File;
		if ($has_file=='true') {
			$file->save($_FILES['file'])->resize([200, 200]);
			if ($file->saved()) {
				$current = $db->single("SELECT files FROM cake WHERE id = ? " , [$id]);
				$current = is_json($current)?$current:"[]";
				$files = json_decode($current,true);
				array_push($files, $file->id);
				$db->query("UPDATE cake SET files= ? WHERE id = ? ",[json_encode($files), $id ]);
			
			}else{
				$display->error($file->errors());
			}
		}


		
	}
}


if (isset($_POST['delete_file'])) {
	$id= isset($_POST['id'])?$_POST['id']:'';
	$file_id= isset($_POST['file_id'])?$_POST['file_id']:'';
	$v->validate([
		"ID"=>[$id,"required"],
		"File"=>[$file_id,"required"]
	]);


	if ($v->passes()) {
		$files = $db->single("SELECT files FROM cake WHERE id = ? ",[$id]);

		$files= json_decode($files,true);

		
		if (($key = array_search($file_id, $files)) !== false) {
		    unset($files[$key]);
		}

		$db->query("UPDATE cake SET files = ? WHERE id = ? ", [ json_encode($files), $id ] );

	}
}



if (isset($_POST['new_payment'])) {


	$id= isset($_POST['id'])?$_POST['id']:'';
	$amount= isset($_POST['amount'])?$_POST['amount']:0;
	$method= isset($_POST['method'])?$_POST['method']:'';


	$v->validate([
		"ID"=>[$id,"required"],
		"amount"=>[$amount,"required"],
	]);


	if ($v->passes()) {
		$db->query(
			"INSERT INTO payments(form_id,amount,method,created_by) VALUES (?,?,?,?)",
			[$id, $amount, $method, auth()->id]
		);

		$paid = $db->single("SELECT sum(amount) FROM payments where form_id=? AND deleted_01=0",[$id]);

		$db->query("UPDATE cake SET paid = ? WHERE id =? ",[$paid,$id]);

	}



}




$types = json_decode($db->single("SELECT types FROM cake_settings LIMIT 1 "),true);




$display->error($v->errors()->all());

$view="index";

if (isset($_GET['v'])) {
	$view=$_GET['v'];
}

switch ($view) {
	case 'view':
		$page_nav=[
			"breadcrumb"=>[
				tr("Form")=>$app_url."/form",
				tr("View")=>$app_url."/dishes",
			],
		];
		if (isset($_GET['i'])) {

			$cake =(object) $db->row("SELECT * FROM cake WHERE id = ?",[$_GET['i']]);
			$payments = $db->query("SELECT * FROM payments WHERE form_id = ? AND deleted_01 = 0 ORDER BY id DESC",[$_GET['i']]);

			

		}else{
			$redirect->to(404);
		}

		$page_view= __DIR__ . "/../view/index.view.php";

	break;

	case 'new':
		$page_nav=[
			"breadcrumb"=>[
				tr("Form")=>$app_url."/form",
				tr("New")=>$app_url."/dishes",
			],
		];
		$page_view= __DIR__ . "/../view/index.new.php";
	break;

	case 'm':
		$page_view= __DIR__ . "/../view/index.new_mobile.php";
	break;

	case 'deleted':
		$cakes = $db->query("SELECT * FROM cake WHERE deleted_01 = 1");
		$page_view= __DIR__ . "/../view/index.deleted.php";
	break;


	
	default:

	$page_nav=[
			"breadcrumb"=>[
				tr("Form")=>$app_url."/form",
			
			],
		];

		$sql = "SELECT *, (price - paid) as unpaid FROM cake WHERE deleted_01=0 ";

		$data=[];

		

		$search = (!isset($_GET['search']))?"":$_GET['search'];



		if (strlen($search)>0) {

			$sql.=" AND (id=? OR customer LIKE ? OR ddate LIKE ? OR type LIKE ? ) ";

			array_push($data, "%".$search."%");
			array_push($data, "%".$search."%");
			array_push($data, "%".$search."%");
			array_push($data, "%".$search."%");
		}


		$order=(!isset($_GET['order']))?"desc":$_GET['order'];
		$order=(!in_array($order, ["asc","desc"]))?"desc":$order;

		$columns=[
			"id",
			"created",
			"price",
			"weight",
			"quantity",
			"delivery",
			"customer",
			"type",
			"unpaid",
			"status",
		];

		$column=(!isset($_GET['column']))?"id":$_GET['column'];
		$column=(!in_array($column, $columns))?"id":$column;

		$col=$column;

		$col=($col=="created")?"added_on":$col;
		$col=($col=="quantity")?"cake_number":$col;
		$col=($col=="delivery")?"ddate":$col;

		$sql.=" ORDER BY ".$col." ".$order;

		
		$show   = (!isset($_GET['show']))?"25":$_GET['show'];

	
		$page = 1; 
		$page_size=$show;
		$total_pages = ceil(count($db->query($sql,$data))/$page_size);
		$total_pages= ($total_pages>0)?$total_pages:1;
		if (isset($_GET['page'])) {
			if (is_numeric($_GET['page']) && $page<=$total_pages ) {
				$page=$_GET['page'];
			}
		}



		$limit_start=($page-1)*$page_size;
		$limit_end=$page_size;

		

		$sql.=" LIMIT $limit_start, $limit_end ";
		// array_push($data, $limit_start);
		// array_push($data, $limit_end);
		// var_dump($sql);
		$cakes = $db->query($sql,$data);



		$show_columns = $columns;



		if (isset($_COOKIE["show_columns"])) {
			$show_columns=json_decode($_COOKIE["show_columns"]);
		}else{
			
			setcookie("show_columns", json_encode($show_columns), time()+30*24*60*60);
		}


		if (isset($_POST['columns'])) {
			$show_columns=$_POST['columns'];
			
			setcookie("show_columns", json_encode($show_columns), time()+30*24*60*60);
		}




		$page_view= __DIR__ . "/../view/index.index.php";
	break;
}
