<div class="row">
	<div class="col">
		<div class="card">
			<div class="card-header">
				<div class="row">
					<div class="col"><h3>Deleted Cake Orders</h3></div>
					<div class="col text-end">
						<a href="<?= add_to_url($this_url,["v"],[""]) ?>" class="btn btn-primary">Cake Orders</a>
					</div>
				</div>
			</div>
			<div class="card-body">
				<table class="table" id="datatable-tabletools">
					<thead>
						<tr>
							<th>#</th>
							<th>Date</th>
							<th>Customer</th>
							<th>Type</th>
							<th>Unpaid</th>
							<th>Status</th>
							<th class="text-center">Action</th>
						</tr>
					</thead>
					<tbody>
            <?php foreach ($cakes as $key => $cake): ?>

              <?php 
              switch ($cake['status']) {
                case 'Completed':
                  $badge="success";
                break;
                case 'Canceled':
                  $badge="danger";
                break;
                case 'Preparing':
                  $badge="info";
                break;
                
                default:
                  $badge="warning";
                  break;
              }

               ?>
              <tr>
                <td><?= $cake['id'] ?></td>
                <td><?= to_dmy($cake['ddate'])." ".to_hia($cake['ddate']) ?></td>
                <td><?= escap($cake['customer']) ?></td>
                <td><?= escap($cake['type']) ?></td>
                <td><?= escap($cake['weight']) ?></td>
                <td class="text-center"><h5 class="badge badge-<?= $badge ?>"><?= escap($cake['status']) ?></h5></td>
                <td class="text-center">
                  <a href="<?= add_to_url($this_url,["v","i"],["view",$cake['id']]) ?>" class="btn btn-outline-secondary btn-sm"><i class="fas fa-search"></i></a>
                </td>
              </tr>
            <?php endforeach ?>
          </tbody>
				</table>
			</div>
		</div>
	</div>
</div>	

<script>
	$(document).ready(function() {
    var $table = $('#datatable-tabletools');
    var table = $table.dataTable({
      "lengthMenu": [
      [25, 100, 500,-1],
      [25, 100, 500,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "columnDefs": [
      { "orderable": false, "targets": [6]}
      ],
      "order": [[ 0, "desc" ]],
      
      sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
      buttons: [ 
            {
              extend:'print',
              text: 'Print',
              exportOptions: {
                      columns: '0,1,2,3,4,5,6'
                  }
            },
            {
              extend:'excel',
              text: 'Exel',
              exportOptions: {
                          columns: '0,1,2,3,4,5,6'
                      }
            },
            {
              extend:'pdf',
              text: 'PDF',
              exportOptions: {
                          columns: '0,1,2,3,4,5,6'
                      }
            },
          ]
    });
    $('<div />').addClass('dt-buttons mb-2 pb-1 ').prependTo('#datatable-tabletools_wrapper');
        $('#datatable-tabletools_filter').addClass('');
        $table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper .dt-buttons' );
        // $('#datatable-tabletools_wrapper').find('.btn-secondary').removeClass('btn-secondary').addClass('btn-default');
      });
</script>