<div class="row" >
	<div class="col">
		<div class="card" id="cake2">
			<div class="card-header">
				<div class="row">
					<div class="col"><h3>New Cake Order</h3></div>
				</div>
			</div>
			<div class="card-body">
				<div class="row justify-content-center">
					<div class="col-lg-6">
						<form action="<?= $this_url ?>" method="post" enctype='multipart/form-data'>
							<label>Customer</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-user-alt"></i></div>
						      </div>
						      <input type="text" class="form-control" value="<?= escap(form_val('customer')) ?>" name="customer" placeholder="Customer name" required="">
						    </div><br>

						    <label>Phone</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-mobile-alt"></i></div>
						      </div>
						      <input type="text" class="form-control" value="<?= escap(form_val('phone')) ?>" name="phone" placeholder="Customer phone" required="">
						    </div><br>


						    <label>Type</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-birthday-cake"></i></div>
						      </div>
						   
						      <select name="type" class="form-control">
						      	<?php foreach ($types as $key => $type): ?>
						      		<option <?= (form_val('type')==$type)?'selected':'' ?> value="<?= escap($type) ?>"><?= escap($type) ?></option>
						      	<?php endforeach ?>
						      	
						      </select>
						    </div><br>

						    <label>Weight (kg)</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-weight-hanging"></i></div>
						      </div>
						      <input type="number" value="<?= escap(form_val('weight')) ?>" step="0.5" class="form-control" name="weight" placeholder="Cake kg" required="">
						    </div><br>

						    <label>Quantity</label>
							<div class="input-group mb-2 mr-sm-2">
								<div class="input-group-prepend">
									<div class="input-group-text"><i class="fas fa-box"></i></div>
								</div>
								<input type="number" value="<?= escap(strlen(form_val('cake_number'))?form_val('cake_number'):1) ?>" step="1" class="form-control" name="number" placeholder="Quantity" required="" min="1" >
							</div><br>

						    <label>Text</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-font"></i></div>
						      </div>
						      <input type="text" class="form-control" name="text" value="<?= escap(form_val('text')) ?>"  placeholder="Text" required="">
						    </div><br>

						    <label>Description</label>
						    <textarea name="note" cols="30" rows="4" class="form-control"><?= nl2br(escap(form_val('text'))) ?></textarea><br>

						    <label>Delivery Branch</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-building"></i></div>
						      </div>
						   
						      <select name="branch" class="form-control">
						      	<?php foreach ($branches as $key => $branch): ?>
						      		<option <?= (form_val('branch')==$branch)?'selected':'' ?> value="<?= escap($branch['address']) ?>"><?= escap($branch['address']) ?></option>
						      	<?php endforeach ?>
						      </select>
						    </div><br>

						    <p>Delivery Time</p>

						     <div class="row justify-content-center">
						    	<div class="col-md-6">
						    		<div 
						    		id="date-picker-cake" 
						    		data-provide="datepicker-inline" 
						    		data-date-format="dd-mm-yyyy" 
						    		data-date-today-highlight="true">
						    			<input type="text" id="date-val" hidden="" name="ddate" required="">
						    		</div>
						    	
						    	</div>
						    </div>

						    <hr>

						    <div class="row justify-content-center align-items-center">
						    	<div class="col-md-2 col-4  text-center">
						    		<p @click="h+=1"><i class="fas fa-chevron-up"></i></p>
						    		<p><input type="text" name="time_h" class="form-control text-center p-0" v-model="h"></p>
						    		<p @click="h-=1"><i class="fas fa-chevron-down"></i></p>
						    	</div>
						    	<div class="col-md-2 col-4 text-center">
						    		<p @click="i+=1"><i class="fas fa-chevron-up"></i></p>
						    		<p><input type="text" name="time_i" class="form-control text-center p-0" v-model="i"></p>
						    		<p @click="i-=1"><i class="fas fa-chevron-down"></i></p>
						    	</div>
						    	<div class="col-md-2 col-4 text-center align-items-">
						    		<p @click="toggle_a"><i class="fas fa-chevron-up"></i></p>
						    		<p  @click="toggle_a">{{ a }}</p>
						    		<input type="text" hidden="" name="time_a" v-model="a">
						    		<p @click="toggle_a"><i class="fas fa-chevron-down"></i></p>
						    	</div>
						    </div><br>

						    <hr>

							<label>Price</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="far fa-money-bill-alt"></i></div>
						      </div>
						      <input type="number" step="0.1" class="form-control" name="price"  placeholder="Price" required="">
						    </div><br>


						    <label>Paid</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-hand-holding-usd"></i></div>
						      </div>
						      <input type="number" step="0.1" value="0" class="form-control" name="paid"  placeholder="Paid" required="">
						    </div><br>

						    <br>
						    <hr>


						    <h6 class="mt-3">Attachments</h6>
							<div class="row">
								<div class="col border bg-light ">
									<div class="row py-3 justify-content-center align-items-center">
										
										<div 
										v-for="(item, index) in files" 
										@click="$('#file-'+index).trigger('click')"
										style="height: 80px;vertical-align: middle;" 
										class="col-lg-3 col-md-4 col-sm-6 col-xs-12 border bg-white m-1 text-center">
											<button @click="files.splice(index,1)" type="button" class="btn btn-danger btn-sm" style="position: absolute;right: 0;top: 0">x</button>
											<h1 class="mt-3" :class="{'text-success':files[index]=='true'}"><i class="far fa-file-alt"></i></h1>
											<input :id="'file-'+index" v-on:change="files[index]='true'" required="" type="file" name="file[]" hidden="">
											<input type="text" name="has_file[]" v-model="files[index]" hidden="">
										</div>
									
										
										<div class="bg-white col-lg-3 col-md-4 col-sm-6 col-xs-12 border text-center m-1" style="height: 80px;vertical-align: middle;cursor: pointer;" @click="add_file"><h1 class="mt-3"><i class="fas fa-plus"></i></h1></div>
									
											
										
									</div>
								</div>
							</div>
							<span hidden="">{{ tt }}</span>

							
							

							
							<br>
						    <button class="btn btn-primary" name="new_cake_m">Submit</button>	


						 </form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>	


<script>
	const cake  = new Vue({
		el:"#cake2",
		data:{
			files:[],
			h:<?= date("h") ?>,
			i:<?= date("i") ?>,
			a:'<?= date("a") ?>',
			tt:0,
		},
		methods:{
			toggle_a(){
				if (this.a=="pm") {
					this.a="am"
					return false
				}

				if (this.a=="am") {
					this.a="pm"
					return false
				}
			},
			add_file(){
				this.files.push('false')
				setTimeout(() => {  $('#file-'+(this.files.length-1)).trigger('click') }, 500);
				
			},

			check_files(){
				let job = this
				// for (var i = 0; i < job.files.length; i++) {
				// 	if (!job.files[i]) {
				// 		job.files.splice(i,1)
				// 		job.check_files()
				// 		return false
				// 	}
				// }

				job.tt++
			}
		},
		watch:{
			h(val,oldVal){
				if (val>12) {
					this.h=1
				}

				if (val<1) {
					this.h=12
				}
			},
			i(val,oldVal){
				if (val>59) {
					this.i=1
				}

				if (val<1) {
					this.i=59
				}
			}
		}
	});


	$(document).ready(function() {
		
	});


window.setInterval(function(){
		  cake.check_files()
		}, 500);

</script>

