<div class="row" id="view_cake">
	<div class="col">
		<div class="card">
			<div class="card-header ">
				<div class="row">
					<div class="col-lg-6">
						<h3>Cake Order #<?= $cake->id ?> <?= escap($cake->customer) ?></h3>
					</div>
					<div class="col-lg-6 text-end">
						<button class="btn btn-info" data-toggle="modal" data-target="#payment-modal" title="New payment">New Payment</button>
						<a href="javascript:window.open('./print/?i=<?= $cake->id ?>','mywindowtitle','width=480,height=720')" class="btn btn-success" title="Print"><i class="fas fa-print"></i></a>
						<?php if ($cake->deleted_01==0): ?>
							<button class="btn btn-danger" title="delete" data-toggle="modal" data-target="#delete-modal"><i class="far fa-trash-alt"></i></button>
						<?php endif ?>
						
					</div>
				</div>
				
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-lg-6 border-right">
						<button class="btn btn-outline-secondary btn-sm" @click="edit=!edit">
							<i v-show="!edit" class="fas fa-pen"></i>
							<i v-show="edit" class="fas fa-search"></i>
						</button>
				
						<table v-show="!edit" class="table table-borderless">
							<tr>
								<th>Customer:</th>
								<td><?= escap($cake->customer) ?></td>
							</tr>
							<tr>
								<th>Phone:</th>
								<td><?= escap($cake->phone) ?></td>
							</tr>
							<tr>
								<th>Type:</th>
								<td><?= escap($cake->type) ?></td>
							</tr>
							<tr>
								<th>Weight (kg):</th>
								<td><?= escap(($cake->weight==0)?"--":$cake->weight) ?></td>
							</tr>
							<tr>
								<th>Quantity:</th>
								<td><?= escap($cake->cake_number) ?></td>
							</tr>
							<tr>
								<th>Text:</th>
								<td><?= nl2br(escap($cake->text)) ?></td>
							</tr>

							<tr>
								<th>Description:</th>
								<td><br><?= nl2br(escap($cake->note)) ?></td>
							</tr>

			

							<tr>
								<th>Price:</th>
								<td><?= amount($cake->price) ?></td>
							</tr>

				

							<tr>
								
								<td colspan="2"><p class="">
									<table class="table border bg-light table-sm text-monospace">
										<?php foreach ($payments as $key => $pay): ?>
											<tr>
												<td><?= amount($pay['amount']) ?></td>
												<td><?= $pay['created_at'] ?></td>
												<td><?= $user->get($pay['created_by'])->name ?></td>
											</tr>
										<?php endforeach ?>
									</table>
									
								</p></td>
							</tr>



							

							<tr>
								<th>Credit:</th>
								<td><?= amount($cake->price- $cake->paid) ?></td>
							</tr>

							<tr class="border-top">
								<th>Delivery Branch:</th>
								<td><?= escap($cake->branch) ?></td>
							</tr>
							<tr>
								<th>Delivery Time:</th>
								<td><?= escap(date("d-m-Y h:ia",strtotime($cake->ddate))) ?></td>
							</tr>
						</table>
						<form action="<?= $this_url ?>" method="post" enctype='multipart/form-data' v-show="edit">
							<label>Customer</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-user-alt"></i></div>
						      </div>
						      <input type="text" class="form-control" value="<?= escap($cake->customer) ?>" name="customer" placeholder="Customer name" required="">
						    </div><br>

						    <label>Phone</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-mobile-alt"></i></div>
						      </div>
						      <input type="text" class="form-control" value="<?= escap($cake->phone) ?>" name="phone" placeholder="Customer phone" required="">
						    </div><br>


						    <label>Type</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-birthday-cake"></i></div>
						      </div>
						   
						      <select name="type" class="form-control">
						      	<?php foreach ($types as $key => $type): ?>
						      		<option <?= ($cake->type==$type)?'selected':'' ?> value="<?= escap($type) ?>"><?= escap($type) ?></option>
						      	<?php endforeach ?>
						      	
						      </select>
						    </div><br>

						    <label>Weight (kg)</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-weight-hanging"></i></div>
						      </div>
						      <input type="number" value="<?= escap($cake->weight) ?>" step="0.25" class="form-control" name="weight" placeholder="Cake kg" required="">
						    </div><br>

						    <label>Quantity</label>
							<div class="input-group mb-2 mr-sm-2">
								<div class="input-group-prepend">
									<div class="input-group-text"><i class="fas fa-box"></i></div>
								</div>
								<input type="number" value="<?= escap($cake->cake_number) ?>" step="1" class="form-control" name="number" placeholder="Quantity" required="" min="1" >
							</div><br>

						    <label>Text</label>
					
						    <textarea name="text" required="" cols="30" rows="4" class="form-control"><?= $cake->text ?></textarea><br>
						    <label>Description</label>
						    <textarea name="note" cols="30" rows="4" class="form-control"><?= $cake->note ?></textarea><br>

						    <label>Delivery Branch</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="fas fa-building"></i></div>
						      </div>

						      <select name="branch" class="form-control">
									<?php foreach ($db->query("SELECT * FROM branches WHERE deleted_01 = 0") as $key => $branch): ?>
									<option <?= (old('branch',$cake->branch)==$branch)?'selected':'' ?> value="<?= escap($branch['name']) ?>"><?= escap($branch['name']) ?></option>
									<?php endforeach ?>
								</select>
						   
						
						    </div><br>

						    <p>Delivery Time</p>

						     <div class="row justify-content-center">
						    	<div class="col-6">
						    		<div> 
				
						    			<input type="date" class="form-control" name="ddate" required="" value="<?= old('ddate',date('Y-m-d',strtotime($cake->ddate))) ?>">
						    		</div>
						    	
						    	</div>
						    </div>

						    <hr>

						    <div class="row justify-content-center align-items-center">
						    	<div class="col-2 text-center">
						    		<p @click="h+=1"><i class="fas fa-chevron-up"></i></p>
						    		<p><input type="text" name="time_h" class="form-control text-center p-0" v-model="h"></p>
						    		<p @click="h-=1"><i class="fas fa-chevron-down"></i></p>
						    	</div>
						    	<div class="col-2 text-center">
						    		<p @click="i+=1"><i class="fas fa-chevron-up"></i></p>
						    		<p><input type="text" name="time_i" class="form-control text-center p-0" v-model="i"></p>
						    		<p @click="i-=1"><i class="fas fa-chevron-down"></i></p>
						    	</div>
						    	<div class="col-2 text-center align-items-">
						    		<p @click="toggle_a"><i class="fas fa-chevron-up"></i></p>
						    		<p  @click="toggle_a">{{ a }}</p>
						    		<input type="text" hidden="" name="time_a" v-model="a">
						    		<p @click="toggle_a"><i class="fas fa-chevron-down"></i></p>
						    	</div>
						    </div><br>

						    <hr>

							<label>Price</label>
						    <div class="input-group mb-2 mr-sm-2">
						      <div class="input-group-prepend">
						        <div class="input-group-text"><i class="far fa-money-bill-alt"></i></div>
						      </div>
						      <input type="number" step="0.1" class="form-control" name="price"  placeholder="Price" required="" value="<?= $cake->price ?>">
						    </div><br>


						    <tr>
								
								<td colspan="2"><p class="">
									<table class="table border bg-light table-xs text-monospace">

										<?php foreach ($payments as $key => $pay): ?>
											<tr id="p-<?= $pay['id'] ?>">
												<td><?= amount($pay['amount']) ?></td>
												<td><?= $pay['created_at'] ?></td>
												<td><?= $user->get($pay['created_by'])->name ?></td>
												<td><button type="button" class="btn btn-sm btn-link" @click="deleted_payment.push(<?= $pay['id'] ?>);$('#p-<?= $pay['id'] ?>').remove()" class="text-danger" title=""><i class="fas fa-times"></i></a></td>
											</tr>
										<?php endforeach ?>
									</table>
									
								</p></td>
							</tr>



						    <br>
						    <hr>


					

							
							

							
							<br>
						    <button class="btn btn-primary" name="edit_cake">Submit</button>	

							<input type="text" name="id" value="<?= $cake->id ?>" hidden>
							<input type="hidden" :value="JSON.stringify(deleted_payment)" name="deleted_payment">
						 </form>
					</div>


					<div class="col-lg-6">
						<form action="<?= $this_url ?>" id="status-form" method=post>
							<label for="">Status</label>
							<select onchange="$('#status-form').submit();" name="status" class="form-control">
								<option <?= ($cake->status=="Active")?'selected':'' ?> value="Active">Active</option>
								<option <?= ($cake->status=="Preparing")?'selected':'' ?> value="Preparing">Preparing</option>
								<option <?= ($cake->status=="Completed")?'selected':'' ?> value="Completed">Completed</option>
								<option <?= ($cake->status=="Canceled")?'selected':'' ?> value="Canceled">Canceled</option>
							</select>
							<input type="text" hidden="" name="id" value="<?= $cake->id ?>">
						</form>
						<hr>
						<h6>Attachments</h6>
						<div class="row py-3 justify-content-center align-items-center bg-light border">

							<?php foreach ((is_json($cake->files)?json_decode($cake->files,true):[]) as $key => $file): ?>
								<div 
								style="height: 80px;vertical-align: middle;" 
								class="col-lg-3 col-md-4 col-sm-6 col-xs-12 border bg-white m-1 text-center">
									<button
									onclick="$('#delete_filename').val('<?= $file ?>');$('#delete_file_form').submit();"
									  type="button" class="btn btn-danger btn-sm" style="position: absolute;right: 0;top: 0">x</button>
									<a target="_blank" href="<?= file_get($file) ?>">
									<h1 class="mt-3"><i class="far fa-file-alt"></i></h1>
									</a>
								</div>
							<?php endforeach ?>
										
										
							<div class="bg-white col-lg-3 col-md-4 col-sm-6 col-xs-12 border text-center m-1" style="height: 80px;vertical-align: middle;cursor: pointer;"  onclick="$('#new_file').trigger('click')"><h1 class="mt-3"><i class="fas fa-plus"></i></h1></div>

							<form action="" method="post" enctype='multipart/form-data' hidden="">
								<input type="text" name="id" hidden="" value="<?= $cake->id ?>">
								<?=
							 file_input([
								"id"=>"new_file",
								"accept"=>"image/*",
								"onchange"=>"$(this).parent('form').submit();",
								"hidden"=>"1",
								]) ?>
							
								
								<input type="text" name="new_file" value="1">
							</form>

							
						
							
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="modal" id="payment-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">New payment</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="<?= $this_url ?>" method="post">
      <div class="modal-body">
        <label for="">Amount</label>
        <input type="number" min="0.1" step="0.001" name="amount" max="<?= $cake->price-$cake->paid ?>" class="form-control">

		<br>
		<label for="">Payment method</label>
		<select name="method" class="form-control">
			<?php foreach ($payment_methods as $key => $method): ?>
				<option value="<?= $method ?>"><?= $method ?></option>
			<?php endforeach ?>
		</select>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button name="new_payment" class="btn btn-primary" >Submit</button>
      </div>
		


		<input type="text" name="id" value="<?= $cake->id ?>" hidden>
      </form>
    </div>
  </div>
</div>



<div class="modal" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Are you sure?</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>This order will be deleted.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-danger" onclick="$('#delete_form').submit();">Ok</button>
      </div>
    </div>
  </div>
</div>

<form action="<?= $this_url ?>" hidden="" method="post" id="delete_file_form">
	<input type="text" name="id" value="<?= $cake->id ?>">
	<input type="text" name="file_id" id="delete_filename">
	<input type="text" name="delete_file" value="1">
</form>

<form action="<?= $this_url ?>" hidden="" method="post" id="delete_form">
	<input type="text" name="id" value="<?= $cake->id ?>">
	<input type="text" name="delete_cake" value="1">
</form>



<script>
	const app = new Vue({
		el:"#view_cake",
		data:{
			edit:false,
			h:'<?= date("h",strtotime($cake->ddate)) ?>',
			i:'<?= date("i",strtotime($cake->ddate)) ?>',
			a:'<?= date("a",strtotime($cake->ddate)) ?>',
			tt:0,
			deleted_payment:[],
			
		},
		methods:{
			toggle_a(){
				if (this.a=="pm") {
					this.a="am"
					return false
				}

				if (this.a=="am") {
					this.a="pm"
					return false
				}
			},
		},


		watch:{
			h(val,oldVal){
				if (val>12) {
					this.h=1
				}

				if (val<1) {
					this.h=12
				}
			},
			i(val,oldVal){
				if (val>59) {
					this.i=1
				}

				if (val<1) {
					this.i=59
				}
			}
		}
	})
</script>