<?php

$pitems_alert = 0;
foreach ($db->query("SELECT * FROM stock_poroducts WHERE deleted_01=0 AND alert>0") as $key => $pitem) {
	foreach (branch()->list() as $key => $branch) {
		$cq = $db->single("SELECT quantity FROM stock_product_quantity WHERE p_id = ? AND branch_id=?",[
			$pitem['id'],
			$branch['id'],
		]);

		if ($cq<$pitem['alert']) {
			$pitems_alert++;
		}
	}
}

// Count pending stock requests
$pending_requests = 0;
try {
	if (can("manage-stock-requests")) {
		$pending_requests = $db->single("SELECT COUNT(*) FROM stock_order_requests WHERE status='pending' AND deleted_01=0");
	} elseif (can("create-stock-requests")) {
		$pending_requests = $db->single("SELECT COUNT(*) FROM stock_order_requests WHERE status='pending' AND deleted_01=0 AND created_by=?", [auth()->id]);
	}
} catch (Exception $e) {
	$pending_requests = 0;
}


function sidebar_active($page_name){
	global $page;
	if (!isset($page['active'])) {
		return 0;
	}
	if ($page_name==$page['active']) {
		return 1;
	}
	else{
		return 0;
	} 
}





	$navList=[
		
	
				[
					"title"=>"Dishes",
					"icon"=>"fas fa-burger-soda",
					"active"=>0,
					"role"=>"manage-dishes|view-dishes",
					"links"=>[
								[
									"title"=>"Dishes",
									"attr"=>'href="'.$app_url.'/dishes/"',
									"type"=>"link",
									"role"=>"manage-dishes|view-dishes",
									"active"=>sidebar_active("dishes"),
									"icon"=>"",
									"badge"=>0
								],

							
							
								
							]
				],

				[
		          "title"=>"Orders",
		          "icon"=>"far fa-receipt",
		          "role"=>"manage-orders|view-orders",
		          "active"=>sidebar_active('orders'),
		          "badge"=>0,
		          "links"=>[
							[
								"title"=>"Orders",
								"attr"=>'href="'.$app_url.'/orders/"',
								"type"=>"link",
								"role"=>"manage-orders|view-orders",
								"active"=>sidebar_active("orders"),
								"icon"=>"",
								"badge"=>0
							],
							
						]	
								
								
		        ],

		        [
		          "title"=>"Payments",
		          "icon"=>"fas fa-money-bill-alt",
		          "role"=>"view-payments",
		          "active"=>sidebar_active('payments'),
		          "badge"=>0,
		          "links"=>[
							
							[
								"title"=>"Payments",
								"attr"=>'href="'.$app_url.'/payments/"',
								"type"=>"link",
								"role"=>"view-payments",
								"active"=>sidebar_active("payments"),
								"icon"=>"",
								"badge"=>0
							]
						]	
								
								
		        ],

				

				[
					"title"=>"Customers",
					"icon"=>"fas fa-users",
					"active"=>0,
					"role"=>"manage-customers|view-customers",
					"links"=>[
								[
									"title"=>"Customers",
									"attr"=>'href="'.$app_url.'/customers/"',
									"type"=>"link",
									"role"=>"manage-customers|view-customers",
									"active"=>sidebar_active("customers"),
									"icon"=>"",
									"badge"=>0
								],
							
								
							]
				],
				[
		          "title"=>"Expenses",
		          "icon"=>"fas fa-money-bill-alt",
		          "role"=>"manage-expenses|add-expenses",
		          "active"=>sidebar_active('expenses'),
		          "badge"=>0,
		          "links"=>[
								["title"=>"Expenses",
								"attr"=>'href="'.$app_url.'/expenses/"',
								"type"=>"link",
								"role"=>"manage-expenses|add-expenses",
								"active"=>sidebar_active("expenses"),
								"icon"=>"",
								"badge"=>0]
							]

							
							
								
		        ],

			[
				"title"=>"Inventory",
				"icon"=>"fas fa-truck",
				"active"=>0,
				"badge"=>$pitems_alert + $pending_requests,
				"role"=>"manage-dishes|manage-purchases|view-purchases|create-stock-requests|manage-stock-requests",
				"links"=>[
							[
								"title"=>"Items",
								"attr"=>'href="'.$app_url.'/inventory/items/"',
								"type"=>"link",
								"role"=>"",
								"active"=>sidebar_active("items"),
								"icon"=>"",
								"badge"=>$pitems_alert
							],
							[
								"title"=>"Requests",
								"attr"=>'href="'.$app_url.'/inventory/requests/"',
								"type"=>"link",
								"role"=>"create-stock-requests|manage-stock-requests",
								"active"=>sidebar_active("requests"),
								"icon"=>"",
								"badge"=>$pending_requests
							],
							[
								"title"=>"Purchases",
								"attr"=>'href="'.$app_url.'/inventory/purchases/"',
								"type"=>"link",
								"role"=>"manage-purchases|view-purchases",
								"active"=>sidebar_active("purchases"),
								"icon"=>"",
								"badge"=>0
							],

							[
								"title"=>"Categories",
								"attr"=>'href="'.$app_url.'/inventory/categories.php"',
								"type"=>"link",
								"role"=>"",
								"active"=>sidebar_active("item_category"),
								"icon"=>"",
								"badge"=>0
							],
							[
								"title"=>"Suppliers",
								"attr"=>'href="'.$app_url.'/inventory/suppliers.php"',
								"type"=>"link",
								"role"=>"manage-suppliers",
								"active"=>sidebar_active("suppliers"),
								"icon"=>"",
								"badge"=>0
							],
							[
								"title"=>"Report",
								"attr"=>'href="'.$app_url.'/inventory/report.php"',
								"type"=>"link",
								"role"=>"manage-purchases|view-purchases",
								"active"=>sidebar_active("inventory-report"),
								"icon"=>"",
								"badge"=>0
							],
						
							
						]
			],


				// [
		        //   "title"=>"Form",
		        //   "icon"=>"far fa-paste",
		        //   "role"=>"manage-dishes",
		        //   "active"=>sidebar_active('form'),
		        //   "badge"=>0,
		        //   "links"=>[
				// 				["title"=>"Form",
				// 				"attr"=>'href="'.$app_url.'/form/"',
				// 				"type"=>"link",
				// 				"role"=>"manage-dishes",
				// 				"active"=>sidebar_active("form"),
				// 				"icon"=>"",
				// 				"badge"=>0]
				// 			]

							
							
								
		        // ],
	
				[
					"title"=>"Types",
					"icon"=>"far fa-bookmark",
					"role"=>"manage-dishes|",
					"active"=>0,
					"badge"=>0,
					"links"=>[
								
		
							
								

								[
									"title"=>"Categories",
									"attr"=>'href="'.$app_url.'/types/categories/"',
									"type"=>"link",
									"role"=>"manage-dishes",
									"active"=>sidebar_active("types-categories"),
									"icon"=>"",
								],

								[
									"title"=>"Taxes",
									"attr"=>'href="'.$app_url.'/types/taxes/"',
									"type"=>"link",
									"role"=>"manage-dishes",
									"active"=>sidebar_active("types-taxes"),
									"icon"=>"",
								],

								[
									"title"=>"Tables",
									"attr"=>'href="'.$app_url.'/types/tables/"',
									"type"=>"link",
									"role"=>"manage-dishes",
									"active"=>sidebar_active("types-tables"),
									"icon"=>"",
								],

								[
									"title"=>"Delivery",
									"attr"=>'href="'.$app_url.'/types/delivery/"',
									"type"=>"link",
									"role"=>"manage-dishes",
									"active"=>sidebar_active("types-delivery"),
									"icon"=>"",
								],

								
						
								
					
							]
				],



			

		
		
				[
		          "title"=>"Reports",
		          "icon"=>"fas fa-chart-bar",
		          "role"=>"view-reports",
		          "active"=>0,
		          "badge"=>0,
		          "links"=>[

		          			[
								"title"=>"Dishes",
								"attr"=>'href="'.$app_url.'/reports/dishes.php"',
								"type"=>"link",
								"role"=>"view-reports",
								"active"=>sidebar_active("report"),
								"icon"=>"",
								"badge"=>0
							],
							
							[
								"title"=>"Summary",
								"attr"=>'href="'.$app_url.'/reports/"',
								"type"=>"link",
								"role"=>"view-reports",
								"active"=>sidebar_active("report"),
								"icon"=>"",
								"badge"=>0
							]
						]

							
							
								
		        ],
		
			
		
	
				[
					"title"=>"Users",
					"icon"=>"fas fa-lock",
					"active"=>0,
					"role"=>"manage-users",
					"links"=>[
								[
									"title"=>"Users",
									"attr"=>'href="'.$app_url.'/users/"',
									"type"=>"link",
									"role"=>"manage-users",
									"active"=>sidebar_active("users"),
									"icon"=>"",
								],
								[
									"title"=>"Roles",
									"attr"=>'href="'.$app_url.'/roles/"',
									"type"=>"link",
									"role"=>"manage-users",
									"active"=>sidebar_active("roles"),
									"icon"=>"",
								],
								
							]
				],

				[
					"title"=>"Settings",
					"icon"=>"fad fa-cogs",
					"active"=>0,
					"role"=>"settings",
					"links"=>[
								[
									"title"=>"Settings",
									"attr"=>'href="'.$app_url.'/settings/"',
									"type"=>"link",
									"role"=>"settings",
									"active"=>sidebar_active("settings"),
									"icon"=>"",
								],
								
							]
				],

			];





