<?php 
	$root="..";
	require($root."/php/init.php");
	$page=[
		'title'=>tr("Categories"),
		"active"=>"item_category"
	];

	$page_nav=[
		"breadcrumb"=>[
			tr("Categories")=>""
		]
	];

	if (isset($_POST['new_inv_cat'])) {
		$v->validate([
			"Category Name"=>[$_POST['name'],'required']
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO stock_categories (name,added_by) VALUES (?,?)",[$_POST['name'],auth()->id]);

		}
	}

	if (isset($_POST['save_inv_cat'])) {
		$v->validate([
			"Category Name"=>[$_POST['name'],'required'],
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("UPDATE stock_categories SET name = ? WHERE id = ?",[$_POST['name'],$_POST['id']]);

		}
	}

	if (isset($_POST['delete_inv_cat'])) {
		$v->validate([
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("UPDATE stock_categories SET deleted_01=1 WHERE id = ?",[$_POST['id']]);

		}
	}

	$display->error($v->errors()->all(),"error");

	$view="index";

	if (isset($_GET['v'])) {
		$view=$_GET['v'];
	}


	if (isset($_GET['i'])) {
		$data = $db->row("SELECT * FROM stock_categories WHERE id = ? ",[$_GET['i']]);
		if (!$data) {
			$redirect->to(404);
		}

	}

	$list = $db->query("SELECT * FROM stock_categories WHERE deleted_01=0");


 ?>
<!DOCTYPE html>
<html <?= $local ?>>
	<?php require($root."/inc/head.php") ?>
	
	<body class=" <?= isset($page['class'])?$page['class']:'' ?> " >
		<?php require($root."/inc/header.php") ?>
			<div class="row">
			<div class="col">
				<?php $display->display_messages() ?>
				<div id="notify"></div>
							
			<div class="row">
				<div class="col-md-8 my-1">
					<div class="card">
						<div class="card-header ">
							<div class="row">
								<div class="col-md-6 ">
									<h5><?= tr("Categories") ?></h5>
								</div>
								<div class="col-md-6 text-end">
									<a href="<?= add_to_url($this_url,["v"],["new"]) ?>" title="New" class="btn btn-primary"><i class="fas fa-plus"></i></a>
								</div>
							</div>
						</div>
						
						
							<table class="table  table-responsive-md table-sm v-align-center mb-0 table-borderless table-striped" id="datatable-tabletools">
								<thead>
									<tr>
										<th><?= tr("Name") ?></th>
										<th class="text-center">!</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach ($list as $key => $cat): ?>
										<tr>
											<td><?= escap($cat['name']) ?></td>
											<td class="text-center">
												<a href="<?= add_to_url($this_url,["v","i"],["view",$cat['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-search"></i></a>
												<a href="<?= add_to_url($this_url,["v","i"],["edit",$cat['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-pen"></i></a>
												<a href="<?= add_to_url($this_url,["v","i"],["delete",$cat['id']]) ?>" class="btn btn-light btn-sm"><i class="far fa-trash-alt"></i></a>
											</td>
										</tr>
									<?php endforeach ?>
									
								</tbody>
							</table>
						
						
					</div>
				</div>

				<div class="col-md-4 my-1">
					<?php if ($view=="new"): ?>
						<form method="post" action="<?= remove_from_url($this_url,["v"]) ?>">
							<div class="card">
								<div class="card-header">
									<h5><?= tr("New") ?></h5>
								</div>
								<div class="card-body">
									<div class="form-group">
										<label for=""><?= tr("Name") ?></label>
										<input type="text" class="form-control" name="name">
									</div>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-primary" type="submit" name="new_inv_cat"><?= tr("Submit") ?></button>
								</div>
							</div>
						</form>
					<?php elseif($view=="view"): ?>
						<div class="card">
							<div class="card-header">
								<h5><?= tr("View") ?></h5>
							</div>
							<div class="card-body">
								<h6><?= tr("Name") ?>:</h6>
								<p><?= escap($data['name']) ?></p>

							</div>
						
						</div>
					<?php elseif($view=="edit"): ?>
						<form method="post" >
							<div class="card">
								<div class="card-header">
									<h5><?= tr("Edit") ?></h5>
								</div>
								<div class="card-body">
									<div class="form-group">
										<label for=""><?= tr("Name") ?></label>
										<input type="text" class="form-control" name="name" value="<?= escap($data['name']) ?>">
									</div>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-primary" type="submit" name="save_inv_cat"><?= tr("Save") ?></button>
								</div>
							</div>

							<input type="text" hidden="" name="id" value="<?= $cat['id'] ?>">
						</form>
					<?php elseif($view=="delete"): ?>
						<form method="post" action="<?= remove_from_url($this_url,["v"]) ?>">
							<div class="card">
								<div class="card-header">
									<h5>Are you sure?</h5>
								</div>
								<div class="card-body">
									<p>This category will be delted.</p>
									<h6>Name:</h6>
									<p><?= escap($data['name']) ?></p>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-danger" type="submit" name="delete_inv_cat">Yes</button>
								</div>
							</div>

							<input type="text" hidden="" name="id" value="<?= $data['id'] ?>">
						</form>
					<?php endif ?>
				</div>
			</div>
			</div>
		</div>
	<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>



	</body>
</html>