<?php 
	$suppliers = $db->query("SELECT * FROM stock_suppliers WHERE deleted_01=0");
	$products = $db->query("SELECT * FROM stock_poroducts WHERE deleted_01=0");

 ?>
 <form  method="post" action="<?= remove_from_url($this_url,["v","i"]) ?>">
<div class="modal " id="new-import-modal" tabindex="-1" role="dialog" aria-labelledby="new-import-modalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-import-modalTitle">New</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row ">
        	<div class="col-md-3 my-1">
        		<label for="">Supplier</label>
        		<select name="sup_id" id="" class="form-control">
        			<?php foreach ($suppliers as $key => $sup): ?>
        				<option value="<?= $sup['id'] ?>"><?= escap($sup['name']) ?></option>
        			<?php endforeach ?>
        		</select>
        	</div>
        	<div class="col-md-3 my-1">
        		<label for="">Created by</label>
        		<input type="text" class="form-control" disabled="" value="<?= escap($user->get->name) ?>">
        	</div>
        	<div class="col-md-3 my-1">
        		<label for="">Refrence</label>
        		<input type="text" name="ref" class="form-control"  >
        	</div>
        	<div class="col-md-3 my-1"><br>
        		<button type="button" class="btn btn-info" @click="add_details">Add details</button>
        	</div>
        </div>
        <hr>
        <div class="row table-responsive"  v-for="(data,index) in details">
        	<table class="table" style="min-width: 790px">
        		<thead>
        			<tr>
        				<th colspan="3">Branch</th>
        				<th>Product details</th>
        			</tr>
        		</thead>
        		<tbody>
        			<tr>
        				<td style="width: 30px;"><button  class="btn btn-danger" @click="remove_detail(index)"><i class="fas fa-times"></i></button></td>
        				<td style="width: 190px">
        					<select required="" <?= (!$user->is_prem("branches"))?'disabled':'' ?> class="form-control" v-model="data.branch">
        						<?php foreach ($branches as $key => $branch): ?>
        							<option value="<?= $branch['id'] ?>"><?= escap($branch['address']) ?></option>
        						<?php endforeach ?>
        					</select>
        				</td>
        				<td style="width: 30px;">
        					<button type="button" class="btn btn-info" @click="add_product(index)"><i class="fas fa-plus"></i></button>
        				</td>
        				<td>
        					<table class="table table-sm border-bottom">
        						<thead>
        							<tr>
        								<td></td>
        								<td>Product</td>
        								<td>Quantity</td>
        								<td>Price</td>
        								<td>Total</td>
        							</tr>
        						</thead>
        						<tbody>
        							<tr v-for="(product,subindex) in data.products">
	        							<td style="max-width: 50px">
	        								<button type="button" class="btn btn-sm btn-danger" @click="remove_product(index,subindex)"><i class="fas fa-times"></i></button>
	        							</td>
	        							<td>
	        								<select  required="" class="form-control" v-model="product.p_id">
	        									<?php foreach ($products as $key => $pro): ?>
	        										<option value="<?= $pro['id'] ?>"><?= escap($pro['name']) ?></option>
	        									<?php endforeach ?>
	        								</select>
	        							</td>
	        							<td style="max-width: 50px">
	        								<input type="number" required="" min="0" v-model="product.qty" class="form-control text-monospace">
	        							</td>
	        							<td style="max-width: 50px">
	        								<input type="number" required="" min="0" step="0.01" class="form-control text-monospace" v-model="product.price">
	        							</td>
	        							<td style="max-width: 50px">
	        								<input type="text" class="form-control text-monospace" disabled="" :value="product.price*product.qty">
	        							</td>
	        						</tr>
	        						<tr>
	        							<td></td>
	        							<td></td>
	        							<td></td>
	        							<td>Total:</td>
	        							<td class="text-center text-monospace">{{ detail_totol(index) }}</td>
	        						</tr>
        						</tbody>
        					
        					</table>
        				</td>
        			</tr>
        		</tbody>							
        	</table>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button  class="btn btn-primary" name="new_import" type="submit">Submit</button>
        <input type="text" :value="JSON.stringify(details)" hidden="" name="import_data">

      </div>
    </div>
  </div>
</div>

 </form>

<script>
	var new_import_modal = new Vue({
		el:"#new-import-modal",
		data:{
			details:[]
		},
		methods:{
			add_details(){
				this.details.push({
					branch:<?= $user->branch_id ?>,
					products:[]
				})
			},
			remove_detail(index){
				this.details.splice(index,1)
			},
			add_product(index){
				this.details[index].products.push({
					qty:1,
					price:0,
                    p_id:0,
					id:0,
				})
			},
			remove_product(index,subindex){
				this.details[index].products.splice(subindex,1)
			},
			detail_totol(index){
				total=0
				for (var i = 0; i < this.details[index].products.length; i++) {
					total+=this.details[index].products[i].price*this.details[index].products[i].qty
				}

				return total
			}

		}

	})
</script>