<?php 
	$root="..";
	require($root."/php/init.php");
	

$page=[
		"title"=>tr("Items"),
		"active"=>"items",
		"class"=>" sidebar-xs "
	];
	$page_nav=[
		"reload"=>1,
		"branch"=>1,
		"breadcrumb"=>[
			tr("Items")=>$app_url."/inventory/items.php",
		],
	
	];

$branch_id = branch()->id();

$from = date("Y-m-d",strtotime("-1 month"));
$to = date("Y-m-d");



if (isset($_GET['from'])) {
  $from = date("Y-m-d",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
  $to = date("Y-m-d",strtotime($_GET['to']));
}

$selected_cat="all";
if (isset($_GET['cat']) && strlen($_GET['cat'])>0) {
	$selected_cat=$_GET['cat'];
}

	if (isset($_POST['new_inv_pro'])) {
		$v->validate([
			"Item Name"=>[$_POST['name'],'required'],
			"Category"=>[$_POST['cat_id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO stock_poroducts (name, cat_id, note, added_by) VALUES (?,?,?,?)",[$_POST['name'], $_POST['cat_id'], $_POST['note'],auth()->id]);

		}
	}

	if (isset($_POST['save_inv_pro']) && $tk->passes()) {
		$v->validate([
			"Item Name"=>[$_POST['name'],'required'],
			"Category"=>[$_POST['cat_id'],'required'],
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() ) {
			$db->query("UPDATE stock_poroducts SET name = ?, cat_id = ?, note = ? WHERE id = ?",[$_POST['name'], $_POST['cat_id'], $_POST['note'],$_POST['id']]);




			if (isset($_POST['qty'])) {

				if (!$db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND  p_id = ?",[$branch_id,$_POST['id']])) {
					$db->query("INSERT stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?) ",[$_POST['id'],$branch_id,0]);
				}

					$current  = $db->single(" SELECT quantity FROM stock_product_quantity WHERE branch_id = ? AND  p_id = ? ",[$branch_id,$_POST['id']]);
					if (is_numeric($_POST['qty']) && $_POST['qty']!=$current) {
						
					
					

					$new = $_POST['qty'];

					$change =  $new - $current;

					$change = ($change<=0)?"".$change:"+".$change;

					$db->query("UPDATE stock_product_quantity SET quantity = ? WHERE branch_id = ? AND  p_id = ?",[$new,$branch_id,$_POST['id']]);

					$db->query(
						"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
						[$_POST['id'] , $branch_id, $change , "Stocking",auth()->id]
					);
				}

			}

		}
	}

	if (isset($_POST['delete_inv_pro'])) {
		$v->validate([
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("UPDATE stock_poroducts SET deleted_01=1 WHERE id = ?",[$_POST['id']]);

		}
	}

	$display->error($v->errors()->all(),"error");

	$view="index";

	if (isset($_GET['v'])) {
		$view=$_GET['v'];
	}

	if (isset($_GET['i'])) {
		$pro = $db->row("SELECT p.*,(SELECT quantity FROM stock_product_quantity WHERE branch_id = ? AND p_id = p.id) AS quantity FROM stock_poroducts p WHERE p.id = ? ",[$branch_id,$_GET['i']]);
		if (!$pro) {
			$redirect->to(404);
		}

	}


	function get_cat_name($cat_id){
		global $db;
		return $db->single("SELECT name FROM stock_categories WHERE id = ? ",[$cat_id]);
	}

	$list_sql = "SELECT p.*,(SELECT quantity FROM stock_product_quantity WHERE branch_id = ? AND p_id = p.id) AS quantity FROM stock_poroducts p WHERE deleted_01=0 ".(is_numeric($selected_cat)?' AND cat_id=$selected_cat':'');
	

	$list = $db->query($list_sql,[$branch_id]);

	if (isset($_GET['i'])) {
		$pro = $db->row("SELECT p.*,(SELECT quantity FROM stock_product_quantity WHERE branch_id = ? AND p_id = p.id) AS quantity FROM stock_poroducts p WHERE p.id = ? ",[$branch_id,$_GET['i']]);

		$imports = $db->query("SELECT s.*, p.name FROM stock_imports_data s LEFT JOIN stock_poroducts p ON p.id = s.product_id  WHERE s.product_id = ? AND  s.deleted_01 = 0 AND s.branch_id = ? AND
			DATE(s.added_on)>=DATE('$from') 
			AND DATE(s.added_on)<=DATE( '$to') ORDER BY s.id ASC  ",[$_GET['i'],$branch_id]);

		$logs = $db->query("SELECT s.*, p.name FROM stock_product_logs s LEFT JOIN stock_poroducts p ON p.id = s.p_id  WHERE s.p_id = ? AND s.branch_id = ? AND
			DATE(s.added_on)>=DATE( '$from') 
			AND DATE(s.added_on)<=DATE( '$to') ORDER BY s.id ASC  ",[$_GET['i'],$branch_id]);
	}


	$cats = $db->query("SELECT * FROM stock_categories WHERE deleted_01=0");
	
	
 ?>
<!DOCTYPE html>
<html <?= $local ?>>
	<?php require($root."/inc/head.php") ?>
	
	<body class=" <?= isset($page['class'])?$page['class']:'' ?> " >
		<?php require($root."/inc/header.php") ?>
			<?php $display->display_messages() ?>
			
			<div class="row">
				<div class="col-md-8 my-1">
					<div class="card">
						<div class="card-header ">
							<div class="row">
								<div class="col-md-6 ">
									<h5>Items</h5>
								</div>
								<div class="col-md-6 text-end">
									
									<a href="<?= add_to_url($this_url,["v"],["new"]) ?>" title="New" class="btn btn-primary"><i class="fas fa-plus"></i></a>
								</div>
							</div>
						</div>
						<div class="">
							<table class="table  table-responsive-md table-sm v-align-center mb-0 table-borderless table-striped" id="datatable-tabletools">
								<thead>
									<tr>
										<th>Name</th>
										<th class="d-flex justify-content-between">Categorey
											<form  class="no_csrf">
												<select  class="form-control form-control-sm" name="cat" onchange="$(this).parent('form').submit();">
													<option <?= ($selected_cat=="all")?'selected':'' ?> value="all">All</option>
													<?php foreach ($cats as $key => $cat): ?>
														<option <?= ($selected_cat==$cat['id'])?'selected':'' ?> value="<?= $cat['id'] ?>"><?= escap($cat['name']) ?></option>
													<?php endforeach ?>
												</select>
											</form>
										</th>
										<th class="text-center">Quantity</th>
										<th class="text-center">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach ($list as $key => $ro): ?>
										<tr>
											<td><?= escap($ro['name']) ?></td>
											<td><?= escap(get_cat_name($ro['cat_id'])) ?></td>
											<td class="text-center"><?= escap($ro['quantity']) ?></td>
											<td class="text-center">
												<a href="<?= add_to_url($this_url,["v","i"],["view",$ro['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-search"></i></a>
												<a href="<?= add_to_url($this_url,["v","i"],["edit",$ro['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-pen"></i></a>
												<a href="<?= add_to_url($this_url,["v","i"],["delete",$ro['id']]) ?>" class="btn btn-light btn-sm"><i class="far fa-trash-alt"></i></a>
											</td>
										</tr>
									<?php endforeach ?>
									
								</tbody>
							</table>
						</div>
						
					</div>
				</div>

				<div class="col-md-4 my-1">
					<?php if ($view=="new"): ?>
						<form method="post" action="<?= remove_from_url($this_url,["v"]) ?>">
							<div class="card">
								<div class="card-header">
									<h5>New Item</h5>
								</div>
								<div class="card-body">
									<div class="form-group">
										<label for="">Name</label>
										<input type="text" class="form-control" name="name">
										<br>
										<label for="">Category</label>
										<select name="cat_id" class="form-control">
											<?php foreach ($cats as $key => $cat): ?>
												<option value="<?= $cat['id'] ?>"><?= escap($cat['name']) ?></option>
											<?php endforeach ?>
										</select>
										<br>
										<label for="">Note</label>
										<textarea name="note" class="form-control" cols="30" rows="3"></textarea>
									</div>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-primary" type="submit" name="new_inv_pro">Submit</button>
								</div>
							</div>
						</form>
					<?php elseif($view=="view"): ?>
						<div class="card">
							<div class="card-header">
								<h5>View Item</h5>
							</div>
							<div class="card-body">
								<h6>Name:</h6>
								<p><?= escap($pro['name']) ?></p>

								<h6>Category:</h6>
								<p><?= escap(get_cat_name($pro['cat_id'])) ?></p>

								<h6>Quantity:</h6>
								<p><?= escap($pro['quantity']) ?></p>

								<h6>Note:</h6>
								<p><?= nl2br(escap($pro['note'])) ?></p>

						
							</div>
						
						</div>
					<?php elseif($view=="edit"): ?>
						<form method="post" >
							<div class="card">
								<div class="card-header">
									<h5>Edit Item</h5>
								</div>
								<div class="card-body">
									<div class="form-group">
										<label for="">Name</label>
										<input type="text" class="form-control" name="name" value="<?= escap($pro['name']) ?>">
										<br>
										<label for="">Category</label>
										<select name="cat_id" class="form-control">
											<?php foreach ($cats as $key => $cat): ?>
												<option <?= ($cat['id']==$pro['cat_id'])?'selected':'' ?> value="<?= $cat['id'] ?>"><?= escap($cat['name']) ?></option>
											<?php endforeach ?>
										</select>
										<br>
										<input type="text" class="form-control" disabled="" value="<?= branch($branch_id)->name() ?>">
										
											<label for="">Quantity</label>
											<input type="text" class="form-control" name="qty" value="<?= $pro['quantity'] ?>">
											<br>
									
										
										<label for="">Note</label>
										<textarea name="note" class="form-control" cols="30" rows="3"><?= escap($pro['note']) ?></textarea>
									</div>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-primary" type="submit" name="save_inv_pro">Save</button>
								</div>
							</div>

							<input type="text" hidden="" name="id" value="<?= $pro['id'] ?>">
						</form>
					<?php elseif($view=="delete"): ?>
						<form method="post" action="<?= remove_from_url($this_url,["v"]) ?>">
							<div class="card">
								<div class="card-header">
									<h5>Are you sure?</h5>
								</div>
								<div class="card-body">
									<p>This Item will be deleted.</p>
									<h6>Name:</h6>
									<p><?= escap($pro['name']) ?></p>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-danger" type="submit" name="delete_inv_pro">Yes</button>
								</div>
							</div>

							<input type="text" hidden="" name="id" value="<?= $pro['id'] ?>">
						</form>
					<?php endif ?>
				</div>
			</div>
			<?php if ($view=="view" || $view=="edit"): ?>
				<br>
			<h5>History</h5>
			
			<div class="row ">

				<div class="col-md-6   p-3">
					 
					<table class="table table-sm" id="datatable-tabletools2">
						<thead>
							<tr>
								<th>#</th>
								<th>Order ID</th>
								<th>Quantity</th>
								<th>Unit price</th>
								<th>Created at</th>
								<th>Created by</th>
							</tr>
						</thead>
						<tbody>
							<?php $n=0; foreach ($imports as $key => $ro): ?>
								<tr>
									<td><?= ++$n ?></td>
									<td><?= $ro['import_id'] ?></td>
									<td><?= $ro['qty'] ?></td>
									<td><?= amount($ro['unit_price']) ?></td>
									<td><?= $ro['added_on'] ?></td>
									<td><?= escap($user->get($ro['added_by'])->name) ?></td>
								</tr>
							<?php endforeach ?>
						</tbody>
					</table>
				</div>

				<div class="col-md-6 bg-light  p-3">
					 
					<table class="table table-sm" id="datatable-tabletools3">
						<thead>
							<tr>
	
								<th>#</th>
								<th>Change</th>
								<th>Action</th>
								<th>Created at</th>
								<th>Created by</th>
							</tr>
						</thead>
						<tbody>
							<?php $n=0; foreach ($logs as $key => $ro): ?>
								<tr>
									
									<td><?= ++$n ?></td>
									<td><?= $ro['qty_change'] ?></td>
									<td><?= $ro['type'] ?></td>
					
									<td><?= $ro['added_on'] ?></td>
									<td><?= escap($user->get($ro['added_by'])->name) ?></td>
								</tr>
							<?php endforeach ?>
						</tbody>
					</table>
				</div>
			</div>
			<?php endif ?>
			
	<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>


<script>
	  $(document).ready(function() {
    var $table = $('#datatable-tabletools');
    var table = $table.dataTable({
      "lengthMenu": [
      [25, 100, 500,-1],
      [25, 100, 500,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "columnDefs": [
      { "orderable": false, "targets": [1]}
      ],
 

      
      sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
   
    });
    $('<div />').addClass('dt-buttons mb-2 pb-1 ').prependTo('#datatable-tabletools_wrapper');
        $('#datatable-tabletools_filter').addClass('');
        $table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper .dt-buttons' );

         var $table2 = $('#datatable-tabletools2');
    var table2 = $table2.dataTable({
      "lengthMenu": [
      [10, 25, 100,-1],
      [10, 25, 100,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "order": [[ 0, "desc" ]],
    
 

      
      sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
   
    });
    $('<div />').addClass('dt-buttons mb-2 pb-1 ').prependTo('#datatable-tabletools_wrapper');
        $('#datatable-tabletools_filter').addClass('');
        $table2.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper .dt-buttons' );

             var $table3 = $('#datatable-tabletools3');
    var table3 = $table3.dataTable({
      "lengthMenu": [
      [10, 25, 100,-1],
      [10, 25, 100,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "order": [[ 0, "desc" ]],
    
 

     
   
    });
    $('<div />').addClass('dt-buttons mb-2 pb-1 ').prependTo('#datatable-tabletools_wrapper');
        $('#datatable-tabletools_filter').addClass('');
        $table3.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper .dt-buttons' );
     
      });


</script>

	</body>
</html>