<?php 

$branch_id = branch()->id();
function get_cat_name($cat_id){
		global $db;
		return $db->single("SELECT name FROM stock_categories WHERE id = ? ",[$cat_id]);
	}

$v = new Classes\Validator;

if (isset($_POST['new_item']) && $v->passes()) {
	
	$name        =isset($_POST['name'])?$_POST['name']:"";
	$cat_id        =isset($_POST['cat_id'])?$_POST['cat_id']:"";
	$note        =isset($_POST['note'])?$_POST['note']:"";
	$alert        =isset($_POST['alert'])?$_POST['alert']:0;

	$v->validate([
			"Item Name"=>[$name ,'required'],
			"Category"=>[$cat_id,'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO stock_poroducts (name, cat_id, note,alert, added_by) VALUES (?,?,?,?,?)",[$name , $cat_id , $note,$alert,auth()->id]);

		}
}

if (isset($_POST['save_item']) && $v->passes()) {

	$name        =isset($_POST['name'])?$_POST['name']:"";
	$cat_id        =isset($_POST['cat_id'])?$_POST['cat_id']:"";
	$note        =isset($_POST['note'])?$_POST['note']:"";
	$id        =isset($_POST['id'])?$_POST['id']:"";
	$qty        =isset($_POST['qty'])?$_POST['qty']:0;
	$alert        =isset($_POST['alert'])?$_POST['alert']:0;
	
	$v->validate([
			"Item Name"=>[$name,'required'],
			"Category"=>[$cat_id,'required'],
			"ID"=>[$id,'required'],
		]);

		if ($v->passes() ) {
			$db->query("UPDATE stock_poroducts SET name = ?, cat_id = ?,alert=?, note = ? WHERE id = ?",[$name, $cat_id,$alert, $note,$id]);




			if ($qty>0) {

				if (!$db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND  p_id = ?",[$branch_id,$id])) {
					$db->query("INSERT stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?) ",[$id,$branch_id,0]);
				}

					$current  = $db->single(" SELECT quantity FROM stock_product_quantity WHERE branch_id = ? AND  p_id = ? ",[$branch_id,$id]);
					if (is_numeric($qty) && $qty!=$current) {
						
					
					

					$new = $qty;

					$change =  $new - $current;

					$change = ($change<=0)?"".$change:"+".$change;

					$db->query("UPDATE stock_product_quantity SET quantity = ? WHERE branch_id = ? AND  p_id = ?",[$new,$branch_id,$id]);

					$db->query(
						"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
						[$id , $branch_id, $change , "Stocking",auth()->id]
					);
				}

			}

		}
}


if (isset($_POST['delete_item']) && $v->passes() && can("manage-purchases")) {
	$id=isset($_POST['id'])?$_POST['id']:"";



	$v->validate([
		"ID"=>[$id,"required|number"],
	]);

	if ($tk->passes() ) {

		$db->query("UPDATE  stock_poroducts SET deleted_01=1 WHERE id= ?",[$id]);
		
		$display->success(tr("Item deleted successfully."));

		$redirect->to($app_url."/inventory/items");
		
	}
}



$selected_cat="all";
if (isset($_GET['cat']) && strlen($_GET['cat'])>0) {
	$selected_cat=$_GET['cat'];
}




$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':
		$page_nav=[
			"back"=>$app_url."/inventory/items/",
			"breadcrumb"=>[
				tr("Taxes")=>$app_url."/inventory/items/",
				tr("New")=>"",
			],
		];
		$page_view = "views/new.php";
	break;





	case 'view':
	$from = date("Y-m-d",strtotime("-1 month"));
		$to   = date("Y-m-d");



		if (isset($_GET['from'])) {
		  $from = date("Y-m-d",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d",strtotime($_GET['to']));
		}
		$page_nav=[
			"back"=>$app_url."/inventory/items/",
			"breadcrumb"=>[
				tr("Items")=>$app_url."/inventory/items/",
				tr("View")=>"",
			],
			"date_filter"=>[
				"from"=>$from,
				"to"=>$to
			]
		];

		$page['class']=" sidebar-xs";
		$page['branch']=1;


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM stock_poroducts WHERE id = ? ",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}


		$pro = $db->row("SELECT p.*,(SELECT quantity FROM stock_product_quantity WHERE branch_id = ? AND p_id = p.id) AS quantity FROM stock_poroducts p WHERE p.id = ? ",[$branch_id,$_GET['i']]);

		$imports = $db->query("SELECT s.*, p.name FROM stock_imports_data s LEFT JOIN stock_poroducts p ON p.id = s.product_id  WHERE s.product_id = ? AND  s.deleted_01 = 0 AND s.branch_id = ? AND
			DATE(s.created_at)>=DATE('$from') 
			AND DATE(s.created_at)<=DATE( '$to') ORDER BY s.id ASC  ",[$_GET['i'],$branch_id]);

		$logs = $db->query("SELECT s.*, p.name FROM stock_product_logs s LEFT JOIN stock_poroducts p ON p.id = s.p_id  WHERE s.p_id = ? AND s.branch_id = ? AND
			DATE(s.added_on)>=DATE( '$from') 
			AND DATE(s.added_on)<=DATE( '$to') ORDER BY s.id ASC  ",[$_GET['i'],$branch_id]);


		$page_view = "views/view.php";
	break;
	
	default:
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Items")=>$app_url."/inventory/items/",
			],
		];

		$list = $db->query("SELECT p.*,(SELECT sum(quantity) FROM stock_product_quantity WHERE (".branch()->query()	.") AND p_id = p.id) AS quantity FROM stock_poroducts p WHERE deleted_01=0 ".(is_numeric($selected_cat)?' AND cat_id=$selected_cat':''));
			// var_dump(branch()->id())
		$page_view = "views/index.php";
	break;
}