

<div class="card">
	<div class="card-header ">
		<div class="row">
			<div class="col-md-6 ">
				<h5><?= tr("Items") ?></h5>
			</div>
			<div class="col-md-6 text-end">
				
				<a href="<?= add_to_url($this_url,["v"],["new"]) ?>" title="New" class="btn btn-primary"><i class="fas fa-plus"></i></a>
			</div>
		</div>
	</div>

	<div class="">
		<table class="table  table-responsive-md table-sm v-align-center mb-0 table-borderless table-striped" id="datatable-tabletools">
			<thead>
				<tr>
					<th><?= tr("Name") ?></th>
					<th class="d-flex "><?= tr("Category") ?>
						<form  class="no_csrf">
							<select  class="form-control form-control-sm" name="cat" onchange="$(this).parent('form').submit();">
								<option <?= ($selected_cat=="all")?'selected':'' ?> value="all">All</option>
								<?php foreach ($db->query("SELECT * FROM stock_categories WHERE deleted_01 = 0") as $key => $cat): ?>
								<option <?= ($selected_cat==$cat['id'])?'selected':'' ?> value="<?= $cat['id'] ?>"><?= escap($cat['name']) ?></option>
								<?php endforeach ?>
							</select>
						</form>
					</th>
					<th class="text-center"><?= tr("Quantity") ?></th>
					<th class="text-center"><?= tr("Cost") ?></th>
					<th class="text-center">!</th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($list as $key => $ro): ?>
				<tr>
					<td><?= escap($ro['name']) ?></td>
					<td><?= escap(get_cat_name($ro['cat_id'])) ?></td>
					<td class="text-center">
						<?php if (float($ro['quantity'],0) < $ro['alert']): ?>
							<i class="fas fa-exclamation text-danger mx-1"></i>
						<?php endif ?>
						<?= float($ro['quantity'],0) ?></td>
						<td><?= float($ro['cost'],3) ?></td>
					<td class="text-center">
						<a href="<?= add_to_url($this_url,["v","i"],["view",$ro['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-search"></i></a>
		
					</td>
				</tr>
				<?php endforeach ?>
				
			</tbody>
		</table>
	</div>
	
</div>

<script>
	  $(document).ready(function() {
    var $table = $('#datatable-tabletools');
    var table = $table.dataTable({
      "lengthMenu": [
      [25, 100, 500,-1],
      [25, 100, 500,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "columnDefs": [
      { "orderable": false, "targets": [4]}
      ],
 

dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,

					  buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
		              }
		          },
		          buttons: [
		    
		         

		          ],
		      },
   
    });






      });


</script>