<?php 
	$root="..";
	require($root."/php/init.php");
	$page=['title'=>$conf->get("App.name")];


$branch_id = $user->branch_id;
if (isset($_GET['branch']) && is_ruled('branches') ) {

    $branch_id = $_GET['branch']; 
}


$from = date("d-m-Y",strtotime("-1 month"));
$to = date("d-m-Y");



if (isset($_GET['from'])) {
  $from = date("d-m-Y",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
  $to = date("d-m-Y",strtotime($_GET['to']));
}

	if (isset($_POST['new_import'])) {
		$v->validate([
			"Refrence"=>[$_POST['ref'],'required'],
			"Supplier"=>[$_POST['sup_id'],'required'],
			"Data"=>[$_POST['import_data'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO stock_imports(ref, sup_id, added_by) VALUES (?,?,?)",[$_POST['ref'],$_POST['sup_id'],$user->id]);

			$id = $db->lastInsertId();
			$data = json_decode($_POST['import_data']);
			foreach ($data as $key => $detail) {
				foreach ($detail->products as $key => $pr) {
					$db->query(
						"INSERT INTO stock_imports_data(import_id, product_id, added_by, branch_id, qty, unit_price) VALUES (?,?,?,?,?,?)",
						[
							$id,
							$pr->p_id,
							$user->id,
							$detail->branch,
							$pr->qty,
							$pr->price,
						]
					);


					$status = $db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND p_id = ?",[$detail->branch,$pr->p_id]);

					if (!$status) {
						$db->query("INSERT INTO stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?)",[$pr->p_id,$detail->branch,$pr->qty]);
					}else{
						$db->query("UPDATE stock_product_quantity SET quantity = quantity+? WHERE p_id = ? AND branch_id = ?",[$pr->qty,$pr->p_id,$detail->branch]);
					}

					$change = ($pr->qty>=0)?"+".$pr->qty:"-".$pr->qty;

					$db->query(
						"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
						[$pr->p_id , $detail->branch, $change , "New import order",$user->id]
					);

				}
			}
		}
	}

	if (isset($_POST['save_import'])) {
		$v->validate([
			"Refrence"=>[$_POST['ref'],'required'],
			"Supplier"=>[$_POST['sup_id'],'required'],
			"Data"=>[$_POST['import_data'],'required'],
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$import=$db->row("SELECT * FROM stock_imports WHERE id = ? ",[$_POST['id']]);

			

			if ($import) {

				$db->query("UPDATE stock_imports SET ref=?, sup_id=? WHERE id = ?  ",[$_POST['ref'],$_POST['sup_id'],$import['id']]);

				$import_data = $db->query("SELECT * FROM stock_imports_data WHERE import_id = ? AND deleted_01 = 0",[$import['id']]);

				$db->query("UPDATE stock_imports_data SET deleted_01 = 1  WHERE import_id = ?",[$import['id']]);
				$id = $_POST['id'];
				$data = json_decode($_POST['import_data']);
				foreach ($data as $key => $detail) {
					foreach ($detail->products as $key => $pr) {
						if ($pr->id==0) {
							$db->query(
								"INSERT INTO stock_imports_data(import_id, product_id, added_by, branch_id, qty, unit_price) VALUES (?,?,?,?,?,?)",
								[
									$id,
									$pr->p_id,
									$user->id,
									$detail->branch,
									$pr->qty,
									$pr->price,
								]
							);

							$status = $db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND p_id = ?",[$detail->branch,$pr->p_id]);

							if (!$status) {
								$db->query("INSERT INTO stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?)",[$pr->p_id,$detail->branch,$pr->qty]);
							}else{
								$db->query("UPDATE stock_product_quantity SET quantity = quantity+? WHERE p_id = ? AND branch_id = ?",[$pr->qty,$pr->p_id,$detail->branch]);
							}

							$change = ($pr->qty>=0)?"+".$pr->qty:"-".$pr->qty;

							$db->query(
								"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
								[$pr->p_id , $detail->branch, $change , "Edit import order",$user->id]
							);
						}else{
							
							$import_row=$db->row("SELECT * FROM stock_imports_data WHERE id = ? ",[$pr->id]);
							$product_row=$db->row("SELECT * FROM stock_product_quantity WHERE p_id = ? AND branch_id=?",[$pr->p_id,$detail->branch]);
							$db->query("UPDATE stock_imports_data SET product_id=?, added_by=?, qty=?, unit_price=?, deleted_01 = 0  WHERE id = ?",[$pr->p_id,$user->id,$pr->qty,$pr->price,$pr->id]);

							$oldQuantity =$import_row['qty'];
							$remain      =$product_row['quantity'];

							$used        =$oldQuantity-$remain;
							$newRemain   =$pr->qty-$used;

							$qchange=$pr->qty - $import_row['qty'];

							$db->query("UPDATE stock_product_quantity SET quantity = quantity-? WHERE p_id = ? AND branch_id = ? ",[$newRemain,$pr->p_id,$detail->branch]);

							$change = ($qchange>=0)?"-".$qchange:"+".$qchange;

							$db->query(
								"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
								[$pr->p_id , $detail->branch, $change , "Edit import order",$user->id]
							);
						}

						$deleted_import_data = $db->query("SELECT * FROM stock_imports_data WHERE import_id = ? AND deleted_01 = 1",[$import['id']]);

						foreach ($deleted_import_data as $key => $ro) {
								$db->query("UPDATE stock_product_quantity SET quantity = quantity-? WHERE p_id = ? AND branch_id = ? ",[$ro['qty'],$ro['product_id'],$ro['branch_id']]);

								$change = ($ro['qty']>=0)?"-".$ro['qty']:"+".$ro['qty'];

								$db->query(
									"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
									[$ro['product_id'] , $ro['branch_id'], $change , "Edit import order",$user->id]
								);
						}

					}

				}
			}

		}
	}

	if (isset($_POST['delete_import'])) {
		$v->validate([
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {

			$import=$db->row("SELECT * FROM stock_imports WHERE id = ? ",[$_POST['id']]);

			$db->query("UPDATE stock_imports SET deleted_01 = 1 WHERE id = ?",[$_POST['id']]);

			if ($import) {

				$import_data = $db->query("SELECT * FROM stock_imports_data WHERE import_id = ? AND deleted_01 = 0",[$import['id']]);

				$db->query("UPDATE stock_imports_data SET deleted_01 = 1  WHERE import_id = ?",[$import['id']]);

				foreach ($import_data as $key => $row) {

					$db->query("UPDATE stock_product_quantity SET quantity = quantity-? WHERE p_id = ? AND branch_id = ? ",[$row['qty'],$row['product_id'],$row['branch_id']]);

					$change = ($row['qty']>=0)?"-".$row['qty']:"+".$row['qty'];

					$db->query(
						"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
						[$row['product_id'] , $row['branch_id'], $change , "Delete import order",$user->id]
					);

				}
			}

		}
	}

	$display->error($v->errors()->all(),"error");

	$view="index";

	if (isset($_GET['v'])) {
		$view=$_GET['v'];
	}

	if (isset($_GET['i'])) {
		$import = $db->row("SELECT * FROM stock_imports WHERE id = ? ",[$_GET['i']]);
		if (!$import) {
			$redirect->to(404);
		}

		$import_data = $db->query("SELECT * FROM stock_imports_data WHERE import_id = ? AND deleted_01=0 ORDER BY branch_id",[$_GET['i']]);


		$data_array=[];
		$index=-1;
		for ($i=0; $i < count($import_data); $i++) { 
			$prev  =($i>0)?$import_data[$i-1]:[];
			$ro    =$import_data[$i];
			
			$branch=$ro['branch_id'];
			
			if ($index >= 0 && isset($prev['branch_id']) && $ro['branch_id'] == $prev['branch_id']) {

				array_push($data_array[$index]['products'], [
					"qty"=>$ro['qty'],
					"p_id"=>$ro['product_id'],
					"price"=>$ro['unit_price'],
					"id"=>$ro['id'],
				]);
			}else{
				 array_push($data_array, [
					"branch"=>$branch,
					"products"=>[
						[
							"qty"=>$ro['qty'],
							"p_id"=>$ro['product_id'],
							"price"=>$ro['unit_price'],
							"id"=>$ro['id'],
						]
					]
				]);
				$index+=1;
			}
			
		}

		
			
		

	}





$sql = "SELECT * FROM stock_imports 
WHERE deleted_01=0 
AND DATE(STR_TO_DATE(added_on, '%Y-%m-%d %H:%i:%s' ))>=DATE( STR_TO_DATE('$from', '%d-%m-%Y' )) 
AND DATE(STR_TO_DATE(added_on, '%Y-%m-%d %H:%i:%s' ))<=DATE( STR_TO_DATE('$to', '%d-%m-%Y' )) ORDER BY id DESC";

$orders= $db->query($sql);


if (isset($_GET[$conf->get("csrf.session")])) {
  $redirect->to(remove_from_url($this_url,[$conf->get("csrf.session")]));
}

 ?>
<!DOCTYPE html>
<html lang="en">
	<?php require($root . "/inc/head.inc.php") ?>
	<body>
		<?php require($root . "/inc/topbar.inc.php") ?>
<div class="container-fluid">
	<div class="row">
		<?php require($root . "/inc/sidelist.inc.php") ?>
		<main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4" >
			<!-- content here -->
			<?php $display->display_messages() ?>
			<h4 >Inventory Orders Management</h4> <br>
			<div class="row">
				<div class="col-md-12 my-1">
					<div class="card">
						<div class="card-header ">
							<div class="row">
								<div class="col-md-6 ">
									<h5>Orders List</h5>
								</div>
								<div class="col-md-6 text-end">
									<?php if (is_ruled('branches')): ?>
						          <button type="button" class="btn btn-secondary dropdown-toggle" id="dropdownMenuOffset-branches" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" data-offset="10,20">
						              Branch [
						                <?php if (isset($_GET['branch']) &&  is_ruled('branches')): ?>
						                  <?php if ($_GET['branch']!="all"): ?>
						                    <?= escap($user->get_branch($_GET['branch'])['address']) ?>
						                  <?php else: ?>
						                    All
						                  <?php endif ?>

						                <?php else: ?>
						                  <?= escap($user->get_branch($branch_id)['address']) ?>
						                <?php endif ?>
						              ]
						            </button>
						            <div class="dropdown-menu" aria-labelledby="dropdownMenuOffset-branches">
						              <a class="dropdown-item" href="<?= add_to_url($this_url,['branch'],["all"]) ?>">All</a>
						              <?php foreach ($branches as $key => $branch): ?>
						                <a class="dropdown-item" href="<?= add_to_url($this_url,['branch'],[$branch['id']]) ?>"><?= escap($branch['address']) ?></a>
						              <?php endforeach ?>
						            </div>
						        <?php endif ?>
						        <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#filter-modal">
						          <span><?= escap($from) ?></span> - 
						          <span><?= escap($to) ?></span>
						        </button>
									<a href="#" title="New" data-toggle="modal" data-target="#new-import-modal" class="btn btn-primary"><i class="fas fa-plus"></i></a>
								</div>
							</div>
						</div>
						<div class="card-body">
							<table class="table table-sm table-responsive-md v-align-center mb-0 table-borderless table-striped" id="datatable-tabletools">
								<thead>
									<tr>
										<th>ID</th>
										<th>Refrance</th>
							
										<th>Create date</th>
										<th>Supplier name</th>
										<th class="text-center">Totol price</th>
										<th class="text-center">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach ($orders as $key => $order): ?>
										<?php 
											if ($branch_id!=="all") {
												$check = $db->single("SELECT count(*) FROM stock_imports_data WHERE import_id = ? AND deleted_01 = 0 AND branch_id = ? ",[$order['id'], $branch_id]);
											}else{
												$check=$db->single("SELECT count(*) FROM stock_imports_data WHERE import_id = ? AND deleted_01 = 0  ",[$order['id']]);
											}
										
										
										 ?>

										 <?php if ($check): ?>
										 	<tr>
												<td><?= escap($order['id']) ?></td>
												<td><?= escap($order['ref']) ?></td>
												<td><?= escap($order['added_on']) ?></td>
												<td><?= escap($db->single("SELECT name FROM stock_suppliers WHERE id = ?",[$order['sup_id']])) ?></td>
												<td class="text-center text-monospace"><?= amount($db->single("SELECT SUM(unit_price*qty) FROM stock_imports_data WHERE import_id=? AND deleted_01=0",[$order['id']])) ?></td>
												<td class="text-center">
													<a href="<?= add_to_url($this_url,["v","i"],["view",$order['id']]) ?>" class="btn btn-outline-secondary btn-sm"><i class="fas fa-search"></i></a>
													<a href="<?= add_to_url($this_url,["v","i"],["edit",$order['id']]) ?>" class="btn btn-outline-secondary btn-sm" ><i class="fas fa-pen"></i></a>
													<a href="#" onclick="$('#delete_order_id').val(<?= $order['id'] ?>)" data-toggle="modal" data-target="#delete-modal" class="btn btn-outline-secondary btn-sm"><i class="far fa-trash-alt"></i></a>
												</td>
											</tr>
										 <?php endif ?>
										
									<?php endforeach ?>
									
								</tbody>
							</table>
						</div>
						
					</div>
				</div>

			</div>
		</main>
	</div>



</div>
<?php include "inc/new_import.php" ?>
<?php include "inc/edit_import.php" ?>
<?php include "inc/view_import.php" ?>
<div class="modal" id="filter-modal" tabindex="-1" role="dialog" aria-labelledby="filter-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="filter-modal-title">Filter</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

         <div class="col">
        <div class="list-group " >
          <a 
          class="list-group-item list-group-item-action text-center" 
          onclick="$('#from').val('<?= date("d-m-Y") ?>');$('#to').val('<?= date("d-m-Y") ?>');$('#filter-form').submit();"
          >Today</a>
          <a 
          class="list-group-item list-group-item-action text-center" 
          onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 week")) ?>');$('#to').val('<?= date("d-m-Y") ?>');$('#filter-form').submit();"
          >Last Week</a>
          <a 
          class="list-group-item list-group-item-action text-center" 
          onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 month")) ?>');$('#to').val('<?= date("d-m-Y") ?>');$('#filter-form').submit();"
          >Last Month</a>
          <a 
          class="list-group-item list-group-item-action text-center"
          onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#to').val('<?= date("d-m-Y") ?>');$('#filter-form').submit();"
          >Last Year</a>
        </div>
      </div>
        <hr>
        Date

        <form action="<?= $this_url ?>" method="get" class="form-row mb-2" id="filter-form">
          <div class="col">
            <label for="">From</label>
            <input  name="from" id="from" type="text" class="form-control text-center fiter-date-from" value="<?= $from ?>">
          </div>
          <div class="col">
            <label for="">To</label>
            <input name="to" id="to"  type="text" class="form-control text-center fiter-date-to" value="<?= $to ?>">
          </div>

          <?php if (isset($_GET['branch']) &&  is_ruled('branches')): ?>
            <input type="text" hidden="" name="branch" value="<?= escap($_GET['branch']) ?>">
          <?php endif ?>
        </form>
 

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger"  data-dismiss="modal">Cancel</button>
        <button type="button" onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 month")) ?>');$('#to').val('<?= date("d-m-Y") ?>');$('#filter-form').submit();" class="btn btn-secondary"  data-dismiss="modal">Reset</button>
        <button onclick="$('#filter-form').submit();" type="button" class="btn btn-primary">Apply</button>
      </div>
    </div>
  </div>
</div>

<div class="modal" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Are you sure?</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        This order will be deleted.
      </div>
      <div class="modal-footer">
      	<form  method="post" action="<?= remove_from_url($this_url,["v","i"]) ?>">
      		<input type="text" hidden="" name="id" id="delete_order_id" value="0">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
	        <button type="submit" name="delete_import" class="btn btn-danger">Ok</button>
        </form>
      </div>
    </div>
  </div>
</div>
		<?php require_once($root."/inc/footer.inc.php") ?>
		<?php require_once($root."/inc/vendors.inc.php") ?>


<script>
	  $(document).ready(function() {
    var $table = $('#datatable-tabletools');
    var table = $table.dataTable({
      "lengthMenu": [
      [25, 100, 500,-1],
      [25, 100, 500,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "columnDefs": [
      { "orderable": false, "targets": [5]}
      ],
      "order": [[ 0, "desc" ]],
 

      
      sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
      buttons: [ 
            {
              extend:'print',
              text: 'Print',
              exportOptions: {
                      columns: '0,1,2,3,4'
                  }
            },
            {
              extend:'excel',
              text: 'Exel',
              exportOptions: {
                          columns: '0,1,2,3,4'
                      }
            },
            {
              extend:'pdf',
              text: 'PDF',
              exportOptions: {
                          columns: '0,1,2,3,4'
                      }
            },
          ]
   
    });
    $('<div />').addClass('dt-buttons mb-2 pb-1 ').prependTo('#datatable-tabletools_wrapper');
        $('#datatable-tabletools_filter').addClass('');
        $table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper .dt-buttons' );
        // $('#datatable-tabletools_wrapper').find('.btn-secondary').removeClass('btn-secondary').addClass('btn-default');




         <?php if ($view=="edit"): ?>
         	$("#edit-import-modal").modal("show")
         <?php endif ?>

         <?php if ($view=="view"): ?>
         	$("#view-import-modal").modal("show")
         <?php endif ?>
      });
</script>

	</body>
</html>