<?php

if (isset($_POST['new']) && $tk->passes()) {

	$reference = isset($_POST['reference'])?$_POST['reference']:'';
	$time_date = isset($_POST['time_date'])?$_POST['time_date']:date("Y-m-d");
	$sup_id = isset($_POST['sup_id'])?$_POST['sup_id']:'';
	$list = isset($_POST['list'])?$_POST['list']:'[]';
	$from_request = isset($_POST['from_request'])?$_POST['from_request']:'';

	$v->validate([
		tr("Reference")=>[$reference,"required"],
		tr("Supplier")=>[$sup_id,"required"],

	]);

	if ($v->passes() ) {

		$db->query("INSERT INTO stock_imports( reference, time_date, sup_id, created_by) VALUES(?,?,?,?) ",[$reference,$time_date,$sup_id,auth()->id]);

		$id = $db->lastInsertId();

		if (is_json($list)) {
			$list = json_decode($list,true);
		}else{
			$list = [];
		}
		
		foreach ($list as $key => $detail) {
			foreach ($detail['items'] as $key => $item) {
				$db->query(
					"INSERT INTO stock_imports_data(import_id, product_id,name, branch_id, qty, cost,tax_percent,tax) VALUES (?,?,?,?,?,?,?,?)",
					[
						$id,
						$item['p_id'],
						$item['name'],
						$detail['branch'],
						$item['qty'],
						$item['cost'],
						$item['tax_percent'],
						$item['cost']*$item['qty']*$item['tax_percent']/100,
					]
				);

				if ($item['p_id']>0){
					$status = $db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND p_id = ?",[$detail['branch'],$item['p_id']]);

					if (!$status) {
						$db->query("INSERT INTO stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?)",[$item['p_id'],$detail['branch'],$item['qty']]);
					}else{
						$db->query("UPDATE stock_product_quantity SET quantity = quantity+? WHERE p_id = ? AND branch_id = ?",[$item['qty'],$item['p_id'],$detail['branch']]);
					}

					$db->query("UPDATE stock_poroducts SET cost = ?  WHERE id = ? ",[$item['cost'],$item['p_id']]);

					$change = ($item['qty']>=0)?"+".$item['qty']:"-".$item['qty'];

					$db->query(
						"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
						[$item['p_id'] , $detail['branch'], $change , "New purchases",auth()->id]
					);
				}
				
			}
		}


		$total = $db->row("SELECT sum(cost*qty) as cost, sum(tax) as tax FROM stock_imports_data WHERE import_id = ? ",[$id]);

		$db->query("UPDATE stock_imports SET cost = ?, tax = ? WHERE id = ? ",[$total['cost'],$total['tax'],$id]);

		// If this purchase was created from a stock request, update the request status
		if (!empty($from_request) && is_numeric($from_request)) {
			$db->query("UPDATE stock_order_requests SET status='converted', purchase_id=?, updated_by=? WHERE id=?",
				[$id, auth()->id, $from_request]);
		}

		$display->success(tr("Purchases created successfully."));

		$redirect->to(add_to_url($this_url,["v","i"],["edit",$id]));
	}
}

if (isset($_POST['edit']) && $tk->passes() && can("manage-purchases")) {


	$id = isset($_POST['id'])?$_POST['id']:'';

	$reference = isset($_POST['reference'])?$_POST['reference']:'';
	$time_date = isset($_POST['time_date'])?$_POST['time_date']:date("Y-m-d");
	$sup_id = isset($_POST['sup_id'])?$_POST['sup_id']:'';
	$list = isset($_POST['list'])?$_POST['list']:'[]';
	$deleted = isset($_POST['deleted'])?$_POST['deleted']:'[]';

	$v->validate([
		tr("Reference")=>[$reference,"required"],
		tr("Supplier")=>[$sup_id,"required"],

	]);


	if ($v->passes() ) {

		$db->query("UPDATE stock_imports SET reference=?, time_date=?, sup_id=?,updated_by=?  WHERE id = ?  ",[$reference,$time_date,$sup_id,auth()->id,$id]);

		

		if (is_json($list)) {
			$list = json_decode($list,true);
		}else{
			$list = [];
		}
		$db->query("UPDATE stock_imports_data SET deleted_01 = 1 WHERE import_id=?",[$id]);
		foreach ($list as $key => $detail) {
			foreach ($detail['items'] as $key => $item) {
				if ($item['id']==0 || $item['p_id']==0) {
					$db->query(
						"INSERT INTO stock_imports_data(import_id, product_id,name, branch_id, qty, cost,tax_percent,tax) VALUES (?,?,?,?,?,?,?,?)",
						[
							$id,
							$item['p_id'],
							$item['name'],
							$detail['branch'],
							$item['qty'],
							$item['cost'],
							$item['tax_percent'],
							$item['cost']*$item['qty']*$item['tax_percent']/100,
						]
					);


					if ($db->single("SELECT max(id) FROM stock_imports")==$id) {
						$db->query("UPDATE stock_poroducts SET cost = ?  WHERE id = ? ",[$item['cost'],$item['p_id']]);
					}

					if ($item['p_id']>0){
						$status = $db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND p_id = ?",[$detail['branch'],$item['p_id']]);

						if (!$status) {
							$db->query("INSERT INTO stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?)",[$item['p_id'],$detail['branch'],$item['qty']]);
						}else{
							$db->query("UPDATE stock_product_quantity SET quantity = quantity+? WHERE p_id = ? AND branch_id = ?",[$item['qty'],$item['p_id'],$detail['branch']]);
						}

						$change = ($item['qty']>=0)?"+".$item['qty']:"-".$item['qty'];

						$db->query(
							"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
							[$item['p_id'] , $detail['branch'], $change , "Update purchases",auth()->id]
						);
					}
				}else{
					if ($item['p_id']>0) {
						$status = $db->row("SELECT * FROM stock_product_quantity WHERE branch_id = ? AND p_id = ?",[$detail['branch'],$item['p_id']]);

						if (!$status) {
							$db->query("INSERT INTO stock_product_quantity(p_id,branch_id,quantity) VALUES(?,?,?)",[$item['p_id'],$detail['branch'],$item['qty']]);
						}else{
							$db->query("UPDATE stock_product_quantity SET quantity = quantity+? WHERE p_id = ? AND branch_id = ?",[$item['qty'],$item['p_id'],$detail['branch']]);
						}

						if ($db->single("SELECT max(id) FROM stock_imports")==$id) {
							$db->query("UPDATE stock_poroducts SET cost = ?  WHERE id = ? ",[$item['cost'],$item['p_id']]);
						}

						$q_data = $db->row("SELECT * FROM stock_product_quantity WHERE p_id = ? AND branch_id=?",[$item['p_id'],$detail['branch']]);
						
						$import_row=$db->row("SELECT * FROM stock_imports_data WHERE id = ? ",[$item['id']]);
						
						$db->query("UPDATE stock_imports_data SET  qty=?, cost=?,tax_percent=?,tax=?, deleted_01 = 0  WHERE id = ?",[
							$item['qty'],
							$item['cost'],
							$item['tax_percent'],
							$item['cost']*$item['qty']*$item['tax_percent']/100,$item['id']]);


						$oldQuantity =$import_row['qty'];
						$remain      =$q_data['quantity'];

						$used        =$oldQuantity-$remain;
						$newRemain   =$item['qty']-$used;

						$qchange=$item['qty'] - $import_row['qty'];

						$db->query("UPDATE stock_product_quantity SET quantity = quantity-? WHERE p_id = ? AND branch_id = ? ",[$newRemain,$item['p_id'],$detail['branch']]);

						$change = ($qchange>=0)?"-".$qchange:"+".$qchange;

						$db->query(
							"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
							[$item['p_id'] , $detail['branch'], $change , "Update purchases",auth()->id]
						);
					}
					
				}
			}
		}

		$deleted_itme_list = $db->query("SELECT * FROM stock_imports_data WHERE import_id = ? AND deleted_01 = 1",[$id]);

		foreach ($deleted_itme_list as $key => $ro) {
				$db->query("UPDATE stock_product_quantity SET quantity = quantity-? WHERE p_id = ? AND branch_id = ? ",[$ro['qty'],$ro['product_id'],$ro['branch_id']]);

				$change = ($ro['qty']>=0)?"-".$ro['qty']:"+".$ro['qty'];

				$db->query(
					"INSERT INTO stock_product_logs(p_id,branch_id,qty_change,type,added_by) VALUES(?,?,?,?,?)",
					[$ro['product_id'] , $ro['branch_id'], $change , "Edit purchases",auth()->id]
				);
		}


		$total = $db->row("SELECT sum(cost*qty) as cost, sum(tax) as tax FROM stock_imports_data WHERE import_id = ? AND deleted_01=0",[$id]);

		$db->query("UPDATE stock_imports SET cost = ?, tax = ? WHERE id = ? ",[$total['cost'],$total['tax'],$id]);

		$display->success(tr("Purchases updated successfully."));

	}
}

if (isset($_POST['delete']) && can("admin")) {
	$id = isset($_POST['id'])?$_POST['id']:'';
	$v->validate([
		tr("ID")=>[$id,"required"],
	]);

	if ($v->passes() && $tk->passes()) {

		$db->query("UPDATE suppliers SET deleted_01=0,updated_by=? WHERE id=? ",[auth()->id,$id]);
		$display->success(tr("Customer deleted successfully."));
		$redirect->to(remove_from_url($this_url,["i","v"]));
	}
		
}

$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';

$page=[
	"title"=>tr("Purchases"),
	"active"=>"purchases"
];

switch ($view) {
	case 'new':
		
		$page_nav=[
			"breadcrumb"=>[
				tr("Purchases")=>$app_url."/inventory/purchases/",
				tr("New")=>$app_url."/inventory/purchases/",
			],
		];

		$page['class']=" sidebar-xs  ";
		
		// Check if creating from a stock request
		$from_request_id = isset($_GET['from_request']) ? $_GET['from_request'] : null;
		$request_data = null;
		$prefill_list = [];
		
		if ($from_request_id && is_numeric($from_request_id)) {
			$request_data = $db->row("SELECT * FROM stock_order_requests WHERE id = ? AND deleted_01=0 AND status IN ('pending','approved')", [$from_request_id]);
			
			if ($request_data) {
				// Load request items and format for Vue.js details array
				$request_items = $db->query("SELECT d.*, p.name as product_name FROM stock_order_requests_data d 
					LEFT JOIN stock_poroducts p ON p.id = d.product_id 
					WHERE d.request_id = ? AND d.deleted_01=0", [$from_request_id]);
				
				if (count($request_items) > 0) {
					$items_for_branch = [];
					foreach ($request_items as $item) {
						$items_for_branch[] = [
							'id' => 0,
							'p_id' => $item['product_id'],
							'name' => $item['product_name'],
							'qty' => $item['qty'],
							'cost' => 0,
							'tax_percent' => 0,
							'tax' => 0
						];
					}
					
					$prefill_list = [
						[
							'branch' => $request_data['branch_id'],
							'items' => $items_for_branch
						]
					];
				}
			}
		}
		
		$page_view = "views/new.php";
	break;

	case 'edit':
		
			$page_nav=[
				"breadcrumb"=>[
					tr("Purchases")=>$app_url."/inventory/purchases/",
					tr("Edit")=>$app_url."/inventory/purchases/",
				],
			];

			$page['class']=" sidebar-xs  ";
			

			if (isset($_GET['i']) && is_numeric($_GET['i'])) {
				$data = $db->row("SELECT * FROM stock_imports WHERE id = ? ",[$_GET['i']]);

				$list = [];

				foreach ($db->query("SELECT * FROM branches ") as $key => $br) {
					$im_data = $db->query("SELECT * FROM stock_imports_data WHERE import_id=? AND branch_id=? AND deleted_01=0 ",[$data['id'],$br['id']]);

					for ($i=0; $i < count($im_data); $i++) { 
						$im_data[$i]['p_id']=$im_data[$i]['product_id'];
						if ($im_data[$i]['product_id']>0) {
							$im_data[$i]['name'] = $db->single("SELECT name FROM stock_poroducts WHERE id = ? ",[$im_data[$i]['product_id']]);
						}
					}

					if (count($im_data )>0) {

						$det = [
							"branch"=>$br['id'],
							"items"=>$im_data
						];

						array_push($list, $det);
					}
				}
				

				

				if (!$data) {
					$redirect->to(404);
				}
			}


			$page_view = "views/edit.php";
		

	
	break;
	
	default:


		$from = date("Y-m-d H:i",strtotime("-1 year"));
		$to   = date("Y-m-d H:i");



		if (isset($_GET['from'])) {
		  $from = date("Y-m-d H:i",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d H:i",strtotime($_GET['to']));
		}

		
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Purchases")=>$app_url."/inventory/purchases",
			],
			"date_filter"=>[
				"from"=>$from,
				"to"=>$to
			],
			// "branch"=>1,
		];


		$list = $db->query("SELECT * FROM  stock_imports WHERE  deleted_01=0 and date(created_at)>= date(?) AND date(created_at)<=date(?)",[$from,$to]);


		$page_view = "views/index.php";

	break;
}