<?php
	$suppliers = $db->query("SELECT * FROM stock_suppliers WHERE deleted_01=0");

?>
<div class="row justify-content-center" id="app">
	<div class="col-md-12">
		<form method="post" enctype="multipart/form-data">
			<div class="card shadow">
				<div class="card-header bg-primary">
					<h3><?= tr("Purchases") ?> #<?= $data['id'] ?></h3>
				</div>
				<div class="card-body">
					
					<div class="row ">
						<div class="col-md-3 my-1">
							<label for=""><?= tr("Created by") ?></label>
							<input type="text" class="form-control" value="<?= escap($user->get($data['created_by'])->name) ?>"  disabled="" >
						</div>
						<div class="col-md-3 my-1">
							<label for=""><?= tr("Supplier") ?></label>
							<select name="sup_id" id="" class="form-control select2">
								<?php foreach ($suppliers as $key => $sup): ?>
								<option <?= old("sup_id",$data['sup_id'])==$sup['id']?'selected':'' ?> value="<?= $sup['id'] ?>"><?= escap($sup['name']) ?></option>
								<?php endforeach ?>
							</select>
						</div>
						
						<div class="col-md-3 my-1">
							<label for=""><?= tr("Date") ?></label>
							<input type="date" name="time_date" class="form-control"  required value="<?= old("time_date",$data['time_date']) ?>">
						</div>
						<div class="col-md-3 my-1">
							<label for=""><?= tr("Reference") ?></label>
							<input type="text" name="reference" class="form-control"  required value="<?= old("reference",$data['reference']) ?>">
						</div>
						
					</div>
					<hr>
							
						
					<div class="row table-responsive"  v-for="(data,index) in details" @click="selected_row=index">

						<div class="col px-0 card card-body shadow">
							<div class="input-group px-2">
							<input type="search" class="form-control search-input" placeholder="Search">
							<div class="input-group-prepend">
						      	<span class="input-group-text"><i class="fas fa-search"></i></span>
						    </div>
						</div>
						<table class="table table-sm" style="min-width: 790px">
							<thead>
								<tr>
									<th colspan="3"><?= tr("Branch") ?></th>
									<th><?= tr("Details") ?></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td style="width: 30px;"><button  class="btn btn-danger" @click="remove_detail(index)"><i class="fas fa-times"></i></button></td>
									<td style="width: 190px">
										<select required=""  class="form-control" v-model="data.branch">
											<?php foreach (branch()->list() as $key => $branch): ?>
											<option value="<?= $branch['id'] ?>"><?= escap($branch['name']) ?></option>
											<?php endforeach ?>
										</select>
									</td>
									<td style="width: 30px;">
										<button type="button" class="btn btn-info" @click="add_product(index)"><i class="fas fa-plus"></i></button>
									</td>
									<td>
										<table class="table table-sm border table-striped">
											<thead class="bg-primary">
												<tr>
													<td></td>
													<td></td>
													<td><?= tr("Item") ?></td>
													<td><?= tr("Quantity") ?></td>
													<td><?= tr("Cost") ?></td>
													<td>Tax%</td>
													<td><?= tr("Total") ?></td>
												</tr>
											</thead>
											<tbody>
												<tr v-for="(item,subindex) in data.items">
													<td>{{subindex+1}}</td>
													<td style="max-width: 50px">
														<button type="button" class="btn btn-sm btn-danger" @click="remove_product(index,subindex)"><i class="fas fa-times"></i></button>
													</td>
													<td style="max-width: 120px">
														<input type="text" class="form-control" v-model="item.name" v-show="item.p_id==0">
														<span v-show="item.p_id>0">{{item.name}}</span>
													</td>
													<td style="max-width: 80px">
														<input type="number" required="" min="0" v-model="item.qty" class="form-control text-monospace">
													</td>
													<td style="max-width: 80px">
														<input type="number" required="" min="0" step="0.00001" class="form-control text-monospace" v-model="item.cost">
													</td>
													<td style="max-width: 80px">
														<input type="number" required="" min="0" step="0.1" class="form-control text-monospace" v-model="item.tax_percent">
													</td>
													<td  class="text-center text-monospace">
														{{to_price((parseFloat(item.cost)+parseFloat(item.cost)*parseFloat(item.tax_percent)/100)*parseFloat(item.qty),1)}}
													</td>
												</tr>
												<tr>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td></td>
													<td>Total:</td>
													<td class="text-center text-monospace">{{ to_price(detail_totol(index),1) }}</td>
												</tr>
											</tbody>
											
										</table>
									</td>
								</tr>
							</tbody>
						</table>
						</div>
					</div>
					<div class="text-end">
						<button type="button" class="btn btn-info" @click="add_details"><?= tr("Add details") ?></button>
					</div>

					<div class="row">
						<div class="col-md-4">
							<table class="table table-sm table-striped border">
								<tr>
									<th class="text-end"><?= tr("Subtotal") ?></th>
									<th class="text-monospace text-center">{{ to_price(totalCost-totalTax,1) }}</th>
								</tr>
								<tr>
									<th class="text-end"><?= tr("VAT") ?></th>
									<th class="text-monospace text-center">{{ to_price(totalTax,1) }}</th>
								</tr>
								<tr>
									<th class="text-end"><?= tr("Total") ?></th>
									<th class="text-monospace text-center">{{ to_price(totalCost,1) }}</th>
								</tr>
							</table>
						</div>

					</div>
				</div>
				<div class="card-footer text-end">
					<button class="btn btn-primary rounded-pill px-3" name="edit"><?= tr("Save") ?></button>
				</div>
			</div>

			<input type="hidden" name="list" :value="JSON.stringify(details)">
			<input type="hidden" name="deleted" :value="JSON.stringify(deleted_list)">
			<input type="hidden" name="id" value="<?= $data['id'] ?>">
		</form>
	</div>
</div>

<script>
	let app = new Vue({
		el:"#app",
		data:{
			total:0,
			details:<?= old("list",json_encode($list)) ?>,
			selected_row:0,
			deleted_list:[],
		},
		methods:{
			add_details(){

				this.details.push({
					branch:<?= branch()->id() ?>,
					items:[]
				})
				loadauto()
			},
			add_to_deleted(objc){
				this.deleted_list.push(objc);
			},
			remove_detail(index){
				this.details.splice(index,1)
				for (var i = 0; i < this.details[index].items.length; i++) {
					this.add_to_deleted(this.details[index].items[i]);
				}
				loadauto()
			},
			add_product(index){
				this.details[index].items.push({
					qty:1,
					cost:0,
					tax:0,
					tax_percent:0,
					name:'',
                    p_id:0,
					id:0,
				})
			},
			add_product2(index,data){
				this.details[index].items.push({
					qty:1,
					cost:data.cost,
					tax:0,
					tax_percent:0,
					name:data.name,
                    p_id:data.id,
					id:0,
				})
			},
			remove_product(index,subindex){
				this.add_to_deleted(this.details[index].items[subindex]);
				this.details[index].items.splice(subindex,1)
			},
			detail_totol(index){
				total=0
				for (var i = 0; i < this.details[index].items.length; i++) {
					total+=(parseFloat(this.details[index].items[i].cost)+parseFloat(this.details[index].items[i].cost)*parseFloat(this.details[index].items[i].tax_percent)/100)*parseFloat(this.details[index].items[i].qty)
				}

				return total
			},
			

			to_price(val,format = false){
				if (format) {
					return this.foramt(parseFloat(this.toNearest(val)).toFixed(<?= $float_points ?>));
				}
				return parseFloat(this.toNearest(val)).toFixed(<?= $float_points ?>)
			},
			toNearest(num,frac=0.00001){
				return Math.ceil(parseFloat(num) / frac) * frac
			},
			foramt(n){
				var val = Math.round(Number(n) *100) / 100;
				var parts = n.toString().split(".");
				var num = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, "<?= $number_separator ?>") + (parts[1] ? "." + parts[1] : "");
				return num
			},

		},
		computed:{
			totalCost(){
				job = this;
				job.total=0;


				for (var i = 0; i < job.details.length; i++) {
					job.total+=job.detail_totol(i);
				}

				return job.total;
			},

			totalTax(){
				job = this;
				tax=0;


				for (var j = 0; j < job.details.length; j++) {
				
					for (var i = 0; i < job.details[j].items.length; i++) {
						tax+=(parseFloat(job.details[j].items[i].cost)*parseFloat(job.details[j].items[i].tax_percent)/100)*parseFloat(job.details[j].items[i].qty)
					}
				}

				return tax;
			},
		},
		mounted(){
			loadauto()
		}

	});


	function loadauto(){
		setTimeout(function(){
			$(".search-input").each(function(index, el) {
				// $(el).autocomplete("destroy");
			});
		$(".search-input").each(function(index, el) {
			$(el).autocomplete({
		            minLength: 2,
		            delay: 1000,
		            source: function(request, response) {

		            	console.log(request)
		                var term = request.term;
		  
		     

		                $.get('<?= $app_url ?>/inventory/purchases/ajax/?f=search&search='+term, function(data) {
		                	
		                    response(data);
		                },'json');
		            },
		
		            select:function(event, ui,item){
		            	console.log(ui.item)
		            	// console.log(item)
		            	
		            	app.add_product2(app.selected_row,ui.item)
		            },
		            search: function() {
		                $(this).parent().addClass('ui-autocomplete-processing');
		            },
		            open: function() {
		                $(this).parent().removeClass('ui-autocomplete-processing');
		            }
		        })
		        .focus(function () {
				    $(this).autocomplete("search");
				})
		        .autocomplete('instance')._renderItem = function(ul, item) {
	            return $('<li>').append('<span class="font-weight-semibold border-top pb-0">' + item.id + '</span>' + '<div class="font-weight-semibold font-size-sm pt-0">' + item.name + ' <span class="font-weight-semibold pb-0 px-3 text-danger">   </span>'+  ' <span class="font-weight-semibold pb-0 px-1 text-info"> </span>'+ '</div>').appendTo(ul);
	        };
		});
		},500)
		
	}

	$(document).ready(function() {
		
	

	});
</script>