
		<div class="card shadow">
			<div class="card-header d-flex justify-content-between bg-primary">
				<h3><?= tr("Purchases") ?></h3>
				<div class="text-end">
					<a href="<?= add_to_url($this_url,"v","new") ?>" class="btn btn-light px-3 rounded-pill"><?= tr("New") ?></a>
				</div>
			</div>
			<table class="table" id="datatable-tabletools">
				<thead>
					<tr>
						<th><?= tr("No.") ?></th>
						<th><?= tr("Date") ?></th>
						<th><?= tr("Reference") ?></th>
						<th><?= tr("Supplier") ?> </th>
						<th><?= tr("Cost") ?> </th>
						<th><?= tr("Created by") ?> </th>
		
						

						<th class="text-center"><?= tr("Action") ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($list as $key => $item): ?>
						<tr>
							<td><?= $item['id'] ?></td>
							<td><?= $item['created_at'] ?></td>
							<td><?= $item['reference'] ?></td>
							<td><?= $db->single("SELECT name FROM stock_suppliers WHERE id = ? ",[$item['sup_id']]) ?></td>
							<td class="text-monospace"><?= amount($item['cost']) ?></td>
							<td class="text-monospace"><?= $user->get($item['created_by'])->name ?></td>
					
			
			
							<td class="text-center">
								<a href="<?= add_to_url($this_url,["v","i"],["edit",$item['id']]) ?>" class="btn btn-sm   btn-light btn-action "><?= tr("View") ?></a>
			
							</td>

						</tr>
					<?php endforeach ?>
				</tbody>
			</table>
		</div>



<script>
	$(document).ready(function() {

		var table=''
		$(document).ready(function() {
				var $table = $('#datatable-tabletools');

				 table = $table.dataTable({
				 	
        
			    language: {
		              search: '<span></span> _INPUT_',
		              searchPlaceholder: '<?= tr("Search") ?>',
		              lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [25, 100, 500,1000],
			          [25, 100, 500,1000]
			        ],
			        "order": [[ 0, "asc" ]],
		
					"columnDefs": [
					    { "orderable": false, "targets": [6]},
					 
					],
					// stateSave: true,
			        // processing: true,
			        // serverSide: true,
		
					
					// sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
					dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,
					 buttons: {
            dom: {
              button: {
                  className: 'btn btn-light border'
                  }
              },
              buttons: [
        
                  {
                    extend: 'csv', 
                    exportOptions: {
                      stripHtml: 1,
                      columns: [ 0,2,3,4,5,1 ]
                  }

                  },
                  {
                    extend: 'pdf', 
                    exportOptions: {
                      stripHtml: 1,
                      columns: [ 0,2,3,4,5,1  ]
                  }
                  },
                  {
                    extend: 'print', 
                    exportOptions: {
                      stripHtml: 1,
                      columns: [ 0,2,3,4,5,1  ]
                  }
                },

              ],
          },

					
				});

			



				
			});
	});
</script>