<?php
$root="..";
require($root."/php/init.php");

$user->authorize("view-purchases|manage-purchases");

$page=[
	"title"=>tr("Inventory Report"),
	"active"=>"inventory-report",
	"class"=>"sidebar-xs"
];

$page_nav=[
	"breadcrumb"=>[
		tr("Inventory")=>$app_url."/inventory/items/",
		tr("Report")=>""
	],
];

// Get all branches
$branches = $db->query("SELECT * FROM branches WHERE deleted_01=0 ORDER BY id");

// Selected branch filter
$selected_branch = isset($_GET['branch']) ? $_GET['branch'] : 'all';

// Get inventory data per branch
$branch_stats = [];
foreach ($branches as $br) {
	$total_items = $db->single("SELECT COUNT(DISTINCT p_id) FROM stock_product_quantity WHERE branch_id = ? AND quantity > 0", [$br['id']]);
	
	$total_quantity = $db->single("SELECT COALESCE(SUM(quantity), 0) FROM stock_product_quantity WHERE branch_id = ?", [$br['id']]);
	
	$total_value = $db->single("SELECT COALESCE(SUM(q.quantity * p.cost), 0) FROM stock_product_quantity q 
		LEFT JOIN stock_poroducts p ON p.id = q.p_id 
		WHERE q.branch_id = ? AND p.deleted_01 = 0", [$br['id']]);
	
	$low_stock = $db->single("SELECT COUNT(*) FROM stock_product_quantity q 
		LEFT JOIN stock_poroducts p ON p.id = q.p_id 
		WHERE q.branch_id = ? AND p.deleted_01 = 0 AND p.alert > 0 AND q.quantity <= p.alert", [$br['id']]);
	
	$branch_stats[$br['id']] = [
		'name' => $br['name'],
		'total_items' => intval($total_items),
		'total_quantity' => floatval($total_quantity),
		'total_value' => floatval($total_value),
		'low_stock' => intval($low_stock)
	];
}

// Get all stock items with branch quantities
if ($selected_branch == 'all') {
	$stock_items = $db->query("SELECT p.*, c.name as category_name,
		(SELECT COALESCE(SUM(quantity), 0) FROM stock_product_quantity WHERE p_id = p.id) as total_qty
		FROM stock_poroducts p 
		LEFT JOIN stock_categories c ON c.id = p.cat_id
		WHERE p.deleted_01 = 0 
		ORDER BY p.name ASC");
} else {
	$stock_items = $db->query("SELECT p.*, c.name as category_name,
		COALESCE(q.quantity, 0) as total_qty
		FROM stock_poroducts p 
		LEFT JOIN stock_categories c ON c.id = p.cat_id
		LEFT JOIN stock_product_quantity q ON q.p_id = p.id AND q.branch_id = ?
		WHERE p.deleted_01 = 0 
		ORDER BY p.name ASC", [$selected_branch]);
}

// Get low stock items (filtered by branch if selected)
if ($selected_branch == 'all') {
	$low_stock_items = $db->query("SELECT p.*, c.name as category_name, q.quantity, q.branch_id, b.name as branch_name
		FROM stock_poroducts p 
		LEFT JOIN stock_categories c ON c.id = p.cat_id
		LEFT JOIN stock_product_quantity q ON q.p_id = p.id
		LEFT JOIN branches b ON b.id = q.branch_id
		WHERE p.deleted_01 = 0 AND p.alert > 0 AND q.quantity <= p.alert
		ORDER BY (p.alert - q.quantity) DESC
		LIMIT 20");
} else {
	$low_stock_items = $db->query("SELECT p.*, c.name as category_name, q.quantity, q.branch_id, b.name as branch_name
		FROM stock_poroducts p 
		LEFT JOIN stock_categories c ON c.id = p.cat_id
		LEFT JOIN stock_product_quantity q ON q.p_id = p.id
		LEFT JOIN branches b ON b.id = q.branch_id
		WHERE p.deleted_01 = 0 AND p.alert > 0 AND q.quantity <= p.alert AND q.branch_id = ?
		ORDER BY (p.alert - q.quantity) DESC
		LIMIT 20", [$selected_branch]);
}

// Get recent stock movements (filtered by branch if selected)
if ($selected_branch == 'all') {
	$recent_movements = $db->query("SELECT l.*, p.name as product_name, b.name as branch_name, u.name as user_name
		FROM stock_product_logs l
		LEFT JOIN stock_poroducts p ON p.id = l.p_id
		LEFT JOIN branches b ON b.id = l.branch_id
		LEFT JOIN users u ON u.id = l.added_by
		ORDER BY l.added_on DESC
		LIMIT 20");
} else {
	$recent_movements = $db->query("SELECT l.*, p.name as product_name, b.name as branch_name, u.name as user_name
		FROM stock_product_logs l
		LEFT JOIN stock_poroducts p ON p.id = l.p_id
		LEFT JOIN branches b ON b.id = l.branch_id
		LEFT JOIN users u ON u.id = l.added_by
		WHERE l.branch_id = ?
		ORDER BY l.added_on DESC
		LIMIT 20", [$selected_branch]);
}

// Get categories summary
$categories = $db->query("SELECT c.*, 
	(SELECT COUNT(*) FROM stock_poroducts WHERE cat_id = c.id AND deleted_01 = 0) as item_count
	FROM stock_categories c WHERE c.deleted_01 = 0 ORDER BY c.name");

// Calculate totals based on selected branch
$grand_total_items = 0;
$grand_total_value = 0;
$grand_low_stock = 0;
$grand_total_quantity = 0;

if ($selected_branch == 'all') {
	foreach ($branch_stats as $stat) {
		$grand_total_items += $stat['total_items'];
		$grand_total_value += $stat['total_value'];
		$grand_low_stock += $stat['low_stock'];
		$grand_total_quantity += $stat['total_quantity'];
	}
	$total_products = $db->single("SELECT COUNT(*) FROM stock_poroducts WHERE deleted_01=0");
} else {
	$grand_total_items = $branch_stats[$selected_branch]['total_items'] ?? 0;
	$grand_total_value = $branch_stats[$selected_branch]['total_value'] ?? 0;
	$grand_low_stock = $branch_stats[$selected_branch]['low_stock'] ?? 0;
	$grand_total_quantity = $branch_stats[$selected_branch]['total_quantity'] ?? 0;
	$total_products = $db->single("SELECT COUNT(DISTINCT p_id) FROM stock_product_quantity WHERE branch_id = ?", [$selected_branch]);
}

// Top 10 Consumed Items (items with negative stock changes = consumed/used)
if ($selected_branch == 'all') {
	$top_consumed = $db->query("SELECT 
		p.id, p.name, c.name as category_name,
		SUM(ABS(CAST(REPLACE(l.qty_change, '+', '') AS SIGNED))) as total_consumed,
		COUNT(l.id) as times_consumed
		FROM stock_product_logs l
		LEFT JOIN stock_poroducts p ON p.id = l.p_id
		LEFT JOIN stock_categories c ON c.id = p.cat_id
		WHERE l.qty_change LIKE '-%' AND p.deleted_01 = 0
		GROUP BY l.p_id
		ORDER BY total_consumed DESC
		LIMIT 10");
} else {
	$top_consumed = $db->query("SELECT 
		p.id, p.name, c.name as category_name,
		SUM(ABS(CAST(REPLACE(l.qty_change, '+', '') AS SIGNED))) as total_consumed,
		COUNT(l.id) as times_consumed
		FROM stock_product_logs l
		LEFT JOIN stock_poroducts p ON p.id = l.p_id
		LEFT JOIN stock_categories c ON c.id = p.cat_id
		WHERE l.qty_change LIKE '-%' AND p.deleted_01 = 0 AND l.branch_id = ?
		GROUP BY l.p_id
		ORDER BY total_consumed DESC
		LIMIT 10", [$selected_branch]);
}

// Get max consumed for chart scaling
$max_consumed = 1;
foreach ($top_consumed as $tc) {
	if (floatval($tc['total_consumed']) > $max_consumed) {
		$max_consumed = floatval($tc['total_consumed']);
	}
}

?>
<!DOCTYPE html>
<html <?= $local ?>>
<?php require($root."/inc/head.php") ?>

<style>
	.report-card {
		border: none;
		border-radius: 8px;
		transition: transform 0.2s;
	}
	.report-card:hover {
		transform: translateY(-2px);
	}
	.stat-icon {
		width: 50px;
		height: 50px;
		border-radius: 8px;
		display: flex;
		align-items: center;
		justify-content: center;
		font-size: 20px;
	}
	.stat-value {
		font-size: 1.5rem;
		font-weight: 700;
	}
	.stat-label {
		font-size: 0.8rem;
		text-transform: uppercase;
		letter-spacing: 0.5px;
	}
	.section-title {
		font-size: 1rem;
		font-weight: 600;
		color: #495057;
		margin-bottom: 1rem;
		padding-bottom: 0.5rem;
		border-bottom: 2px solid #e9ecef;
	}
	.report-header {
		background: linear-gradient(135deg, #1a5276 0%, #2874a6 100%);
		border-radius: 8px;
		color: white;
		padding: 1.5rem;
		margin-bottom: 1.5rem;
	}
	.table-report th {
		background: #f8f9fa;
		font-weight: 600;
		text-transform: uppercase;
		font-size: 0.75rem;
		letter-spacing: 0.5px;
		color: #6c757d;
		border-top: none;
	}
	.table-report td {
		vertical-align: middle;
	}
	.branch-card {
		border-left: 4px solid #007bff;
	}
	.branch-card.low-stock {
		border-left-color: #dc3545;
	}
	.progress-thin {
		height: 6px;
		border-radius: 3px;
	}
	.stock-bar {
		height: 20px;
		background: #e9ecef;
		border-radius: 4px;
		overflow: hidden;
	}
	.stock-bar-fill {
		height: 100%;
		border-radius: 4px;
		transition: width 0.3s;
	}
	.stock-ok { background: #28a745; }
	.stock-low { background: #ffc107; }
	.stock-critical { background: #dc3545; }
	@media print {
		.no-print { display: none !important; }
		.report-card { box-shadow: none !important; border: 1px solid #ddd; }
	}
</style>

<body class="<?= isset($page['class'])?$page['class']:'' ?>">
	<?php require($root."/inc/header.php") ?>

	<div class="row">
		<div class="col">
			<?php $display->display_messages() ?>
			<div id="notify"></div>

			<!-- Header Section -->
			<?php $header_branch_name = $selected_branch == 'all' ? tr("All Branches") : ($branch_stats[$selected_branch]['name'] ?? ''); ?>
			<div class="report-header shadow">
				<div class="row align-items-center">
					<div class="col-md-8">
						<h4 class="mb-1 font-weight-bold">
							<i class="fas fa-warehouse mr-2"></i><?= tr("Inventory Report") ?>
						</h4>
						<p class="mb-0" style="opacity: 0.8;">
							<i class="far fa-clock mr-1"></i>
							<?= tr("Generated") ?>: <?= date("M d, Y H:i") ?>
							<span class="mx-2">|</span>
							<i class="fas fa-store mr-1"></i><?= escap($header_branch_name) ?>
						</p>
					</div>
					<div class="col-md-4 text-right no-print">
						<button type="button" onclick="window.print();" class="btn btn-light rounded-pill px-4">
							<i class="fas fa-print mr-2"></i><?= tr("Print") ?>
						</button>
					</div>
				</div>
			</div>

			<!-- Branch Filter -->
			<div class="row mb-4 no-print">
				<div class="col-md-4">
					<div class="input-group">
						<div class="input-group-prepend">
							<span class="input-group-text"><i class="fas fa-filter"></i></span>
						</div>
						<select class="form-control" onchange="window.location.href='?branch='+this.value">
							<option value="all" <?= $selected_branch == 'all' ? 'selected' : '' ?>><?= tr("All Branches") ?></option>
							<?php foreach ($branches as $br): ?>
							<option value="<?= $br['id'] ?>" <?= $selected_branch == $br['id'] ? 'selected' : '' ?>><?= escap($br['name']) ?></option>
							<?php endforeach ?>
						</select>
					</div>
				</div>
			</div>

			<!-- Overview KPI Cards -->
			<?php 
			$selected_branch_name = $selected_branch == 'all' ? tr("All Branches") : ($branch_stats[$selected_branch]['name'] ?? '');
			?>
			<div class="row mb-4">
				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100" style="border-left: 4px solid #007bff;">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Products in Stock") ?></p>
									<h4 class="stat-value text-dark mb-0"><?= $total_products ?></h4>
									<small class="text-muted"><?= escap($selected_branch_name) ?></small>
								</div>
								<div class="stat-icon bg-primary text-white">
									<i class="fas fa-boxes"></i>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100" style="border-left: 4px solid #28a745;">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Stock Value") ?></p>
									<h4 class="stat-value text-dark mb-0"><?= amount($grand_total_value) ?></h4>
									<small class="text-muted"><?= escap($selected_branch_name) ?></small>
								</div>
								<div class="stat-icon bg-success text-white">
									<i class="fas fa-dollar-sign"></i>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100" style="border-left: 4px solid #17a2b8;">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Total Quantity") ?></p>
									<h4 class="stat-value text-dark mb-0"><?= number_format($grand_total_quantity) ?></h4>
									<small class="text-muted"><?= tr("Units") ?> - <?= escap($selected_branch_name) ?></small>
								</div>
								<div class="stat-icon bg-info text-white">
									<i class="fas fa-cubes"></i>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100" style="border-left: 4px solid #dc3545;">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Low Stock Alerts") ?></p>
									<h4 class="stat-value <?= $grand_low_stock > 0 ? 'text-danger' : 'text-success' ?> mb-0"><?= $grand_low_stock ?></h4>
									<small class="text-muted"><?= escap($selected_branch_name) ?></small>
								</div>
								<div class="stat-icon bg-danger text-white">
									<i class="fas fa-exclamation-triangle"></i>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Branch-wise Stock Summary -->
			<div class="row mb-4">
				<div class="col-12 mb-3">
					<h5 class="section-title"><i class="fas fa-store-alt mr-2"></i><?= tr("Stock by Branch") ?></h5>
				</div>
				
				<?php foreach ($branch_stats as $branch_id => $stat): ?>
				<div class="col-md-6 col-lg-4 mb-3">
					<div class="card report-card shadow-sm h-100 branch-card <?= $stat['low_stock'] > 0 ? 'low-stock' : '' ?>">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-center mb-3">
								<h6 class="mb-0 font-weight-bold">
									<i class="fas fa-store mr-2 text-primary"></i><?= escap($stat['name']) ?>
								</h6>
								<?php if ($stat['low_stock'] > 0): ?>
								<span class="badge badge-danger"><?= $stat['low_stock'] ?> <?= tr("low") ?></span>
								<?php endif ?>
							</div>
							<div class="row text-center">
								<div class="col-4 border-right">
									<h5 class="mb-0 font-weight-bold text-primary"><?= $stat['total_items'] ?></h5>
									<small class="text-muted"><?= tr("Items") ?></small>
								</div>
								<div class="col-4 border-right">
									<h5 class="mb-0 font-weight-bold text-info"><?= number_format($stat['total_quantity']) ?></h5>
									<small class="text-muted"><?= tr("Units") ?></small>
								</div>
								<div class="col-4">
									<h5 class="mb-0 font-weight-bold text-success"><?= amount($stat['total_value']) ?></h5>
									<small class="text-muted"><?= tr("Value") ?></small>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endforeach ?>
			</div>

			<div class="row mb-4">
				<!-- Low Stock Items -->
				<div class="col-lg-6 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-exclamation-circle text-danger mr-2"></i><?= tr("Low Stock Items") ?>
							</h5>
						</div>
						<div class="card-body p-0">
							<?php if (count($low_stock_items) > 0): ?>
							<div class="table-responsive">
								<table class="table table-report table-hover mb-0">
									<thead>
										<tr>
											<th class="pl-3"><?= tr("Item") ?></th>
											<th><?= tr("Branch") ?></th>
											<th class="text-center"><?= tr("Stock") ?></th>
											<th class="text-center pr-3"><?= tr("Alert") ?></th>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($low_stock_items as $item): ?>
										<tr>
											<td class="pl-3">
												<strong><?= escap($item['name']) ?></strong>
												<br><small class="text-muted"><?= escap($item['category_name']) ?></small>
											</td>
											<td><small><?= escap($item['branch_name']) ?></small></td>
											<td class="text-center">
												<span class="badge badge-<?= $item['quantity'] <= 0 ? 'danger' : 'warning' ?>">
													<?= $item['quantity'] ?>
												</span>
											</td>
											<td class="text-center pr-3">
												<span class="text-muted"><?= $item['alert'] ?></span>
											</td>
										</tr>
										<?php endforeach ?>
									</tbody>
								</table>
							</div>
							<?php else: ?>
							<div class="text-center text-muted py-5">
								<i class="fas fa-check-circle fa-3x text-success mb-3"></i>
								<p><?= tr("All items are well stocked!") ?></p>
							</div>
							<?php endif ?>
						</div>
					</div>
				</div>

				<!-- Recent Stock Movements -->
				<div class="col-lg-6 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-history mr-2"></i><?= tr("Recent Stock Movements") ?>
							</h5>
						</div>
						<div class="card-body p-0">
							<?php if (count($recent_movements) > 0): ?>
							<div class="table-responsive">
								<table class="table table-report table-hover mb-0">
									<thead>
										<tr>
											<th class="pl-3"><?= tr("Item") ?></th>
											<th><?= tr("Change") ?></th>
											<th><?= tr("Type") ?></th>
											<th class="pr-3"><?= tr("Date") ?></th>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($recent_movements as $mv): ?>
										<tr>
											<td class="pl-3">
												<strong><?= escap($mv['product_name']) ?></strong>
												<br><small class="text-muted"><?= escap($mv['branch_name']) ?></small>
											</td>
											<td>
												<?php 
												$change = $mv['qty_change'];
												$is_positive = strpos($change, '+') !== false;
												?>
												<span class="badge badge-<?= $is_positive ? 'success' : 'danger' ?>">
													<?= $change ?>
												</span>
											</td>
											<td><small><?= escap($mv['type']) ?></small></td>
											<td class="pr-3">
												<small class="text-muted"><?= date("M d, H:i", strtotime($mv['added_on'])) ?></small>
											</td>
										</tr>
										<?php endforeach ?>
									</tbody>
								</table>
							</div>
							<?php else: ?>
							<div class="text-center text-muted py-5">
								<i class="fas fa-inbox fa-3x mb-3" style="opacity:0.3"></i>
								<p><?= tr("No recent movements") ?></p>
							</div>
							<?php endif ?>
						</div>
					</div>
				</div>
			</div>

			<!-- Top 10 Consumed Items -->
			<div class="row mb-4">
				<div class="col-12">
					<div class="card report-card shadow-sm">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-fire text-danger mr-2"></i><?= tr("Top 10 Consumed Items") ?>
								<?php if ($selected_branch != 'all'): ?>
								<small class="text-muted">- <?= escap($branch_stats[$selected_branch]['name'] ?? '') ?></small>
								<?php endif ?>
							</h5>
						</div>
						<div class="card-body">
							<?php if (count($top_consumed) > 0): ?>
							<div class="row">
								<?php 
								$rank = 1;
								foreach ($top_consumed as $tc): 
									$percent = ($max_consumed > 0) ? (floatval($tc['total_consumed']) / $max_consumed) * 100 : 0;
									$bar_color = $rank <= 3 ? 'danger' : ($rank <= 6 ? 'warning' : 'info');
								?>
								<div class="col-md-6 mb-3">
									<div class="d-flex align-items-center">
										<div class="mr-3 text-center" style="min-width: 30px;">
											<span class="badge badge-<?= $rank <= 3 ? 'danger' : 'secondary' ?> badge-pill px-2"><?= $rank ?></span>
										</div>
										<div class="flex-grow-1">
											<div class="d-flex justify-content-between align-items-center mb-1">
												<strong class="text-dark"><?= escap($tc['name']) ?></strong>
												<span class="badge badge-light"><?= number_format($tc['total_consumed']) ?> <?= tr("units") ?></span>
											</div>
											<div class="d-flex align-items-center">
												<div class="progress flex-grow-1 mr-2" style="height: 8px;">
													<div class="progress-bar bg-<?= $bar_color ?>" role="progressbar" style="width: <?= $percent ?>%"></div>
												</div>
												<small class="text-muted" style="min-width: 65px;"><?= $tc['times_consumed'] ?> <?= tr("times") ?></small>
											</div>
											<small class="text-muted"><?= escap($tc['category_name']) ?></small>
										</div>
									</div>
								</div>
								<?php 
								$rank++;
								endforeach; 
								?>
							</div>
							<?php else: ?>
							<div class="text-center text-muted py-4">
								<i class="fas fa-chart-bar fa-3x mb-3" style="opacity:0.3"></i>
								<p><?= tr("No consumption data available") ?></p>
							</div>
							<?php endif ?>
						</div>
					</div>
				</div>
			</div>

			<!-- Stock Items Table -->
			<div class="row mb-4">
				<div class="col-12">
					<div class="card report-card shadow-sm">
						<div class="card-header bg-white border-0 pt-3 pb-0 d-flex justify-content-between align-items-center">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-list mr-2"></i><?= tr("Stock Items") ?>
								<?php if ($selected_branch != 'all'): ?>
								<small class="text-muted">- <?= escap($branch_stats[$selected_branch]['name'] ?? '') ?></small>
								<?php endif ?>
							</h5>
						</div>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table table-report table-hover mb-0" id="stock-table">
									<thead>
										<tr>
											<th class="pl-3">#</th>
											<th><?= tr("Item Name") ?></th>
											<th><?= tr("Category") ?></th>
											<th class="text-center"><?= tr("Quantity") ?></th>
											<th class="text-right"><?= tr("Cost") ?></th>
											<th class="text-right"><?= tr("Value") ?></th>
											<th class="text-center pr-3"><?= tr("Status") ?></th>
										</tr>
									</thead>
									<tbody>
										<?php foreach ($stock_items as $index => $item): ?>
										<?php 
										$qty = floatval($item['total_qty']);
										$alert = floatval($item['alert']);
										$value = $qty * floatval($item['cost']);
										$status = 'ok';
										if ($alert > 0) {
											if ($qty <= 0) $status = 'critical';
											elseif ($qty <= $alert) $status = 'low';
										}
										?>
										<tr>
											<td class="pl-3"><?= $index + 1 ?></td>
											<td>
												<strong><?= escap($item['name']) ?></strong>
											</td>
											<td><span class="badge badge-light"><?= escap($item['category_name']) ?></span></td>
											<td class="text-center">
												<span class="font-weight-bold <?= $status == 'critical' ? 'text-danger' : ($status == 'low' ? 'text-warning' : '') ?>">
													<?= number_format($qty) ?>
												</span>
												<?php if ($alert > 0): ?>
												<small class="text-muted">/ <?= $alert ?></small>
												<?php endif ?>
											</td>
											<td class="text-right"><?= amount($item['cost']) ?></td>
											<td class="text-right font-weight-bold"><?= amount($value) ?></td>
											<td class="text-center pr-3">
												<?php if ($status == 'critical'): ?>
												<span class="badge badge-danger"><i class="fas fa-times-circle"></i> <?= tr("Out") ?></span>
												<?php elseif ($status == 'low'): ?>
												<span class="badge badge-warning"><i class="fas fa-exclamation-circle"></i> <?= tr("Low") ?></span>
												<?php else: ?>
												<span class="badge badge-success"><i class="fas fa-check-circle"></i> <?= tr("OK") ?></span>
												<?php endif ?>
											</td>
										</tr>
										<?php endforeach ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Categories Summary -->
			<div class="row mb-4">
				<div class="col-12">
					<div class="card report-card shadow-sm">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-folder mr-2"></i><?= tr("Categories Summary") ?>
							</h5>
						</div>
						<div class="card-body">
							<div class="row">
								<?php foreach ($categories as $cat): ?>
								<div class="col-md-4 col-lg-3 mb-3">
									<div class="d-flex align-items-center p-3 bg-light rounded">
										<div class="mr-3">
											<span class="badge badge-primary badge-pill px-3 py-2"><?= $cat['item_count'] ?></span>
										</div>
										<div>
											<strong><?= escap($cat['name']) ?></strong>
											<br><small class="text-muted"><?= tr("items") ?></small>
										</div>
									</div>
								</div>
								<?php endforeach ?>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>
	</div>

	<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>

	<script>
		$(document).ready(function() {
			$('#stock-table').DataTable({
				pageLength: 25,
				order: [[1, 'asc']],
				language: {
					search: '<?= tr("Search") ?>:',
					lengthMenu: '<?= tr("Show") ?> _MENU_',
					paginate: {
						first: '<?= tr("First") ?>',
						last: '<?= tr("Last") ?>',
						next: '<?= tr("Next") ?>',
						previous: '<?= tr("Previous") ?>'
					}
				}
			});
		});
	</script>

</body>
</html>

