<?php

// Create new request
if (isset($_POST['new']) && $tk->passes()) {

	$notes = isset($_POST['notes'])?$_POST['notes']:'';
	$list = isset($_POST['list'])?$_POST['list']:'[]';
	$branch_id = branch()->id();

	if (is_json($list)) {
		$list = json_decode($list,true);
	}else{
		$list = [];
	}

	$v->validate([
		tr("Items")=>[count($list)>0?"valid":"","required"],
	]);

	if ($v->passes()) {

		$db->query("INSERT INTO stock_order_requests(branch_id, notes, created_by) VALUES(?,?,?)",
			[$branch_id, $notes, auth()->id]);

		$request_id = $db->lastInsertId();

		foreach ($list as $item) {
			if ($item['p_id'] > 0 && $item['qty'] > 0) {
				$db->query(
					"INSERT INTO stock_order_requests_data(request_id, product_id, qty, notes) VALUES (?,?,?,?)",
					[$request_id, $item['p_id'], $item['qty'], $item['notes'] ?? '']
				);
			}
		}

		$display->success(tr("Request created successfully."));
		$redirect->to(add_to_url($this_url,["v","i"],["view",$request_id]));
	}
}

// Update/Edit request
if (isset($_POST['edit']) && $tk->passes() && can("manage-stock-requests")) {

	$id = isset($_POST['id'])?$_POST['id']:'';
	$notes = isset($_POST['notes'])?$_POST['notes']:'';
	$list = isset($_POST['list'])?$_POST['list']:'[]';

	$v->validate([
		tr("ID")=>[$id,"required|number"],
	]);

	if (is_json($list)) {
		$list = json_decode($list,true);
	}else{
		$list = [];
	}

	$v->validate([
		tr("Items")=>[count($list)>0?"valid":"","required"],
	]);

	if ($v->passes()) {
		// Check if request exists and is still pending or approved
		$request = $db->row("SELECT * FROM stock_order_requests WHERE id = ? AND deleted_01=0", [$id]);
		
		if ($request && in_array($request['status'], ['pending', 'approved'])) {
			// Update request notes
			$db->query("UPDATE stock_order_requests SET notes=?, updated_by=? WHERE id=?",
				[$notes, auth()->id, $id]);

			// Mark all existing items as deleted
			$db->query("UPDATE stock_order_requests_data SET deleted_01=1 WHERE request_id=?", [$id]);

			// Insert new items
			foreach ($list as $item) {
				if ($item['p_id'] > 0 && $item['qty'] > 0) {
					$db->query(
						"INSERT INTO stock_order_requests_data(request_id, product_id, qty, notes) VALUES (?,?,?,?)",
						[$id, $item['p_id'], $item['qty'], $item['notes'] ?? '']
					);
				}
			}

			$display->success(tr("Request updated successfully."));
			$redirect->to(add_to_url($this_url,["v","i"],["view",$id]));
		} else {
			$display->error(tr("Only pending or approved requests can be edited."));
		}
	}
}

// Update request status
if (isset($_POST['update_status']) && $tk->passes() && can("manage-stock-requests")) {

	$id = isset($_POST['id'])?$_POST['id']:'';
	$status = isset($_POST['status'])?$_POST['status']:'';

	$v->validate([
		tr("ID")=>[$id,"required|number"],
		tr("Status")=>[$status,"required"],
	]);

	$valid_statuses = ['pending', 'approved', 'rejected'];

	if ($v->passes() && in_array($status, $valid_statuses)) {
		$db->query("UPDATE stock_order_requests SET status=?, updated_by=? WHERE id=?",
			[$status, auth()->id, $id]);
		$display->success(tr("Request status updated successfully."));
	}
}

// Delete request
if (isset($_POST['delete']) && $tk->passes()) {
	$id = isset($_POST['id'])?$_POST['id']:'';
	
	$v->validate([
		tr("ID")=>[$id,"required|number"],
	]);

	if ($v->passes()) {
		// Check if user owns this request or has manage permission
		$request = $db->row("SELECT * FROM stock_order_requests WHERE id = ?", [$id]);
		
		if ($request && ($request['created_by'] == auth()->id || can("manage-stock-requests"))) {
			if ($request['status'] == 'pending') {
				$db->query("UPDATE stock_order_requests SET deleted_01=1, updated_by=? WHERE id=?",
					[auth()->id, $id]);
				$display->success(tr("Request deleted successfully."));
				$redirect->to(remove_from_url($this_url,["i","v"]));
			} else {
				$display->error(tr("Only pending requests can be deleted."));
			}
		}
	}
}

$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';

$page=[
	"title"=>tr("Stock Requests"),
	"active"=>"requests"
];

switch ($view) {
	case 'new':
		
		$user->authorize("create-stock-requests|manage-stock-requests");
		
		$page_nav=[
			"breadcrumb"=>[
				tr("Stock Requests")=>$app_url."/inventory/requests/",
				tr("New")=>$app_url."/inventory/requests/?v=new",
			],
		];

		$page['class']=" sidebar-xs ";
		$page_view = "views/new.php";
	break;

	case 'view':
		
		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM stock_order_requests WHERE id = ? AND deleted_01=0",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}

			// Check permission - user can view their own requests or if they have manage permission
			if ($data['created_by'] != auth()->id && !can("manage-stock-requests")) {
				$redirect->to(404);
			}

			$items = $db->query("SELECT d.*, p.name as product_name FROM stock_order_requests_data d 
				LEFT JOIN stock_poroducts p ON p.id = d.product_id 
				WHERE d.request_id = ? AND d.deleted_01=0", [$data['id']]);

			$page_nav=[
				"breadcrumb"=>[
					tr("Stock Requests")=>$app_url."/inventory/requests/",
					tr("View")." #".$data['id']=>"",
				],
			];

			$page_view = "views/view.php";
		} else {
			$redirect->to(404);
		}

	break;

	case 'edit':
		
		$user->authorize("manage-stock-requests");
		
		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM stock_order_requests WHERE id = ? AND deleted_01=0",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}

			// Only pending or approved requests can be edited
			if (!in_array($data['status'], ['pending', 'approved'])) {
				$display->error(tr("Only pending or approved requests can be edited."));
				$redirect->to(add_to_url($this_url,["v","i"],["view",$data['id']]));
			}

			$items = $db->query("SELECT d.*, p.name as product_name FROM stock_order_requests_data d 
				LEFT JOIN stock_poroducts p ON p.id = d.product_id 
				WHERE d.request_id = ? AND d.deleted_01=0", [$data['id']]);

			// Format items for Vue.js
			$items_list = [];
			foreach ($items as $item) {
				$items_list[] = [
					'p_id' => $item['product_id'],
					'name' => $item['product_name'],
					'qty' => $item['qty'],
					'notes' => $item['notes'] ?? ''
				];
			}

			$page_nav=[
				"breadcrumb"=>[
					tr("Stock Requests")=>$app_url."/inventory/requests/",
					tr("Edit")." #".$data['id']=>"",
				],
			];

			$page['class']=" sidebar-xs ";
			$page_view = "views/edit.php";
		} else {
			$redirect->to(404);
		}

	break;
	
	default:

		$from = date("Y-m-d H:i",strtotime("-3 months"));
		$to = date("Y-m-d H:i");

		if (isset($_GET['from'])) {
		  $from = date("Y-m-d H:i",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d H:i",strtotime($_GET['to']));
		}

		$status_filter = isset($_GET['status']) ? $_GET['status'] : 'all';
		
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Stock Requests")=>$app_url."/inventory/requests",
			],
			"date_filter"=>[
				"from"=>$from,
				"to"=>$to
			],
		];

		// Build query based on permissions
		$where_conditions = "deleted_01=0 AND date(created_at) >= date(?) AND date(created_at) <= date(?)";
		$params = [$from, $to];

		// If user doesn't have manage permission, only show their own requests
		if (!can("manage-stock-requests")) {
			$where_conditions .= " AND created_by = ?";
			$params[] = auth()->id;
		}

		// Status filter
		if ($status_filter != 'all' && in_array($status_filter, ['pending', 'approved', 'rejected', 'converted'])) {
			$where_conditions .= " AND status = ?";
			$params[] = $status_filter;
		}

		$list = $db->query("SELECT * FROM stock_order_requests WHERE $where_conditions ORDER BY id DESC", $params);

		$page_view = "views/index.php";

	break;
}

