<?php
	$status_options = [
		'all' => tr('All'),
		'pending' => tr('Pending'),
		'approved' => tr('Approved'),
		'rejected' => tr('Rejected'),
		'converted' => tr('Converted')
	];

	$status_badges = [
		'pending' => 'warning',
		'approved' => 'success',
		'rejected' => 'danger',
		'converted' => 'info'
	];
?>

<div class="card shadow">
	<div class="card-header d-flex justify-content-between align-items-center bg-primary">
		<h3><?= tr("Stock Requests") ?></h3>
		<div class="d-flex gap-2">
			<div class="dropdown me-2">
				<button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown">
					<?= tr("Status") ?>: <?= $status_options[$status_filter] ?>
				</button>
				<ul class="dropdown-menu">
					<?php foreach ($status_options as $key => $label): ?>
					<li>
						<a class="dropdown-item <?= $status_filter == $key ? 'active' : '' ?>" 
						   href="<?= add_to_url($this_url, 'status', $key) ?>">
							<?= $label ?>
						</a>
					</li>
					<?php endforeach ?>
				</ul>
			</div>
			<?php if (can("create-stock-requests")): ?>
			<a href="<?= add_to_url($this_url,"v","new") ?>" class="btn btn-light px-3 rounded-pill">
				<i class="fas fa-plus me-1"></i> <?= tr("New Request") ?>
			</a>
			<?php endif ?>
		</div>
	</div>
	<table class="table" id="datatable-tabletools">
		<thead>
			<tr>
				<th><?= tr("No.") ?></th>
				<th><?= tr("Date") ?></th>
				<th><?= tr("Branch") ?></th>
				<th><?= tr("Items") ?></th>
				<th><?= tr("Status") ?></th>
				<th><?= tr("Created by") ?></th>
				<th class="text-center"><?= tr("Action") ?></th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ($list as $key => $item): ?>
				<?php 
					$item_count = $db->single("SELECT COUNT(*) FROM stock_order_requests_data WHERE request_id = ? AND deleted_01=0", [$item['id']]);
					$branch_name = $db->single("SELECT name FROM branches WHERE id = ?", [$item['branch_id']]);
				?>
				<tr>
					<td><?= $item['id'] ?></td>
					<td><?= date("Y-m-d H:i", strtotime($item['created_at'])) ?></td>
					<td><?= escap($branch_name) ?></td>
					<td class="text-center"><?= $item_count ?></td>
					<td>
						<span class="badge bg-<?= $status_badges[$item['status']] ?? 'secondary' ?>">
							<?= tr(ucfirst($item['status'])) ?>
						</span>
						<?php if ($item['status'] == 'converted' && $item['purchase_id']): ?>
							<a href="<?= $app_url ?>/inventory/purchases/?v=edit&i=<?= $item['purchase_id'] ?>" 
							   class="badge bg-primary text-decoration-none" title="<?= tr('View Purchase') ?>">
								#<?= $item['purchase_id'] ?>
							</a>
						<?php endif ?>
					</td>
					<td><?= escap($user->get($item['created_by'])->name) ?></td>
					<td class="text-center">
						<a href="<?= add_to_url($this_url,["v","i"],["view",$item['id']]) ?>" 
						   class="btn btn-sm btn-light btn-action">
							<?= tr("View") ?>
						</a>
						<?php if (can("manage-stock-requests") && in_array($item['status'], ['pending', 'approved'])): ?>
						<a href="<?= add_to_url($this_url,["v","i"],["edit",$item['id']]) ?>" 
						   class="btn btn-sm btn-warning btn-action">
							<?= tr("Edit") ?>
						</a>
						<?php endif ?>
					</td>
				</tr>
			<?php endforeach ?>
		</tbody>
	</table>
</div>

<script>
	$(document).ready(function() {
		var $table = $('#datatable-tabletools');
		var table = $table.dataTable({
			language: {
				search: '<span></span> _INPUT_',
				searchPlaceholder: '<?= tr("Search") ?>',
				lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
				paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
			},
			"lengthMenu": [
				[25, 100, 500, 1000],
				[25, 100, 500, 1000]
			],
			"order": [[0, "desc"]],
			"columnDefs": [
				{ "orderable": false, "targets": [6] },
			],
			dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
			responsive: true,
			autoWidth: false,
			buttons: {
				dom: {
					button: {
						className: 'btn btn-light border'
					}
				},
				buttons: [
					{
						extend: 'csv',
						exportOptions: {
							stripHtml: 1,
							columns: [0, 1, 2, 3, 4, 5]
						}
					},
					{
						extend: 'pdf',
						exportOptions: {
							stripHtml: 1,
							columns: [0, 1, 2, 3, 4, 5]
						}
					},
					{
						extend: 'print',
						exportOptions: {
							stripHtml: 1,
							columns: [0, 1, 2, 3, 4, 5]
						}
					},
				],
			},
		});
	});
</script>

