<div class="row justify-content-center" id="app">
	<div class="col-md-10">
		<form method="post" enctype="multipart/form-data">
			<div class="card shadow">
				<div class="card-header bg-primary">
					<h3><?= tr("New Stock Request") ?></h3>
				</div>
				<div class="card-body">
					
					<div class="row mb-3">
						<div class="col-md-4">
							<label for=""><?= tr("Created by") ?></label>
							<input type="text" class="form-control" value="<?= escap(auth()->name) ?>" disabled>
						</div>
						<div class="col-md-4">
							<label for=""><?= tr("Branch") ?></label>
							<input type="text" class="form-control" value="<?= escap(branch()->name()) ?>" disabled>
						</div>
						<div class="col-md-4">
							<label for=""><?= tr("Date") ?></label>
							<input type="text" class="form-control" value="<?= date("Y-m-d") ?>" disabled>
						</div>
					</div>

					<div class="row mb-3">
						<div class="col-md-12">
							<label for=""><?= tr("Notes") ?></label>
							<textarea name="notes" class="form-control" rows="2" placeholder="<?= tr("Optional notes or reason for this request") ?>"><?= old("notes") ?></textarea>
						</div>
					</div>
					
					<hr>
					
					<div class="row mb-3">
						<div class="col-md-6">
							<label><?= tr("Search Items") ?></label>
							<div class="input-group">
								<input type="search" class="form-control search-input" placeholder="<?= tr("Type to search items...") ?>">
								<div class="input-group-append">
									<span class="input-group-text"><i class="fas fa-search"></i></span>
								</div>
							</div>
						</div>
					</div>

					<div class="table-responsive">
						<table class="table table-sm table-striped border">
							<thead class="bg-light">
								<tr>
									<th style="width: 50px">#</th>
									<th><?= tr("Item") ?></th>
									<th style="width: 150px"><?= tr("Quantity") ?></th>
									<th style="width: 200px"><?= tr("Notes") ?></th>
									<th style="width: 60px"></th>
								</tr>
							</thead>
							<tbody>
								<tr v-for="(item, index) in items" :key="index">
									<td class="text-center">{{ index + 1 }}</td>
									<td>{{ item.name }}</td>
									<td>
										<input type="number" required min="1" v-model="item.qty" class="form-control form-control-sm text-center">
									</td>
									<td>
										<input type="text" v-model="item.notes" class="form-control form-control-sm" placeholder="<?= tr("Optional") ?>">
									</td>
									<td class="text-center">
										<button type="button" class="btn btn-sm btn-danger" @click="removeItem(index)">
											<i class="fas fa-times"></i>
										</button>
									</td>
								</tr>
								<tr v-if="items.length == 0">
									<td colspan="5" class="text-center text-muted py-4">
										<?= tr("No items added yet. Use the search above to add items.") ?>
									</td>
								</tr>
							</tbody>
							<tfoot v-if="items.length > 0">
								<tr class="bg-light">
									<th colspan="2" class="text-end"><?= tr("Total Items") ?>:</th>
									<th class="text-center">{{ totalQty }}</th>
									<th colspan="2"></th>
								</tr>
							</tfoot>
						</table>
					</div>

				</div>
				<div class="card-footer text-end">
					<a href="<?= $app_url ?>/inventory/requests/" class="btn btn-secondary rounded-pill px-3"><?= tr("Cancel") ?></a>
					<button class="btn btn-primary rounded-pill px-3" name="new" :disabled="items.length == 0"><?= tr("Submit Request") ?></button>
				</div>
			</div>

			<input type="hidden" name="list" :value="JSON.stringify(items)">
		</form>
	</div>
</div>

<script>
	let app = new Vue({
		el: "#app",
		data: {
			items: <?= old("list", "[]") ?>
		},
		methods: {
			addItem(data) {
				// Check if item already exists
				let existing = this.items.find(item => item.p_id == data.id);
				if (existing) {
					existing.qty = parseInt(existing.qty) + 1;
				} else {
					this.items.push({
						p_id: data.id,
						name: data.name,
						qty: 1,
						notes: ''
					});
				}
			},
			removeItem(index) {
				this.items.splice(index, 1);
			}
		},
		computed: {
			totalQty() {
				return this.items.reduce((sum, item) => sum + parseInt(item.qty || 0), 0);
			}
		}
	});

	$(document).ready(function() {
		$(".search-input").autocomplete({
			minLength: 2,
			delay: 500,
			source: function(request, response) {
				var term = request.term;
				$.get('<?= $app_url ?>/inventory/requests/ajax/?f=search&search=' + term, function(data) {
					response(data);
				}, 'json');
			},
			select: function(event, ui) {
				app.addItem(ui.item);
				$(this).val('');
				return false;
			},
			search: function() {
				$(this).parent().addClass('ui-autocomplete-processing');
			},
			open: function() {
				$(this).parent().removeClass('ui-autocomplete-processing');
			}
		}).autocomplete('instance')._renderItem = function(ul, item) {
			return $('<li>').append(
				'<div class="p-2"><span class="text-muted">#' + item.id + '</span> - <strong>' + item.name + '</strong></div>'
			).appendTo(ul);
		};
	});
</script>

