<?php
	$status_badges = [
		'pending' => 'warning',
		'approved' => 'success', 
		'rejected' => 'danger',
		'converted' => 'info'
	];

	$branch_name = $db->single("SELECT name FROM branches WHERE id = ?", [$data['branch_id']]);
	$creator = $user->get($data['created_by']);
?>

<div class="row justify-content-center">
	<div class="col-md-10">
		<div class="card shadow">
			<div class="card-header bg-primary d-flex justify-content-between align-items-center">
				<h3><?= tr("Stock Request") ?> #<?= $data['id'] ?></h3>
				<span class="badge bg-<?= $status_badges[$data['status']] ?? 'secondary' ?> fs-6">
					<?= tr(ucfirst($data['status'])) ?>
				</span>
			</div>
			<div class="card-body">
				
				<div class="row mb-4">
					<div class="col-md-3">
						<label class="text-muted small"><?= tr("Created by") ?></label>
						<p class="mb-0 fw-bold"><?= escap($creator->name) ?></p>
					</div>
					<div class="col-md-3">
						<label class="text-muted small"><?= tr("Branch") ?></label>
						<p class="mb-0 fw-bold"><?= escap($branch_name) ?></p>
					</div>
					<div class="col-md-3">
						<label class="text-muted small"><?= tr("Date") ?></label>
						<p class="mb-0 fw-bold"><?= date("Y-m-d H:i", strtotime($data['created_at'])) ?></p>
					</div>
					<div class="col-md-3">
						<label class="text-muted small"><?= tr("Status") ?></label>
						<p class="mb-0">
							<span class="badge bg-<?= $status_badges[$data['status']] ?? 'secondary' ?>">
								<?= tr(ucfirst($data['status'])) ?>
							</span>
						</p>
					</div>
				</div>

				<?php if (!empty($data['notes'])): ?>
				<div class="row mb-4">
					<div class="col-12">
						<label class="text-muted small"><?= tr("Notes") ?></label>
						<p class="mb-0"><?= nl2br(escap($data['notes'])) ?></p>
					</div>
				</div>
				<?php endif ?>

				<?php if ($data['status'] == 'converted' && $data['purchase_id']): ?>
				<div class="alert alert-info">
					<i class="fas fa-info-circle me-2"></i>
					<?= tr("This request has been converted to") ?> 
					<a href="<?= $app_url ?>/inventory/purchases/?v=edit&i=<?= $data['purchase_id'] ?>" class="alert-link">
						<?= tr("Purchase") ?> #<?= $data['purchase_id'] ?>
					</a>
				</div>
				<?php endif ?>

				<hr>

				<h5 class="mb-3"><?= tr("Requested Items") ?></h5>
				<div class="table-responsive">
					<table class="table table-sm table-striped border">
						<thead class="bg-light">
							<tr>
								<th style="width: 50px">#</th>
								<th><?= tr("Item") ?></th>
								<th style="width: 120px" class="text-center"><?= tr("Quantity") ?></th>
								<th><?= tr("Notes") ?></th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($items as $index => $item): ?>
							<tr>
								<td class="text-center"><?= $index + 1 ?></td>
								<td>
									<strong><?= escap($item['product_name']) ?></strong>
									<small class="text-muted">(#<?= $item['product_id'] ?>)</small>
								</td>
								<td class="text-center"><?= $item['qty'] ?></td>
								<td><?= escap($item['notes']) ?></td>
							</tr>
							<?php endforeach ?>
						</tbody>
						<tfoot>
							<tr class="bg-light">
								<th colspan="2" class="text-end"><?= tr("Total Items") ?>:</th>
								<th class="text-center">
									<?= array_sum(array_column($items, 'qty')) ?>
								</th>
								<th></th>
							</tr>
						</tfoot>
					</table>
				</div>

			</div>
			<div class="card-footer">
				<div class="d-flex justify-content-between">
					<div>
						<a href="<?= $app_url ?>/inventory/requests/" class="btn btn-secondary rounded-pill px-3">
							<i class="fas fa-arrow-left me-1"></i> <?= tr("Back") ?>
						</a>
					</div>
					<div class="d-flex gap-2">
						<?php if (can("manage-stock-requests") && $data['status'] == 'pending'): ?>
							<!-- Status update buttons -->
							<form method="post" class="d-inline">
								<input type="hidden" name="id" value="<?= $data['id'] ?>">
								<input type="hidden" name="status" value="approved">
								<button type="submit" name="update_status" class="btn btn-success rounded-pill px-3">
									<i class="fas fa-check me-1"></i> <?= tr("Approve") ?>
								</button>
							</form>
							<form method="post" class="d-inline">
								<input type="hidden" name="id" value="<?= $data['id'] ?>">
								<input type="hidden" name="status" value="rejected">
								<button type="submit" name="update_status" class="btn btn-danger rounded-pill px-3">
									<i class="fas fa-times me-1"></i> <?= tr("Reject") ?>
								</button>
							</form>
						<?php endif ?>

						<?php if (can("manage-stock-requests") && in_array($data['status'], ['pending', 'approved'])): ?>
							<!-- Edit button -->
							<a href="<?= $app_url ?>/inventory/requests/?v=edit&i=<?= $data['id'] ?>" 
							   class="btn btn-warning rounded-pill px-3">
								<i class="fas fa-edit me-1"></i> <?= tr("Edit") ?>
							</a>
						<?php endif ?>

						<?php if (can("manage-stock-requests") && in_array($data['status'], ['pending', 'approved'])): ?>
							<!-- Convert to purchase button -->
							<a href="<?= $app_url ?>/inventory/purchases/?v=new&from_request=<?= $data['id'] ?>" 
							   class="btn btn-primary rounded-pill px-3">
								<i class="fas fa-shopping-cart me-1"></i> <?= tr("Convert to Purchase") ?>
							</a>
						<?php endif ?>

						<?php if ($data['status'] == 'pending' && ($data['created_by'] == auth()->id || can("manage-stock-requests"))): ?>
							<!-- Delete button -->
							<form method="post" class="d-inline" onsubmit="return confirm('<?= tr("Are you sure you want to delete this request?") ?>')">
								<input type="hidden" name="id" value="<?= $data['id'] ?>">
								<button type="submit" name="delete" class="btn btn-outline-danger rounded-pill px-3">
									<i class="fas fa-trash me-1"></i> <?= tr("Delete") ?>
								</button>
							</form>
						<?php endif ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

