<?php 
	$root="..";
	require($root."/php/init.php");
	$page=[
		'title'=>$conf->get("App.name"),
		"active"=>"suppliers"
	];

	$page_nav=[
		"breadcrumb"=>[
			tr("Suppliers")=>""
		]
	];

	if (isset($_POST['new_inv_sup'])) {
		$v->validate([
			"Supplier Name"=>[$_POST['name'],'required']
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("INSERT INTO stock_suppliers (name, phone, note, added_by) VALUES (?,?,?,?)",[$_POST['name'], $_POST['phone'], $_POST['note'],auth()->id]);

		}
	}

	if (isset($_POST['save_inv_sup'])) {
		$v->validate([
			"Supplier Name"=>[$_POST['name'],'required'],
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("UPDATE stock_suppliers SET name = ?, phone = ?, note = ? WHERE id = ?",[$_POST['name'], $_POST['phone'], $_POST['note'],$_POST['id']]);

		}
	}

	if (isset($_POST['delete_inv_sup'])) {
		$v->validate([
			"ID"=>[$_POST['id'],'required'],
		]);

		if ($v->passes() && $tk->passes()) {
			$db->query("UPDATE stock_suppliers SET deleted_01=1 WHERE id = ?",[$_POST['id']]);

		}
	}

	$display->error($v->errors()->all(),"error");

	$view="index";

	if (isset($_GET['v'])) {
		$view=$_GET['v'];
	}

	if (isset($_GET['i'])) {
		$data = $db->row("SELECT * FROM stock_suppliers WHERE id = ? ",[$_GET['i']]);
		if (!$data) {
			$redirect->to(404);
		}

	}

	$list = $db->query("SELECT * FROM stock_suppliers WHERE deleted_01=0");


 ?>
<!DOCTYPE html>
<html <?= $local ?>>
	<?php require($root."/inc/head.php") ?>
	
	<body class=" <?= isset($page['class'])?$page['class']:'' ?> " >
		<?php require($root."/inc/header.php") ?>

			<div class="row">
				<div class="col-md-8 my-1">
					<div class="card">
						<div class="card-header ">
							<div class="row">
								<div class="col-md-6 ">
									<h5><?= tr("Suppliers") ?></h5>
								</div>
								<div class="col-md-6 text-end">
									<a href="<?= add_to_url($this_url,["v"],["new"]) ?>" title="New" class="btn btn-primary"><i class="fas fa-plus"></i></a>
								</div>
							</div>
						</div>
						
							<table class="table table-sm  table-responsive-md v-align-center mb-0 table-borderless table-striped" id="datatable-tabletools">
								<thead>
									<tr>
										<th><?= tr("Name") ?></th>
										<th><?= tr("phone") ?></th>
										<th class="text-center">!</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach ($list as $key => $sup): ?>
										<tr>
											<td><?= escap($sup['name']) ?></td>
											<td><?= escap($sup['phone']) ?></td>
											<td class="text-center">
												<a href="<?= add_to_url($this_url,["v","i"],["view",$sup['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-search"></i></a>
												<a href="<?= add_to_url($this_url,["v","i"],["edit",$sup['id']]) ?>" class="btn btn-light btn-sm"><i class="fas fa-pen"></i></a>
												<a href="<?= add_to_url($this_url,["v","i"],["delete",$sup['id']]) ?>" class="btn btn-light btn-sm"><i class="far fa-trash-alt"></i></a>
											</td>
										</tr>
									<?php endforeach ?>
									
								</tbody>
							</table>
					
						
					</div>
				</div>

				<div class="col-md-4 my-1">
					<?php if ($view=="new"): ?>
						<form method="post" action="<?= remove_from_url($this_url,["v"]) ?>">
							<div class="card">
								<div class="card-header">
									<h5><?= tr("New") ?></h5>
								</div>
								<div class="card-body">
									<div class="form-group">
										<label for=""><?= tr("Name") ?></label>
										<input type="text" class="form-control" name="name">
										<br>
										<label for=""><?= tr("Phone") ?></label>
										<input type="text" class="form-control" name="phone">
										<br>
										<label for=""><?= tr("Note") ?></label>
										<textarea name="note" class="form-control" cols="30" rows="3"></textarea>
									</div>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-primary" type="submit" name="new_inv_sup"><?= tr("Submit") ?></button>
								</div>
							</div>
						</form>
					<?php elseif($view=="view"): ?>
						<div class="card">
							<div class="card-header">
								<h5><?= $data['name'] ?></h5>
							</div>
							<div class="card-body">
								<h6><?= tr("Name") ?>:</h6>
								<p><?= escap($data['name']) ?></p>

								<h6><?= tr("Phone") ?>:</h6>
								<p><?= escap($data['phone']) ?></p>

								<h6><?= tr("Note") ?>:</h6>
								<p><?= nl2br(escap($data['note'])) ?></p>

							
							</div>
						
						</div>
					<?php elseif($view=="edit"): ?>
						<form method="post" >
							<div class="card">
								<div class="card-header">
									<h5><?= $data['name'] ?></h5>
								</div>
								<div class="card-body">
									<div class="form-group">
										<label for=""><?= tr("Name") ?></label>
										<input type="text" class="form-control" name="name" value="<?= escap($sup['name']) ?>">
										<br>
										<label for=""><?= tr("Phone") ?></label>
										<input type="text" class="form-control" name="phone" value="<?= escap($sup['phone']) ?>">
										<br>
										<label for=""><?= tr("Note") ?></label>
										<textarea name="note" class="form-control" cols="30" rows="3"><?= escap($sup['note']) ?></textarea>
									</div>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-primary" type="submit" name="save_inv_sup"><?= tr("Save") ?></button>
								</div>
							</div>

							<input type="text" hidden="" name="id" value="<?= $sup['id'] ?>">
						</form>
					<?php elseif($view=="delete"): ?>
						<form method="post" action="<?= remove_from_url($this_url,["v"]) ?>">
							<div class="card">
								<div class="card-header">
									<h5>Are you sure?</h5>
								</div>
								<div class="card-body">
									<p>This Supplier will be deleted.</p>
									<h6>Name:</h6>
									<p><?= escap($sup['name']) ?></p>
								</div>
								<div class="card-footer text-end">
									<button class="btn btn-danger" type="submit" name="delete_inv_sup">Yes</button>
								</div>
							</div>

							<input type="text" hidden="" name="id" value="<?= $sup['id'] ?>">
						</form>
					<?php endif ?>
				</div>
			</div>


			<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>





	</body>
</html>