<?php 

$v = new Classes\Validator;

if (isset($_POST['new_item']) && $v->passes()) {
	
	$name        =isset($_POST['name'])?$_POST['name']:"";
	$category_id        =isset($_POST['category_id'])?$_POST['category_id']:"";


	$v->validate([
		tr("Name")=>[$name,"required"],
	]);


	if ($tk->passes() ) {
		$db->query("INSERT INTO items(name,category_id,created_by) VALUES(?,?,?)",[$name,$category_id,auth()->id]);

		$display->success(tr("Item created successfully."));

		$redirect->to($app_url."/items");
	}
}

if (isset($_POST['save_item']) && $v->passes()) {
	
	$name        =isset($_POST['name'])?$_POST['name']:"";

	$id=isset($_POST['id'])?$_POST['id']:"";



	$v->validate([
		tr("Name")=>[$name,"required"],
		"ID"=>[$id,"required|number"],
	]);


	if ($tk->passes() ) {

		$db->query("UPDATE  items SET name=? WHERE id= ?",[$name,$id]);

		$display->success(tr("Item updated successfully."));
	}
}


if (isset($_POST['delete_item']) && $v->passes()) {
	$id=isset($_POST['id'])?$_POST['id']:"";



	$v->validate([
		"ID"=>[$id,"required|number"],
	]);

	if ($tk->passes() ) {

		$db->query("UPDATE  items SET deleted_01=1 WHERE id= ?",[$id]);
		
		$display->success(tr("Item deleted successfully."));

		$redirect->to($app_url."/items");
		
	}
}






$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':
		$page_nav=[
			"back"=>$app_url."/items/",
			"breadcrumb"=>[
				tr("Taxes")=>$app_url."/items/",
				tr("New")=>"",
			],
		];
		$page_view = "views/new.php";
	break;

	case 'edit':
		$page_nav=[
			"back"=>$app_url."/items/",
			"breadcrumb"=>[
				tr("Items")=>$app_url."/items/",
				tr("Edit")=>"",
			],
		];


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM items WHERE id = ? ",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}


		$page_view = "views/edit.php";
	break;


	case 'view':
		$page_nav=[
			"back"=>$app_url."/items/",
			"breadcrumb"=>[
				tr("Items")=>$app_url."/items/",
				tr("View")=>"",
			],
		];


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM items WHERE id = ? ",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}


		$page_view = "views/view.php";
	break;
	
	default:
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Items")=>$app_url."/items/",
			],
		];

		$list = $db->query("SELECT * FROM items WHERE deleted_01=0");

		$page_view = "views/index.php";
	break;
}