<?php



if (isset($_POST['cancel']) && can("manage-orders")) {
	$id = isset($_POST['id'])?$_POST['id']:'';
	$v->validate([
		tr("ID")=>[$id,"required"],
	]);

	if ($v->passes() && $tk->passes()) {

		$db->query("UPDATE orders SET status = 'Canceled', updated_by=? WHERE id=? ",[auth()->id,$id]);
		$db->query("UPDATE payments SET deleted_01=1 WHERE order_id=? ",[$id]);
		$display->success(tr("Order canceled successfully."));
		$redirect->to(remove_from_url($this_url,["i","v"]));
	}
		
}

$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';

$page=[
	"title"=>tr("Orders"),
	"active"=>"orders"
];

switch ($view) {
	case 'new':
		
		$page_nav=[
			"breadcrumb"=>[
				tr("Orders")=>$app_url."/dishes",
				tr("New")=>$app_url."/dishes",
			],
		];
		$page_view = "views/new.php";
	break;

	case 'view':
		
			$page_nav=[
				"breadcrumb"=>[
					tr("Orders")=>$app_url."/orders",
					tr("View")=>$app_url."/orders",
				],
			];
			

			if (isset($_GET['i']) && is_numeric($_GET['i'])) {
				$data = $db->row("SELECT * FROM orders WHERE id = ? ",[$_GET['i']]);

				if (!$data) {
					$redirect->to(404);
				}

				$payment = $db->row("SELECT * FROM payments WHERE order_id = ? ",[$data['id']]);
			}


			$page_view = "views/view.php";
		

	
	break;
	
	default:

		$from = date("Y-m-d H:i:s",strtotime("-2 week"));
		$to   = date("Y-m-d H:i:s");



		if (isset($_GET['from'])) {
		  $from = date("Y-m-d H:i:s",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("Y-m-d H:i:s",strtotime($_GET['to']));
		}
		// echo timestamp();
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Orders")=>$app_url."/orders",
			],
			"date_filter"=>[
				"from"=>$from,
				"to"=>$to
			],
			"branch"=>1
			
		];


		$list = $db->query("SELECT * FROM  orders  WHERE  deleted_01=0 and date(created_at)>= date(?) AND date(created_at)<=date(?) AND ".branch()->query("branch_id")."  ORDER BY id DESC",[$from,$to]);


		$page_view = "views/index.php";

	break;
}