<?php 

header('Access-Control-Allow-Origin: *'); 
require_once(__DIR__.'/../php/init.php');


// storing  request (ie, get/post) global array to a variable  
$requestData= $_REQUEST;
$columns = array( 
// datatable column index  => database column name
	0 => 'orders.id', 
	1 => 'orders.created_at',
	2 => 'orders.created_at',
	3 => 'users.name',
	4 => 'branches.name',
	5 => 'payments.method',
	6 => 'type',
	7 => 'status',
	
);


$from = date("Y-m-d",strtotime("-1 year"));
$to = date("Y-m-d");



if (isset($_GET['from'])) {
  $from = date("Y-m-d",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
  $to = date("Y-m-d",strtotime($_GET['to']));
}

$rowCount=$db->single("SELECT count(*) FROM  orders  WHERE  deleted_01=0 and date(created_at)>= date(?) AND date(created_at)<=date(?) AND ".branch()->query("branch_id")."  ",[$from,$to]);;
$totalData = $rowCount;

$sql_data=[];
$sqlcount_data=[];


$sql = "
SELECT 
    orders.id,
    orders.created_at,
        DATE_FORMAT(orders.created_at, '%a %b %d %Y') AS formatted_created_at,

    users.name AS created_by_name,
    branches.name AS branch_name,
    (orders.price - orders.discount) AS final_price,
    GROUP_CONCAT(payments.method SEPARATOR ', ') AS payment_methods,
    orders.type,
    orders.status
FROM 
    orders
INNER JOIN 
    users ON orders.created_by = users.id
INNER JOIN 
    branches ON orders.branch_id = branches.id
LEFT JOIN 
    payments ON orders.id = payments.order_id
WHERE 
    orders.deleted_01 = 0 

    AND ".branch()->query("branches.id")." 

	

";

$sql_count = "
SELECT 
    count(*)
FROM 
    orders
INNER JOIN 
    users ON orders.created_by = users.id
INNER JOIN 
    branches ON orders.branch_id = branches.id
LEFT JOIN 
    payments ON orders.id = payments.order_id
WHERE 
    orders.deleted_01 = 0 

    AND ".branch()->query("branches.id")." 

	

";

$totalFiltered = $rowCount;
if( !empty($requestData['search']['value']) ) {   // if there is a search parameter, $requestData['search']['value'] contains search parameter

	$search = filter_var($requestData['search']['value'], FILTER_SANITIZE_STRING);
	
	// 
	

		$sql.=" AND ( orders.id LIKE ? "; 
	array_push($sql_data, "%".$search ."%");
	$sql.=" OR users.name LIKE ? ";
	array_push($sql_data, "%".$search ."%");
	$sql.=" OR branches.name LIKE ? ";
	array_push($sql_data, "%".$search ."%");


	$sql.=" )";


	$sql_count.=" AND ( orders.id LIKE ? "; 
	array_push($sqlcount_data, "%".$search ."%");
	$sql_count.=" OR users.name LIKE ? ";
	array_push($sqlcount_data, "%".$search ."%");
	$sql_count.=" OR branches.name LIKE ? ";
	array_push($sqlcount_data, "%".$search ."%");


	$sql_count.=" )";


	$sql_count.=" AND DATE(orders.created_at)>= date(?)  ";
	array_push($sqlcount_data, $from);
	$sql_count.=" AND DATE(orders.created_at)<= date(?)  ";
	array_push($sqlcount_data, $to);

	$totalFiltered = $db->single($sql_count,$sqlcount_data);
}
$sql.=" AND DATE(orders.created_at)>= date(?)  ";
array_push($sql_data, $from);
	$sql.=" AND DATE(orders.created_at)<= date(?)  ";
array_push($sql_data, $to);



$sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  LIMIT ".$requestData['start']." ,".$requestData['length']."   ";



$query         =$db->query($sql,$sql_data);






$data = array();

foreach ($query as $row) {

	$nestedData=array(); 

	$nestedData[] = $row["id"];
	$nestedData[] = escap($row["formatted_created_at"]);
	$nestedData[] = escap($row["created_at"]);
	$nestedData[] = escap($row["created_by_name"]);
	$nestedData[] = escap($row["branch_name"]);

	$nestedData[] = amount($row["final_price"]);
	$nestedData[] = $row['payment_methods'];
	$nestedData[] = $row['type'];
	$nestedData[] = $row['status'];
	
	$nestedData[] = '	<a href="'.add_to_url($app_url."/orders/",["v","i"],["view",$row['id']]).'" class="btn btn-sm btn-light  btn-action ">'.tr("View").'</a>';

	$data[] = $nestedData;
}


$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

echo json_encode($json_data);  // send data as json format
die();