<div class="card shadow">
	<div class="card-header bg-primary d-flex justify-content-between">
		<h3><?= tr("Order") ?> #<?= $data['id'] ?> <span class="badge rounded-pill px-2 border border-white badge-<?= $data['status']=="Completed"?'success':($data['status']=="Hold"?'warning':'danger') ?>"><?= tr($data['status']) ?></span></h3>
		<button type="button"  class="btn btn-light rounded-pill px-3 text-danger" data-toggle="modal" data-target="#cancel-modal"><?= tr("Cancel this order") ?></button>
	</div>
	<div class="card-body">
		
		<div class="card shadow table-responsive">
			<table class="table">
				<thead class="bg-primary">
					<tr>
						
						
						<th><?= tr("Created at") ?></th>
						<th><?= tr("created by") ?></th>
						<th><?= tr("Amount") ?></th>

						<th><?= tr("Payment method") ?></th>
						<th><?= tr("Branch") ?></th>
	
					</tr>
				</thead>
				<tbody>
					<?php foreach ($db->query("SELECT * FROM payments WHERE order_id=? AND deleted_01 = 0 ",[$data['id']]) as $key => $payment): ?>
						<tr>
				
							<td><?= $payment['created_at'] ?></td>
							<td><?= $user->get($payment['created_by'])->name ?></td>
							<td><?= amount($payment['amount']) ?></td>
				
						
							<td><?= $payment['method'] ?></td>
							<td><?= branch($payment['branch_id'])->name() ?></td>
		
						</tr>
					<?php endforeach ?>
					
				</tbody>
			</table>
		</div>
		<div class="card shadow table-responsive">
			<table class="table table-striped">
				<thead class="bg-primary">
					<tr>
						<th><?= tr("No.") ?></th>
						
						<th><?= tr("Dish") ?></th>
						<th><?= tr("Size") ?></th>
						<th><?= tr("Quantity") ?></th>
						<th><?= tr("Price") ?></th>
						
						<th><?= tr("Discount") ?></th>
						<th><?= tr("VAT") ?></th>
						<th><?= tr("Total") ?></th>
						
						
					</tr>
				</thead>
				<tbody>
					<?php $n=0; foreach ($db->query("SELECT * FROM order_data WHERE order_id = ? AND deleted_01 = 0 ",[$data['id']]) as $key => $item): ?>
					<tr>
						<td><?= ++$n ?></td>
						<td><?= $item['name'] ?></td>
						<td><?= $item['size'] ?></td>
						<td><?= $item['quantity'] ?></td>
						<td><?= amount($item['price']+$item['discount']) ?></td>
						<td><?= amount($item['discount']) ?></td>
						<td><?= amount($item['tax']) ?></td>
						
						<th><?= amount($item['quantity']*$item['price']) ?> </th>
						
					</tr>
					<?php endforeach ?>
					
				</tbody>
			</table>
			<div class="row justify-content-end">
				<div class="col-md-4 table-responsive">
					<table class="table border">
						<tr>
							<th><?= tr("Subtotal") ?></th>
							<th><?= amount($data['price']+$data['totaldiscount']-$data['tax']-$data['discount']) ?></th>
						</tr>
						<tr>
							<th><?= tr("VAT") ?></th>
							<th><?= amount($data['tax']) ?></th>
						</tr>
						<tr>
							<th><?= tr("Discount") ?></th>
							<th><?= amount($data['totaldiscount']) ?></th>
						</tr>
						<tr>
							<th><?= tr("Total") ?></th>
							<th><?= amount($data['price']-$data['discount']) ?></th>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</div>
	
</div>
<form method="post">
	<div class="modal fade" id="cancel-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title"><?= tr("Are you sure?") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<p><?= tr("This order will be canceled.") ?></p>
				</div>
				<div class="modal-footer">
					<button name="cancel" class="btn btn-primary"><?= tr("Yes") ?></button>
				</div>
			</div>
		</div>
	</div>

	<input type="hidden" name="id" value="<?= $data['id'] ?>">
</form>