<?php 
$root="../..";
	require($root."/php/init.php");


	$user->authorize("manage-refunds|add-refunds");

	$func=isset($_POST['function'])?$_POST['function']:$_GET['function'];
	
	switch ($func) {
		case 'get_bill':
			$bill_id=isset($_POST['bill_id'])?$_POST['bill_id']:0;
			$v->validate([
				tr("Invoice No")=>[$bill_id,"required|in_table(bills,id)"]
			]);

			if ($v->passes()) {
				$this_bill = $bill->getBillById($bill_id)[0];

				$total_refund=$db->single("SELECT sum(price) FROM refunds WHERE bill_id = ? AND deleted_01 = 0 ",[$bill_id]);
				die(
					json_encode([
						"data"=>[
							"customer"   =>$customer->get($this_bill['c_id'])->name,
							"customer_credit"   =>amount(-$customer->getCustomerBalanceById($this_bill['c_id'])),
							"price"     =>amount($this_bill['price']-$this_bill['discount']-$total_refund),
							"paid"      =>amount($this_bill['amount']-$total_refund),
							"balance"      =>amount($this_bill['price']-$this_bill['discount']-$this_bill['amount']-$total_refund),
							"created_at" =>$this_bill['created_at'],
							"created_by" =>$user->get($this_bill['created_by'])->name,
							"phone"      =>$customer->get($this_bill['c_id'])->phone,
							"items"      =>$bill->getBillDetailsWithProducts($bill_id)
			
						],
						"errors"=>[]
					])
				);
			}else{
				die(
					json_encode([
						"errors"=>$v->errors()->all(),
						"data"=>[]
					])
				);
			}
			
		break;

		case 'get_item':
			$code=isset($_POST['code'])?$_POST['code']:0;
			$v->validate([
				tr("Item code")=>[$code,"required|in_table(products,barcode)"]
			]);

			if ($v->passes()) {
				$this_item= $product->getProductByBarcode($code);
				die(
					json_encode([
						"data"=>$this_item[0],
						"errors"=>[]
					])
				);
			}else{
				die(
					json_encode([
						"errors"=>$v->errors()->all(),
						"data"=>[]
					])
				);
			}
		break;
		
		default:
			# code...
			break;
	}