<?php 


 ?>
<div class="row" id="new_refund">
	<div class="col">
		<div class="card">
			<div class="card-header d-flex">
				<div class="col">
					<h5><?= tr("Edit refund") ?></h5>
				</div>
				<div class="col text-end">
					<button class="btn btn-danger" data-toggle="modal" data-target="#delete-modal" title="<?= tr("Delete") ?>"><i class="far fa-trash-alt"></i></button>
				</div>
			</div>
			<div class="card-body row">
				<div class="col">
					<form action="<?= $this_url ?>" method="post">

						<label  ><?= tr("Invoice No") ?>*</label>
					      <div class="input-group mb-2">
					        <div class="input-group-prepend" @click="get_bill">
					          <div class="input-group-text btn btn-primary" ><i class="fas fa-search"></i></div>
					        </div>
					        <input type="text" class="form-control" name="bill_id" v-model="bill_id" @keyup.enter="get_bill" value="<?= old("bill_id",$refund['bill_id']) ?>" placeholder="<?= tr("Invoice No") ?>">
					      </div>
					      <br>
					      <div class="input-group mb-2">
					        <div class="input-group-prepend" @click="get_item">
					          <div class="input-group-text btn btn-primary" ><i class="fas fa-search"></i></div>
					        </div>
					        <input type="text" class="form-control" name="code" v-model="code" @keyup.enter="get_item" value="<?= old("code",$product->getProductById($refund['p_id'])[0]['barcode']) ?>" placeholder="<?= tr("Item code") ?>">
					      </div>


					      <br>

					      <label for=""><?= tr("Qunatity") ?></label>
					      <input type="number" class="form-control  text-center" name="quantity" step="0.1" value="<?= old("quantity",$refund['quantity']) ?>"><br>

					      <label for=""><?= tr("Price") ?></label>
					      <input type="number" class="form-control text-center" name="price" step="0.1" v-model="price" value="<?= old("price") ?>"><br>

						<label for=""><?= tr("Note") ?></label>
						<textarea class="form-control" name="note"><?= old("note",$refund['note']) ?></textarea>

						<br>

				

		

						<br>
						<button class="btn btn-primary rounded-pill" name="new_refund"><?= tr("Submit") ?></button>
					</form>
				</div>

				<div class="col">
					<table class="table table-borderless table-sm" v-if="bill_data.customer">
						<tr>
							<th><?= tr("Customer") ?></th>
							<td>{{bill_data.customer}} ({{bill_data.customer_credit}})</td>
						</tr>
						<tr>
							<th><?= tr("Price") ?></th>
							<td>{{bill_data.price}}</td>
						</tr>
						<tr>
							<th><?= tr("Paid") ?></th>
							<td>{{bill_data.paid}}</td>
						</tr>

						<tr>
							<th><?= tr("Created at") ?></th>
							<td>{{bill_data.created_at}}</td>
						</tr>
						<tr>
							<th><?= tr("Created by") ?></th>
							<td>{{bill_data.created_by}}</td>
						</tr>
						<tr>
							<th><?= tr("Details") ?></th>
							<td>
								<div class="list-group">
								
								  <a v-for="item in bill_data.items"  @click="code=item.barcode" href="#" class="list-group-item list-group-item-action" v-if="item.p_type=='R'">{{item.name}} [{{item.barcode}}] x{{item.quantity}}</a>
						
								</div>
							</td>
						</tr>
					</table>

					<table class="table table-borderless table-sm" v-if="item.name">
						<tr>
							<th><?= tr("Item") ?></th>
							<td>{{item.name}}</td>
						</tr>
						<tr>
							<th><?= tr("Price") ?></th>
							<td>{{item.price}}</td>
						</tr>
					
					</table>

				</div>
				
		
			</div>
			
		</div>
	</div>
	
</div>
<form method="post" action="<?= remove_from_url($this_url,["v","i"]) ?>">
<div class="modal" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="delete-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-modalLabel"><?= tr("Are you sure?") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?= tr("This modal will be deleted.") ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary rounded-pill" data-dismiss="modal"><?= tr("Cancel") ?></button>
        <button name="delete_refund" class="btn btn-primary rounded-pill"><?= tr("Yes") ?></button>
      </div>
    </div>
  </div>
</div>
<input type="hidden" name="id" value="<?= $refund['id'] ?>" >

</form>
<script>
	const new_refund = new Vue({
		el:"#new_refund",
		data:{
			bill_id:'<?= old("bill_id",$refund['bill_id']) ?>',
			code:'<?= old("code",$product->getProductById($refund['p_id'])[0]['barcode']) ?>',
			price:'<?= old("price",$refund['bill_id']) ?>',
			bill_data:[],
			item:[]

		},
		methods:{
			get_bill(){
				let job =this;


				$.post('<?= $app_url ?>/refunds/ajax/', 
				{
					'function': 'get_bill',
					'bill_id': job.bill_id,

				}, 
				function(data, textStatus, xhr) {
					
					data.errors.forEach( function(element, index) {
						notifi(element,'danger')
					});

					job.bill_data=data.data
					job.item=[]
				},'json');
			},
			get_item(){
				let job =this;


				$.post('<?= $app_url ?>/refunds/ajax/', 
				{
					'function': 'get_item',
					'code': job.code,

				}, 
				function(data, textStatus, xhr) {
					
					data.errors.forEach( function(element, index) {
						notifi(element,'danger')
					});
					job.bill_data=[]
					job.item=data.data

				
				},'json');
			}
		}
	})
</script>


		