<div class="row" id="new_payment">
	<div class="col">
		<div class="card">
			<div class="card-header d-flex">
				<div class="col">
					<h5><?= tr("New payment") ?></h5>
				</div>
				<div class="col"></div>
			</div>
			<div class="card-body row">
				<div class="col-sm-5">
					<form action="<?= remove_from_url($this_url,["v","i"]) ?>" method="post" autocomplete="off">
						<label  ><?= tr("Invoice No") ?>*</label>
						<div class="input-group mb-2">
							<div class="input-group-prepend" @click="get_bill">
								<div class="input-group-text btn btn-primary" ><i class="fas fa-search"></i></div>
							</div>
							<input type="text" autofocus class="form-control" name="bill_id" v-model="bill_id" @keyup.enter="get_bill" value="<?= old("bill_id",$bill_id) ?>" placeholder="<?= tr("Invoice No") ?>" autoselect="1">
						</div>
						<br>
						
						<label for=""><?= tr("Amount") ?></label>
						<input type="number" class="form-control text-center" name="pay_amount" step="0.001" required="" min="0.1"  value="<?= old("amount") ?>"><br>


						<label for=""><?= tr("Payment method") ?></label>
						<select class="form-control text-center" v-model="method" name="pay_by">
							<?php foreach ($payment_methods as $key => $value): ?>
							<option  value="<?= $value ?>"><?= tr($value) ?></option>
							<?php endforeach ?>
						</select><br>


						<div  v-show="(method == 'cheque') ? true : false">
			              <label class="" for=""><?= $lang['cheque_no'] ?></label>
			              <input type="text" class="form-control text-center" name="cheque_no"><br>
			            </div>
			            <div   v-show="(method == 'cheque') ? true : false">
			              <label class="" for=""><?= $lang['cheque_date'] ?></label>
			              <input type="text " class="form-control text-center date-input" name="due_date"><br>
			            </div>

			            <?php if (can('discount')): ?>
			            	<label for=""><?= tr("Discount") ?></label>
							<input type="number" class="form-control text-center" name="discount" step="0.001" min="0"  value="<?= old("discount",0) ?>"><br>
			            <?php endif ?>

						<label for=""><?= tr("Note") ?></label>
						<textarea class="form-control" name="note"><?= old("note") ?></textarea>
						<br>
						
						
						<br>
						<button class="btn btn-primary rounded-pill" name="new_payment"><?= tr("Submit") ?></button>
					</form>
				</div>
				<div class="col-sm-7">
					<table class="table table-borderless table-sm" v-if="bill_data.customer">
						<tr>
							<th><?= tr("Customer") ?></th>
							<td>{{bill_data.customer}} ({{bill_data.customer_credit}})</td>
						</tr>
						<tr>
							<th><?= tr("Price") ?></th>
							<td  class="text-monospace">{{bill_data.price}}</td>
						</tr>
						<tr>
							<th><?= tr("Paid") ?></th>
							<td  class="text-monospace">{{bill_data.paid}}</td>
						</tr>
						<tr class="table-active">
							<th><?= tr("Balance") ?></th>
							<td class="text-monospace font-weight-black">{{bill_data.balance}}</td>
						</tr>
						<tr>
							<th><?= tr("Created at") ?></th>
							<td  class="text-monospace">{{bill_data.created_at}}</td>
						</tr>
						<tr>
							<th><?= tr("Created by") ?></th>
							<td>{{bill_data.created_by}}</td>
						</tr>
						<tr>
							<th><?= tr("Details") ?></th>
							<td></td>
						</tr>
						<tr>
							
							
						</tr>
					</table>

						<table class="table table-sm border table-striped table-hover"  v-if="bill_data.customer">
									<thead class="bg-info-800 text-white">
										<tr>
											<td><?= tr("Item") ?></td>
									
											<td><?= tr("Price") ?></td>
											<td><?= tr("Qty") ?></td>
											<td><?= tr("Refund") ?></td>
										</tr>
									</thead>
									<tbody>
										<tr v-for="item in bill_data.items"   >
											<td>{{item.name}}</td>
										
											<td>{{item.price}}</td>
											<td>x{{item.quantity}}</td>
											
											<td>x{{item.refund?item.refund:0}}</td>
										</tr>
									</tbody>
									
								</table>
								
					
				</div>
				
				
			</div>
			
		</div>
	</div>
	
</div>
<script>
	const new_refund = new Vue({
		el:"#new_payment",
		data:{
			bill_id:'<?= old("bill_id",$bill_id) ?>',
			code:'<?= old("code") ?>',
			method:'cash',
			bill_data:[],
			item:[]

		},
		methods:{
			get_bill(){
				let job =this;


				$.post('<?= $app_url ?>/payments/ajax/', 
				{
					'function': 'get_bill',
					'bill_id': job.bill_id,

				}, 
				function(data, textStatus, xhr) {
					
					data.errors.forEach( function(element, index) {
						notifi(element,'danger')
					});

					job.bill_data=data.data
					job.item=[]
				},'json');
			},
	
		}
	})
</script>


		